/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.item.custom;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import s22.new_mod.effect.ModEffects;
import s22.new_mod.entity.custom.HematicSerenityEntity;

public class SpiderInhibitorItem
extends class_1792 {
    private static final int BASE_DURATION = 200;
    private static final double SPREAD_RADIUS = 8.0;
    private static final boolean ENABLE_USE_FEEDBACK = true;

    public SpiderInhibitorItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        class_1937 world = user.method_37908();
        if (!world.method_8608()) {
            HematicSerenityEntity boss;
            InhibitionEffect effect;
            boolean success = false;
            String effectDescription = "";
            if (entity instanceof class_1628) {
                class_1628 spider = (class_1628)entity;
                InhibitionEffect effect2 = this.calculateInhibitionEffect((class_1309)spider, user, false);
                if (effect2 != null && this.applyInhibitionToSpider(spider, user)) {
                    success = true;
                    this.spreadToNearbySpiders(world, spider.method_19538(), user);
                }
            } else if (entity instanceof HematicSerenityEntity && (effect = this.calculateInhibitionEffect((class_1309)(boss = (HematicSerenityEntity)entity), user, true)) != null && effect.effectLevel > 0 && this.applyInhibitionToBoss(boss, user)) {
                success = true;
                this.spreadToNearbySpiders(world, boss.method_19538(), user);
            }
            if (success) {
                if (!user.method_7337()) {
                    stack.method_7934(1);
                }
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14826, user.method_5634(), 1.0f, 0.8f);
                this.spawnUseSuccessParticles(world, user.method_19538());
            }
        }
        return class_1269.field_5811;
    }

    private boolean applyInhibitionToSpider(class_1628 spider, class_1657 user) {
        InhibitionEffect effect = this.calculateInhibitionEffect((class_1309)spider, user, false);
        if (effect != null) {
            spider.method_18800(0.0, spider.method_18798().field_1351, 0.0);
            spider.field_6007 = true;
            spider.method_5942().method_6340();
            spider.method_5980(null);
            spider.method_6092(new class_1293(class_1294.field_5909, effect.duration, 10, false, false));
            spider.method_6092(new class_1293(class_1294.field_5911, effect.duration, 10, false, false));
            spider.method_6092(new class_1293(ModEffects.INHIBITION, effect.duration, effect.effectLevel - 1, false, false));
            this.spawnInhibitionParticles(spider.method_37908(), spider.method_19538(), effect.effectLevel);
            spider.method_37908().method_43128(null, spider.method_23317(), spider.method_23318(), spider.method_23321(), class_3417.field_14657, spider.method_5634(), 1.0f, 0.5f);
            return true;
        }
        return false;
    }

    private boolean applyInhibitionToBoss(HematicSerenityEntity boss, class_1657 user) {
        InhibitionEffect effect = this.calculateInhibitionEffect((class_1309)boss, user, true);
        if (effect != null && effect.effectLevel > 0) {
            boss.applyInhibitionEffect(effect.effectLevel, effect.duration, user);
            this.spawnBossInhibitionParticles(boss.method_37908(), boss.method_19538(), effect.effectLevel);
            boss.method_37908().method_43128(null, boss.method_23317(), boss.method_23318(), boss.method_23321(), class_3417.field_14671, boss.method_5634(), 0.8f, 1.2f);
            return true;
        }
        return false;
    }

    private void spreadToNearbySpiders(class_1937 world, class_243 center, class_1657 user) {
        class_238 spreadBox = new class_238(center.method_1031(-8.0, -8.0, -8.0), center.method_1031(8.0, 8.0, 8.0));
        List spreadTargets = world.method_8390(class_1628.class, spreadBox, class_1309::method_5805);
        int spreadCount = 0;
        for (class_1628 spider : spreadTargets) {
            InhibitionEffect spreadEffect = this.calculateInhibitionEffect((class_1309)spider, user, false);
            if (spreadEffect == null) continue;
            int spreadDuration = spreadEffect.duration / 2;
            int spreadLevel = Math.max(1, spreadEffect.effectLevel - 1);
            spider.method_6092(new class_1293(class_1294.field_5909, spreadDuration, 8, false, false));
            spider.method_6092(new class_1293(class_1294.field_5911, spreadDuration, 8, false, false));
            spider.method_6092(new class_1293(ModEffects.INHIBITION, spreadDuration, spreadLevel - 1, false, false));
            this.spawnSpreadParticles(world, center, spider.method_19538());
            ++spreadCount;
        }
        if (spreadCount > 0) {
            user.method_7353((class_2561)class_2561.method_43470((String)("\u6291\u5236\u5242\u6548\u679c\u6269\u6563\u5230 " + spreadCount + " \u53ea\u9644\u8fd1\u8718\u86db")).method_27692(class_124.field_1078), false);
        }
    }

    private InhibitionEffect calculateInhibitionEffect(class_1309 target, class_1657 user, boolean isBoss) {
        if (isBoss) {
            return this.calculateBossInhibitionEffect((HematicSerenityEntity)target, user);
        }
        return this.calculateSpiderInhibitionEffect((class_1628)target, user);
    }

    private InhibitionEffect calculateSpiderInhibitionEffect(class_1628 spider, class_1657 user) {
        return new InhibitionEffect(3, 200);
    }

    private InhibitionEffect calculateBossInhibitionEffect(HematicSerenityEntity boss, class_1657 user) {
        float healthRatio = boss.method_6032() / boss.method_6063();
        int recentInhibitions = boss.getRecentInhibitionCount();
        boolean isEnraged = boss.isVoidRage();
        int playerCount = boss.method_37908().method_18456().size();
        int baseEffectLevel = this.calculateBaseEffectLevel(healthRatio, isEnraged, recentInhibitions, playerCount);
        int duration = this.calculateDuration(baseEffectLevel, healthRatio, recentInhibitions);
        return new InhibitionEffect(baseEffectLevel, duration);
    }

    private int calculateBaseEffectLevel(float healthRatio, boolean isEnraged, int recentInhibitions, int playerCount) {
        int effectLevel = 3;
        if (healthRatio < 0.3f) {
            effectLevel -= 2;
        } else if (healthRatio < 0.6f) {
            --effectLevel;
        }
        if (isEnraged) {
            effectLevel = Math.max(1, effectLevel - 1);
        }
        effectLevel = Math.max(0, effectLevel - recentInhibitions / 2);
        effectLevel = Math.max(1, effectLevel - (playerCount - 1));
        return effectLevel;
    }

    private int calculateDuration(int effectLevel, float healthRatio, int recentInhibitions) {
        int baseDuration = 100;
        baseDuration = (int)((float)baseDuration * ((float)effectLevel / 3.0f));
        if (healthRatio < 0.2f) {
            baseDuration /= 2;
        }
        baseDuration = (int)((double)baseDuration * Math.pow(0.8, recentInhibitions));
        return Math.max(20, baseDuration);
    }

    private void spawnInhibitionParticles(class_1937 world, class_243 pos, int effectLevel) {
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < 10 + effectLevel * 5; ++i) {
            world.method_8406((class_2394)class_2398.field_23190, pos.field_1352 + (world.field_9229.method_43058() - 0.5) * 2.0, pos.field_1351 + world.field_9229.method_43058() * 2.0, pos.field_1350 + (world.field_9229.method_43058() - 0.5) * 2.0, 0.0, 0.1, 0.0);
        }
    }

    private void spawnBossInhibitionParticles(class_1937 world, class_243 pos, int effectLevel) {
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < 30 + effectLevel * 10; ++i) {
            if (world.field_9229.method_43056()) {
                world.method_8406((class_2394)class_2398.field_11216, pos.field_1352 + (world.field_9229.method_43058() - 0.5) * 3.0, pos.field_1351 + world.field_9229.method_43058() * 3.0, pos.field_1350 + (world.field_9229.method_43058() - 0.5) * 3.0, 0.0, 0.2, 0.0);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_29644, pos.field_1352 + (world.field_9229.method_43058() - 0.5) * 3.0, pos.field_1351 + world.field_9229.method_43058() * 3.0, pos.field_1350 + (world.field_9229.method_43058() - 0.5) * 3.0, 0.0, 0.15, 0.0);
        }
    }

    private void spawnSpreadParticles(class_1937 world, class_243 from, class_243 to) {
        if (world.method_8608()) {
            return;
        }
        int steps = 10;
        class_243 direction = to.method_1020(from).method_1021(1.0 / (double)steps);
        for (int i = 0; i <= steps; ++i) {
            class_243 particlePos = from.method_1019(direction.method_1021((double)i));
            world.method_8406((class_2394)class_2398.field_22246, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.05, 0.0);
        }
    }

    private void spawnUseSuccessParticles(class_1937 world, class_243 pos) {
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            world.method_8406((class_2394)class_2398.field_11211, pos.field_1352 + (world.field_9229.method_43058() - 0.5), pos.field_1351 + 1.0 + world.field_9229.method_43058(), pos.field_1350 + (world.field_9229.method_43058() - 0.5), 0.0, 0.1, 0.0);
        }
    }

    private static class InhibitionEffect {
        public final int effectLevel;
        public final int duration;

        public InhibitionEffect(int effectLevel, int duration) {
            this.effectLevel = effectLevel;
            this.duration = duration;
        }
    }
}

