/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.world;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class TimeFreezeManager {
    private static final Map<UUID, TimeFreezeArea> activeFreezes = new HashMap<UUID, TimeFreezeArea>();
    private static final Map<UUID, EntityState> frozenEntities = new HashMap<UUID, EntityState>();

    public static UUID createTimeFreeze(class_3218 world, class_2338 center, UUID creator, int radius, int duration) {
        UUID freezeId = UUID.randomUUID();
        TimeFreezeArea area = new TimeFreezeArea(center, world.method_8510(), creator, radius, duration);
        activeFreezes.put(freezeId, area);
        TimeFreezeManager.freezeEntitiesInArea(world, area);
        return freezeId;
    }

    private static void freezeEntitiesInArea(class_3218 world, TimeFreezeArea area) {
        class_238 areaBox = area.getAreaBox();
        for (class_1297 entity : world.method_8390(class_1297.class, areaBox, e -> !(e instanceof class_1657) && e.method_5805())) {
            frozenEntities.put(entity.method_5667(), new EntityState(entity));
            entity.method_18799(class_243.field_1353);
            entity.method_5875(true);
            entity.field_6037 = true;
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            mob.method_5977(true);
            mob.method_5942().method_6340();
            mob.method_5980(null);
        }
    }

    public static void tick(class_3218 world) {
        if (activeFreezes.isEmpty()) {
            return;
        }
        long currentTime = world.method_8510();
        Iterator<Map.Entry<UUID, TimeFreezeArea>> iterator = activeFreezes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, TimeFreezeArea> entry = iterator.next();
            TimeFreezeArea area = entry.getValue();
            if (area.isExpired(currentTime)) {
                TimeFreezeManager.releaseTimeFreeze(world, area);
                iterator.remove();
                continue;
            }
            TimeFreezeManager.maintainTimeFreeze(world, area);
        }
    }

    private static void maintainTimeFreeze(class_3218 world, TimeFreezeArea area) {
        class_238 areaBox = area.getAreaBox();
        for (class_1297 class_12972 : world.method_8390(class_1297.class, areaBox, e -> !(e instanceof class_1657) && e.method_5805() && !frozenEntities.containsKey(e.method_5667()))) {
            frozenEntities.put(class_12972.method_5667(), new EntityState(class_12972));
            class_12972.method_18799(class_243.field_1353);
            class_12972.method_5875(true);
            if (!(class_12972 instanceof class_1308)) continue;
            class_1308 mob = (class_1308)class_12972;
            mob.method_5977(true);
        }
        for (Map.Entry entry : frozenEntities.entrySet()) {
            class_1297 entity = world.method_14190((UUID)entry.getKey());
            if (entity == null || !entity.method_5805() || !areaBox.method_1006(entity.method_19538())) continue;
            EntityState originalState = (EntityState)entry.getValue();
            if (!entity.method_19538().equals((Object)originalState.position)) {
                entity.method_33574(originalState.position);
            }
            if (!entity.method_18798().equals((Object)class_243.field_1353)) {
                entity.method_18799(class_243.field_1353);
            }
            entity.method_36456(originalState.yaw);
            entity.method_36457(originalState.pitch);
            entity.field_6012 = originalState.frozenTick;
        }
    }

    private static void releaseTimeFreeze(class_3218 world, TimeFreezeArea area) {
        class_238 areaBox = area.getAreaBox();
        Iterator<Map.Entry<UUID, EntityState>> iterator = frozenEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, EntityState> entry = iterator.next();
            class_1297 entity = world.method_14190(entry.getKey());
            if (entity == null || !areaBox.method_1006(entity.method_19538())) continue;
            EntityState state = entry.getValue();
            entity.method_5875(false);
            entity.method_18799(state.velocity);
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5977(false);
            }
            iterator.remove();
        }
        class_1657 creator = world.method_18470(area.creator);
        if (creator != null) {
            creator.method_7353((class_2561)class_2561.method_43470((String)"\u23f0 \u65f6\u505c\u6548\u679c\u7ed3\u675f").method_27692(class_124.field_1080), true);
        }
    }

    public static boolean isEntityFrozen(UUID entityUuid) {
        return frozenEntities.containsKey(entityUuid);
    }

    public static int getActiveFreezeCount() {
        return activeFreezes.size();
    }

    public static void cancelAllTimeFreezes(class_3218 world) {
        for (TimeFreezeArea area : activeFreezes.values()) {
            TimeFreezeManager.releaseTimeFreeze(world, area);
        }
        activeFreezes.clear();
    }

    public static class TimeFreezeArea {
        public final class_2338 center;
        public final long startTime;
        public final UUID creator;
        public final int radius;
        public final int duration;

        public TimeFreezeArea(class_2338 center, long startTime, UUID creator, int radius, int duration) {
            this.center = center;
            this.startTime = startTime;
            this.creator = creator;
            this.radius = radius;
            this.duration = duration;
        }

        public boolean isExpired(long currentTime) {
            return currentTime - this.startTime >= (long)this.duration;
        }

        public class_238 getAreaBox() {
            return new class_238(this.center.method_10069(-this.radius, -this.radius, -this.radius));
        }
    }

    public static class EntityState {
        public final class_243 position;
        public final class_243 velocity;
        public final float yaw;
        public final float pitch;
        public final int frozenTick;

        public EntityState(class_1297 entity) {
            this.position = entity.method_19538();
            this.velocity = entity.method_18798();
            this.yaw = entity.method_36454();
            this.pitch = entity.method_36455();
            this.frozenTick = entity.field_6012;
        }
    }
}

