/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import s22.new_mod.block.ModBlocks;

public class ThunderOreGenerator {
    private static final List<class_2248> CONVERTIBLE_BLOCKS = Arrays.asList(class_2246.field_10340, class_2246.field_28888, class_2246.field_10255, class_2246.field_10445, class_2246.field_10115, class_2246.field_10474, class_2246.field_10508, class_2246.field_10566, class_2246.field_10219, class_2246.field_10102, class_2246.field_9979);
    private static final double GENERATION_CHANCE = 15.0;
    private static final int GENERATION_RADIUS = 10;

    public static void handleLightningStrike(class_3218 world, class_2338 strikePos) {
        if (!ThunderOreGenerator.isThunderstorm(world)) {
            return;
        }
        System.out.println("\u68c0\u6d4b\u5230\u96f7\u96e8\u5929\u95ea\u7535\uff0c\u4f4d\u7f6e: " + String.valueOf(strikePos));
        ThunderOreGenerator.generateThunderOreAround(world, strikePos);
    }

    private static boolean isThunderstorm(class_3218 world) {
        return world.method_8546() || world.method_8419();
    }

    private static void generateThunderOreAround(class_3218 world, class_2338 center) {
        int oreCount = 0;
        int attempts = 0;
        int maxAttempts = 25;
        int maxOres = 3;
        class_5819 random = world.field_9229;
        System.out.println("\u5f00\u59cb\u5728\u5730\u8868\u751f\u6210\u96f7\u77ff\uff0c\u4e2d\u5fc3: " + String.valueOf(center));
        while (oreCount < 3 && attempts < 25) {
            ++attempts;
            int offsetX = random.method_43048(21) - 10;
            int offsetZ = random.method_43048(21) - 10;
            class_2338 checkPos = center.method_10069(offsetX, 0, offsetZ);
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13197, checkPos);
            boolean oreGenerated = false;
            class_2338 belowSurface = surfacePos.method_10074();
            if (!oreGenerated && ThunderOreGenerator.canConvertBlock(world, belowSurface) && random.method_43058() * 100.0 < 15.0) {
                ThunderOreGenerator.convertToThunderOre(world, belowSurface);
                ++oreCount;
                oreGenerated = true;
                System.out.println("\u5728\u5730\u8868\u4e0b1\u683c\u751f\u6210\u96f7\u77ff: " + String.valueOf(belowSurface));
            }
            if (!oreGenerated && ThunderOreGenerator.canConvertBlock(world, surfacePos) && random.method_43058() * 100.0 < 15.0) {
                ThunderOreGenerator.convertToThunderOre(world, surfacePos);
                ++oreCount;
                oreGenerated = true;
                System.out.println("\u5728\u5730\u8868\u751f\u6210\u96f7\u77ff: " + String.valueOf(surfacePos));
            }
            class_2338 twoBelow = surfacePos.method_10087(2);
            if (oreGenerated || oreCount >= 2 || !ThunderOreGenerator.canConvertBlock(world, twoBelow) || !(random.method_43058() * 100.0 < 15.0)) continue;
            ThunderOreGenerator.convertToThunderOre(world, twoBelow);
            ++oreCount;
            oreGenerated = true;
            System.out.println("\u5728\u5730\u8868\u4e0b2\u683c\u751f\u6210\u96f7\u77ff: " + String.valueOf(twoBelow));
        }
        System.out.println("\u96f7\u77ff\u751f\u6210\u5b8c\u6210: " + oreCount + " \u4e2a\u96f7\u77ff");
        if (oreCount == 0) {
            ThunderOreGenerator.debugSurfaceConditions(world, center);
        }
    }

    private static void generateThunderOreMinimal(class_3218 world, class_2338 center) {
        class_2338[] directions;
        int oreCount = 0;
        class_5819 random = world.field_9229;
        System.out.println("\u4f7f\u7528\u6781\u7b80\u6a21\u5f0f\u751f\u6210\u96f7\u77ff");
        for (class_2338 dirPos : directions = new class_2338[]{center.method_10076(3), center.method_10077(3), center.method_10089(3), center.method_10088(3)}) {
            if (oreCount >= 2) break;
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13197, dirPos);
            class_2338 belowSurface = surfacePos.method_10074();
            if (!ThunderOreGenerator.canConvertBlock(world, belowSurface) || !(random.method_43058() < 0.4)) continue;
            ThunderOreGenerator.convertToThunderOre(world, belowSurface);
            ++oreCount;
            System.out.println("\u6781\u7b80\u6a21\u5f0f\u751f\u6210\u96f7\u77ff: " + String.valueOf(belowSurface));
        }
        System.out.println("\u6781\u7b80\u6a21\u5f0f\u5b8c\u6210: " + oreCount + " \u4e2a\u96f7\u77ff");
    }

    private static void debugSurfaceConditions(class_3218 world, class_2338 center) {
        System.out.println("=== \u5730\u8868\u6761\u4ef6\u8c03\u8bd5 ===");
        System.out.println("\u4e16\u754c\u662f\u5426\u96f7\u96e8: " + ThunderOreGenerator.isThunderstorm(world));
        class_5819 random = world.field_9229;
        for (int i = 0; i < 3; ++i) {
            int offsetX = random.method_43048(6) - 3;
            int offsetZ = random.method_43048(6) - 3;
            class_2338 checkPos = center.method_10069(offsetX, 0, offsetZ);
            class_2338 surfacePos = world.method_8598(class_2902.class_2903.field_13197, checkPos);
            class_2680 surfaceState = world.method_8320(surfacePos);
            class_2680 belowState = world.method_8320(surfacePos.method_10074());
            System.out.println("\u4f4d\u7f6e " + String.valueOf(checkPos) + " - \u5730\u8868: " + String.valueOf(surfaceState.method_26204()) + ", \u5730\u4e0b: " + String.valueOf(belowState.method_26204()));
        }
        System.out.println("=================");
    }

    private static boolean canConvertBlock(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return CONVERTIBLE_BLOCKS.contains(state.method_26204());
    }

    private static void convertToThunderOre(class_3218 world, class_2338 pos) {
        class_2680 thunderOreState = ModBlocks.THUNDER_ORE.method_9564();
        world.method_8652(pos, thunderOreState, 3);
        ThunderOreGenerator.spawnConversionParticles(world, pos);
    }

    private static void spawnConversionParticles(class_3218 world, class_2338 pos) {
        class_243 particlePos = class_243.method_24953((class_2382)pos);
        for (int i = 0; i < 5; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = world.field_9229.method_43058() * 2.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 2, offsetX, offsetY, offsetZ, 0.1);
        }
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15026, class_3419.field_15245, 0.5f, 1.0f);
    }
}

