/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.client;

import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class VoidEffectManager {
    private static int voidEffectTimer = 0;
    private static int nextSoundTime = 0;
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final class_2960 VOID_TEXTURE = class_2960.method_60655((String)"new-mod", (String)"textures/misc/void.png");
    private static final class_3414[] HEART_SOUNDS = new class_3414[]{class_3417.field_38068, class_3417.field_38060, class_3417.field_28081, class_3417.field_38074, class_3417.field_38073, class_3417.field_38062};
    private static final class_3414[] BREATH_SOUNDS = new class_3414[]{class_3417.field_14726, class_3417.field_15205, class_3417.field_14813, class_3417.field_14729, class_3417.field_14680, class_3417.field_14980};
    private static final class_3414[] WHISPER_SOUNDS = new class_3414[]{class_3417.field_14812, class_3417.field_14782, class_3417.field_14644, class_3417.field_14898, class_3417.field_14858, class_3417.field_14545};
    private static final class_3414[] HORROR_SOUNDS = new class_3414[]{class_3417.field_14632, class_3417.field_15071, class_3417.field_19197, class_3417.field_14802, class_3417.field_14967, class_3417.field_14879, class_3417.field_19167, class_3417.field_15127, class_3417.field_15203, class_3417.field_15163, class_3417.field_14792, class_3417.field_14639, class_3417.field_14566, class_3417.field_15130, class_3417.field_14816, class_3417.field_37364, class_3417.field_38060};

    public static void showVoidImage(int duration) {
        voidEffectTimer = duration;
        nextSoundTime = RANDOM.method_43048(10) + 5;
    }

    public static void tick() {
        class_310 client = class_310.method_1551();
        if (voidEffectTimer > 0 && client.field_1687 != null && client.field_1724 != null) {
            VoidEffectManager.manageRandomSounds();
            VoidEffectManager.spawnWorldParticles(client.field_1687, client.field_1724.method_19538());
            if (--voidEffectTimer <= 0) {
                VoidEffectManager.stopAllSounds();
            }
        }
    }

    public static void render(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (voidEffectTimer > 0 && client.field_1687 != null && client.field_1724 != null) {
            int width = client.method_22683().method_4486();
            int height = client.method_22683().method_4502();
            float alpha = VoidEffectManager.calculateAlpha();
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, -150.0f);
            context.method_51422(1.0f, 1.0f, 1.0f, alpha);
            context.method_25290(VOID_TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            VoidEffectManager.renderChaoticEffects(context, width, height, alpha, tickDelta);
            context.method_51448().method_22909();
        }
    }

    private static void manageRandomSounds() {
        if (nextSoundTime <= 0) {
            VoidEffectManager.playRandomSound();
            nextSoundTime = RANDOM.method_43048(80) + 2;
        } else {
            --nextSoundTime;
        }
    }

    private static void playRandomSound() {
        class_310 client = class_310.method_1551();
        if (client.method_1483() == null) {
            return;
        }
        class_3414 sound = VoidEffectManager.getRandomSound();
        float volume = 0.3f + RANDOM.method_43057() * 0.6f;
        float pitch = 0.5f + RANDOM.method_43057() * 1.0f;
        class_1109 soundInstance = class_1109.method_4757((class_3414)sound, (float)volume, (float)pitch);
        client.method_1483().method_4873((class_1113)soundInstance);
    }

    private static class_3414 getRandomSound() {
        int soundType = RANDOM.method_43048(100);
        if (soundType < 25) {
            return HEART_SOUNDS[RANDOM.method_43048(HEART_SOUNDS.length)];
        }
        if (soundType < 45) {
            return BREATH_SOUNDS[RANDOM.method_43048(BREATH_SOUNDS.length)];
        }
        if (soundType < 65) {
            return WHISPER_SOUNDS[RANDOM.method_43048(WHISPER_SOUNDS.length)];
        }
        return HORROR_SOUNDS[RANDOM.method_43048(HORROR_SOUNDS.length)];
    }

    private static void renderChaoticEffects(class_332 context, int width, int height, float alpha, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (RANDOM.method_43057() < 0.7f) {
            VoidEffectManager.renderRandomFlash(context, width, height, alpha);
        }
        if (RANDOM.method_43057() < 0.4f) {
            VoidEffectManager.renderDistortionEffect(context, width, height, alpha);
        }
        if (RANDOM.method_43057() < 0.3f) {
            VoidEffectManager.renderPulseEffect(context, width, height, alpha, tickDelta);
        }
        if (RANDOM.method_43057() < 0.2f) {
            VoidEffectManager.renderStaticNoise(context, width, height, alpha);
        }
    }

    private static void renderRandomFlash(class_332 context, int width, int height, float alpha) {
        int color = VoidEffectManager.getRandomHorrorColor();
        float flashAlpha = alpha * (0.1f + RANDOM.method_43057() * 0.4f);
        int flashType = RANDOM.method_43048(4);
        switch (flashType) {
            case 0: {
                context.method_25294(0, 0, width, height, (int)(flashAlpha * 255.0f) << 24 | color);
                break;
            }
            case 1: {
                int quarterWidth = width / 2;
                int quarterHeight = height / 2;
                int x = RANDOM.method_43048(2) * quarterWidth;
                int y = RANDOM.method_43048(2) * quarterHeight;
                context.method_25294(x, y, x + quarterWidth, y + quarterHeight, (int)(flashAlpha * 255.0f) << 24 | color);
                break;
            }
            case 2: {
                int flashW = RANDOM.method_43048(200) + 50;
                int flashH = RANDOM.method_43048(150) + 50;
                int flashX = RANDOM.method_43048(width - flashW);
                int flashY = RANDOM.method_43048(height - flashH);
                context.method_25294(flashX, flashY, flashX + flashW, flashY + flashH, (int)(flashAlpha * 255.0f) << 24 | color);
                break;
            }
            case 3: {
                boolean horizontal = RANDOM.method_43056();
                int stripeSize = RANDOM.method_43048(30) + 10;
                if (horizontal) {
                    int y = RANDOM.method_43048(height - stripeSize);
                    context.method_25294(0, y, width, y + stripeSize, (int)(flashAlpha * 255.0f) << 24 | color);
                    break;
                }
                int x = RANDOM.method_43048(width - stripeSize);
                context.method_25294(x, 0, x + stripeSize, height, (int)(flashAlpha * 255.0f) << 24 | color);
            }
        }
    }

    private static void renderDistortionEffect(class_332 context, int width, int height, float alpha) {
        int shadowCount = RANDOM.method_43048(8) + 3;
        for (int i = 0; i < shadowCount; ++i) {
            int shadowW = RANDOM.method_43048(100) + 20;
            int shadowH = RANDOM.method_43048(200) + 50;
            int x = RANDOM.method_43048(Math.max(1, width - shadowW));
            int y = RANDOM.method_43048(Math.max(1, height - shadowH));
            int shadowAlpha = (int)(alpha * 120.0f * RANDOM.method_43057());
            context.method_25294(x, y, x + shadowW, y + shadowH, shadowAlpha << 24 | 0);
        }
    }

    private static void renderPulseEffect(class_332 context, int width, int height, float alpha, float tickDelta) {
        class_310 client = class_310.method_1551();
        long time = 0L;
        if (client.field_1687 != null) {
            time = client.field_1687.method_8510();
        }
        float pulse = (float)Math.sin((float)time * 0.5f + tickDelta) * 0.2f + 0.8f;
        int borderSize = (int)(15.0f * pulse);
        int borderColor = (int)(alpha * 150.0f) << 24 | VoidEffectManager.getRandomHorrorColor();
        context.method_25294(0, 0, width, borderSize, borderColor);
        context.method_25294(0, height - borderSize, width, height, borderColor);
        context.method_25294(0, 0, borderSize, height, borderColor);
        context.method_25294(width - borderSize, 0, width, height, borderColor);
    }

    private static void renderStaticNoise(class_332 context, int width, int height, float alpha) {
        int noiseCount = RANDOM.method_43048(50) + 20;
        for (int i = 0; i < noiseCount; ++i) {
            int noiseSize = RANDOM.method_43048(8) + 2;
            int x = RANDOM.method_43048(width - noiseSize);
            int y = RANDOM.method_43048(height - noiseSize);
            int noiseAlpha = (int)(alpha * 200.0f * RANDOM.method_43057());
            int color = RANDOM.method_43056() ? 0xFFFFFF : 0;
            context.method_25294(x, y, x + noiseSize, y + noiseSize, noiseAlpha << 24 | color);
        }
    }

    private static void spawnWorldParticles(class_638 world, class_243 playerPos) {
        int particleCount = RANDOM.method_43048(15) + 5;
        block10: for (int i = 0; i < particleCount; ++i) {
            double offsetX = (RANDOM.method_43058() - 0.5) * 10.0;
            double offsetY = RANDOM.method_43058() * 5.0;
            double offsetZ = (RANDOM.method_43058() - 0.5) * 10.0;
            class_243 particlePos = playerPos.method_1031(offsetX, offsetY, offsetZ);
            int particleType = RANDOM.method_43048(8);
            switch (particleType) {
                case 0: {
                    world.method_8406((class_2394)class_2398.field_23114, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.1, 0.02, (RANDOM.method_43058() - 0.5) * 0.1);
                    continue block10;
                }
                case 1: {
                    world.method_8406((class_2394)class_2398.field_22246, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.2, 0.05, (RANDOM.method_43058() - 0.5) * 0.2);
                    continue block10;
                }
                case 2: {
                    world.method_8406((class_2394)class_2398.field_22247, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.05, -0.01, (RANDOM.method_43058() - 0.5) * 0.05);
                    continue block10;
                }
                case 3: {
                    world.method_8406((class_2394)class_2398.field_23956, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.08, 0.01, (RANDOM.method_43058() - 0.5) * 0.08);
                    continue block10;
                }
                case 4: {
                    world.method_8406((class_2394)class_2398.field_38002, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.15, 0.03, (RANDOM.method_43058() - 0.5) * 0.15);
                    continue block10;
                }
                case 5: {
                    world.method_8406((class_2394)class_2398.field_23190, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.1, 0.02, (RANDOM.method_43058() - 0.5) * 0.1);
                    continue block10;
                }
                case 6: {
                    world.method_8406((class_2394)class_2398.field_11216, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.12, 0.01, (RANDOM.method_43058() - 0.5) * 0.12);
                    continue block10;
                }
                case 7: {
                    world.method_8406((class_2394)class_2398.field_11215, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (RANDOM.method_43058() - 0.5) * 0.08, 0.015, (RANDOM.method_43058() - 0.5) * 0.08);
                }
            }
        }
        if (RANDOM.method_43057() < 0.1f) {
            VoidEffectManager.spawnParticleBurst(world, playerPos);
        }
    }

    private static void spawnParticleBurst(class_638 world, class_243 playerPos) {
        int burstCount = RANDOM.method_43048(30) + 20;
        for (int i = 0; i < burstCount; ++i) {
            double angle = RANDOM.method_43058() * Math.PI * 2.0;
            double distance = RANDOM.method_43058() * 8.0;
            double x = Math.cos(angle) * distance;
            double z = Math.sin(angle) * distance;
            double y = RANDOM.method_43058() * 3.0;
            class_243 burstPos = playerPos.method_1031(x, y, z);
            world.method_8406((class_2394)class_2398.field_22246, burstPos.field_1352, burstPos.field_1351, burstPos.field_1350, (RANDOM.method_43058() - 0.5) * 0.3, RANDOM.method_43058() * 0.2, (RANDOM.method_43058() - 0.5) * 0.3);
        }
    }

    private static int getRandomHorrorColor() {
        int colorType = RANDOM.method_43048(12);
        switch (colorType) {
            case 0: {
                return 0xFF0000;
            }
            case 1: {
                return 0x8B0000;
            }
            case 2: {
                return 4915330;
            }
            case 3: {
                return 0x2F4F4F;
            }
            case 4: {
                return 25600;
            }
            case 5: {
                return 9127187;
            }
            case 6: {
                return 4734347;
            }
            case 7: {
                return 3050327;
            }
            case 8: {
                return 0x800080;
            }
            case 9: {
                return 14423100;
            }
            case 10: {
                return 52945;
            }
            case 11: {
                return 9699539;
            }
        }
        return 0xFF0000;
    }

    private static float calculateAlpha() {
        if (voidEffectTimer <= 0) {
            return 0.0f;
        }
        float progress = (float)voidEffectTimer / 100.0f;
        return class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f) * 0.8f;
    }

    private static void stopAllSounds() {
    }

    public static boolean isVoidEffectActive() {
        return voidEffectTimer > 0;
    }

    public static void stopAllEffects() {
        voidEffectTimer = 0;
    }

    public static float getEffectIntensity() {
        return VoidEffectManager.calculateAlpha();
    }

    public static int getRemainingTime() {
        return voidEffectTimer;
    }
}

