/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.item.custom;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import s22.new_mod.NEWMod;
import s22.new_mod.datagen.ModAdvancementProvider;

public class EnrichedFireEtherSwordItem
extends class_1829 {
    private static final int MAX_CHARGE_TICKS = 100;
    private int maximumChargeCount = 0;

    public EnrichedFireEtherSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.method_8608()) {
            user.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251\u00a7r: \u00a7e\u5f00\u59cb\u84c4\u529b..."), true);
            NEWMod.LOGGER.info("\u73a9\u5bb6 {} \u5f00\u59cb\u84c4\u529b\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251", (Object)user.method_5477().getString());
        } else {
            world.method_8396(user, user.method_24515(), class_3417.field_14993, class_3419.field_15248, 0.3f, 1.2f);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        ChargeStage previousStage;
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        int chargeTime = this.calculateChargeTime(stack, user, remainingUseTicks);
        ChargeStage currentStage = this.getChargeStage(chargeTime);
        if (currentStage != (previousStage = this.getChargeStage(chargeTime - 1)) || chargeTime > 0 && chargeTime % 25 == 0) {
            float chargeRatio = this.getChargeRatio(chargeTime);
            int progress = (int)(chargeRatio * 100.0f);
            if (!world.method_8608()) {
                String stageName = this.getStageName(currentStage);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251\u00a7r: \u00a7e" + stageName + " \u00a76" + progress + "% (\u00a77" + chargeTime + "tick\u00a76)")), true);
            }
        }
        if (world.method_8608() && chargeTime > 5) {
            this.spawnChargingParticles(player, chargeTime, this.getChargeStage(chargeTime));
            if (chargeTime > 10) {
                this.spawnSwordVisualEffect(player, chargeTime, this.getChargeStage(chargeTime));
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        int chargeTime = this.calculateChargeTime(stack, user, remainingUseTicks);
        if (!world.method_8608()) {
            NEWMod.LOGGER.info("\u84c4\u529b\u7ed3\u675f - \u5269\u4f59\u65f6\u95f4: {}tick, \u8ba1\u7b97\u51fa\u7684\u84c4\u529b\u65f6\u95f4: {}tick", (Object)remainingUseTicks, (Object)chargeTime);
        }
        if (chargeTime < 15) {
            if (!world.method_8608()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251\u00a7r: \u00a7a\u666e\u901a\u653b\u51fb"), true);
                NEWMod.LOGGER.info("\u73a9\u5bb6 {} \u4f7f\u7528\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251\u8fdb\u884c\u666e\u901a\u653b\u51fb\uff0c\u84c4\u529b\u65f6\u95f4: {}tick", (Object)player.method_5477().getString(), (Object)chargeTime);
            }
            return;
        }
        ChargeStage stage = this.getChargeStage(chargeTime);
        if (stage == ChargeStage.MAXIMUM && !world.method_8608()) {
            ++this.maximumChargeCount;
            if (this.maximumChargeCount >= 50) {
                ModAdvancementProvider.MAXIMUM_CHARGE_ATTACK.trigger((class_3222)player);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u6210\u5c31\u8fbe\u6210\uff01\u6781\u9650\u84c4\u529b\u5927\u5e08\uff01"), true);
            }
        }
        this.executeChargedAttack(player, world, stack, stage, chargeTime);
    }

    private int calculateChargeTime(class_1799 stack, class_1309 user, int remainingUseTicks) {
        int totalUseTime = this.method_7881(stack, user);
        int elapsedTime = totalUseTime - remainingUseTicks;
        return Math.min(elapsedTime, 100);
    }

    private void executeChargedAttack(class_1657 player, class_1937 world, class_1799 stack, ChargeStage stage, int chargeTime) {
        float chargeRatio = this.getChargeRatio(chargeTime);
        float baseDamage = 113.0f;
        float stageMultiplier = this.getStageDamageMultiplier(stage);
        float extraDamage = baseDamage * stageMultiplier * chargeRatio;
        float totalDamage = baseDamage + extraDamage;
        float knockbackStrength = 2.0f + chargeRatio * this.getStageKnockbackMultiplier(stage);
        double dashDistance = this.getDashDistance(stage);
        class_243 lookVec = player.method_5720().method_18805(dashDistance, 0.8, dashDistance);
        player.method_5762(lookVec.field_1352, lookVec.field_1351, lookVec.field_1350);
        player.field_6037 = true;
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14999, class_3419.field_15248, this.getStageSoundVolume(stage), this.getStageSoundPitch(stage));
        int hitCount = this.performDashAttack(player, world, totalDamage, knockbackStrength, dashDistance);
        if (hitCount >= 5 && !world.method_8608()) {
            ModAdvancementProvider.MULTI_TARGET_HIT.trigger((class_3222)player);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76\u00a7l\u6210\u5c31\u8fbe\u6210\uff01\u70c8\u7130\u8fde\u51fb\uff01\u4e00\u5251\u547d\u4e2d" + hitCount + "\u4e2a\u76ee\u6807\uff01")), true);
        }
        int durabilityCost = this.getStageDurabilityCost(stage);
        stack.method_7970(durabilityCost, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
        if (!world.method_8608()) {
            String stageName = this.getStageName(stage);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b\u5f3a\u5316\u706b\u7130\u4ee5\u592a\u5251\u00a7r: \u00a76" + stageName + "\u653b\u51fb! \u00a7c\u57fa\u7840\u4f24\u5bb3: " + String.format("%.1f", Float.valueOf(baseDamage)) + " \u00a76\u52a0\u6210\u4f24\u5bb3: " + String.format("%.1f", Float.valueOf(extraDamage)) + " \u00a74\u603b\u4f24\u5bb3: " + String.format("%.1f", Float.valueOf(totalDamage)) + " \u00a79\u51fb\u9000: " + String.format("%.1f", Float.valueOf(knockbackStrength)) + " \u00a7a\u95ea\u73b0: " + String.format("%.1f", dashDistance) + "\u683c \u00a77\u547d\u4e2d: " + hitCount + "\u4e2a\u76ee\u6807 \u00a77(\u84c4\u529b: " + chargeTime + "tick)")), true);
            NEWMod.LOGGER.info("\u73a9\u5bb6 {} \u5b8c\u6210{}\u84c4\u529b\u653b\u51fb - \u57fa\u7840\u4f24\u5bb3: {}, \u52a0\u6210\u4f24\u5bb3: {}, \u603b\u4f24\u5bb3: {}, \u51fb\u9000: {}, \u95ea\u73b0: {}\u683c, \u547d\u4e2d: {}\u4e2a\u76ee\u6807", new Object[]{player.method_5477().getString(), stageName, Float.valueOf(baseDamage), Float.valueOf(extraDamage), Float.valueOf(totalDamage), Float.valueOf(knockbackStrength), dashDistance, hitCount});
        }
        if (world.method_8608()) {
            this.spawnReleaseParticles(player, stage);
            this.spawnDashTrail(player, dashDistance, stage);
        }
    }

    private int performDashAttack(class_1657 player, class_1937 world, float damage, float knockback, double dashDistance) {
        class_243 startPos = player.method_19538();
        class_243 endPos = startPos.method_1019(player.method_5720().method_18805(dashDistance, 0.0, dashDistance));
        int hitCount = 0;
        for (class_1309 target : world.method_8390(class_1309.class, player.method_5829().method_1014(dashDistance), entity -> entity != player && entity.method_5805())) {
            if (!this.isEntityInDashPath(startPos, endPos, target.method_19538(), 2.0) || !target.method_5643(world.method_48963().method_48802(player), damage)) continue;
            ++hitCount;
            class_243 knockbackDir = target.method_19538().method_1020(startPos).method_1029().method_1021((double)knockback);
            target.method_5762(knockbackDir.field_1352, (double)knockback * 0.3, knockbackDir.field_1350);
            target.field_6037 = true;
            if (target.method_5854() != null) {
                target.method_5848();
            }
            world.method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_15016, class_3419.field_15248, 1.0f, 1.0f);
            if (!world.method_8608()) continue;
            this.spawnHitParticles(target);
        }
        return hitCount;
    }

    private float getChargeRatio(int chargeTime) {
        return Math.min((float)chargeTime / 100.0f, 1.0f);
    }

    private ChargeStage getChargeStage(int chargeTime) {
        if (chargeTime <= ChargeStage.WEAK.maxTick) {
            return ChargeStage.WEAK;
        }
        if (chargeTime <= ChargeStage.MEDIUM.maxTick) {
            return ChargeStage.MEDIUM;
        }
        if (chargeTime <= ChargeStage.STRONG.maxTick) {
            return ChargeStage.STRONG;
        }
        return ChargeStage.MAXIMUM;
    }

    private boolean isEntityInDashPath(class_243 start, class_243 end, class_243 entityPos, double tolerance) {
        class_243 path = end.method_1020(start);
        class_243 toEntity = entityPos.method_1020(start);
        double pathLength = path.method_1033();
        if (pathLength == 0.0) {
            return false;
        }
        class_243 pathNormalized = path.method_1021(1.0 / pathLength);
        double projection = toEntity.method_1026(pathNormalized);
        if (projection < 0.0 || projection > pathLength) {
            return false;
        }
        class_243 closestPoint = start.method_1019(pathNormalized.method_1021(projection));
        double distance = entityPos.method_1022(closestPoint);
        return distance <= tolerance;
    }

    private String getStageName(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return "\u00a77\u5fae\u5f31\u84c4\u529b";
            }
            case 1: {
                return "\u00a7a\u4e2d\u7b49\u84c4\u529b";
            }
            case 2: {
                return "\u00a7c\u5f3a\u529b\u84c4\u529b";
            }
            case 3: {
                return "\u00a76\u00a7l\u6781\u9650\u84c4\u529b";
            }
        }
        return "\u672a\u77e5";
    }

    private float getStageDamageMultiplier(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 0.2f;
            }
            case 1: {
                return 0.4f;
            }
            case 2: {
                return 0.7f;
            }
            case 3: {
                return 1.2f;
            }
        }
        return 0.5f;
    }

    private float getStageKnockbackMultiplier(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 1.5f;
            }
            case 1: {
                return 2.5f;
            }
            case 2: {
                return 4.0f;
            }
            case 3: {
                return 5.5f;
            }
        }
        return 3.0f;
    }

    private double getDashDistance(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 2.0;
            }
            case 1: {
                return 4.0;
            }
            case 2: {
                return 6.0;
            }
            case 3: {
                return 8.0;
            }
        }
        return 3.0;
    }

    private float getStageSoundVolume(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 0.6f;
            }
            case 1: {
                return 0.8f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 1.3f;
            }
        }
        return 1.0f;
    }

    private float getStageSoundPitch(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 1.2f;
            }
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private int getStageDurabilityCost(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
        }
        return 1;
    }

    private void spawnChargingParticles(class_1657 player, int chargeTime, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 pos = player.method_19538().method_1031(0.0, 1.0, 0.0);
        switch (stage.ordinal()) {
            case 0: {
                for (int i = 0; i < 3 + chargeTime / 10; ++i) {
                    double offsetX = (world.field_9229.method_43058() - 0.5) * 1.5;
                    double offsetY = world.field_9229.method_43058() * 1.5;
                    double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.5;
                    world.method_8406((class_2394)class_2398.field_11240, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.05, 0.0);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 6 + chargeTime / 8; ++i) {
                    double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
                    double offsetY = world.field_9229.method_43058() * 2.0;
                    double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
                    world.method_8406((class_2394)class_2398.field_11240, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.08, 0.0);
                    if (i % 3 != 0) continue;
                    world.method_8406((class_2394)class_2398.field_11251, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.03, 0.0);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 10 + chargeTime / 6; ++i) {
                    double offsetX = (world.field_9229.method_43058() - 0.5) * 2.5;
                    double offsetY = world.field_9229.method_43058() * 2.5;
                    double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.5;
                    world.method_8406((class_2394)class_2398.field_11240, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.1, 0.0);
                    if (i % 2 == 0) {
                        world.method_8406((class_2394)class_2398.field_11251, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.05, 0.0);
                    }
                    if (i % 4 != 0) continue;
                    world.method_8406((class_2394)class_2398.field_29644, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, (world.field_9229.method_43058() - 0.5) * 0.1, 0.1, (world.field_9229.method_43058() - 0.5) * 0.1);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 15 + chargeTime / 4; ++i) {
                    double offsetX = (world.field_9229.method_43058() - 0.5) * 3.0;
                    double offsetY = world.field_9229.method_43058() * 3.0;
                    double offsetZ = (world.field_9229.method_43058() - 0.5) * 3.0;
                    world.method_8406((class_2394)class_2398.field_22246, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.15, 0.0);
                    if (i % 2 == 0) {
                        world.method_8406((class_2394)class_2398.field_11240, pos.field_1352 + offsetX * 0.7, pos.field_1351 + offsetY * 0.7, pos.field_1350 + offsetZ * 0.7, 0.0, 0.12, 0.0);
                    }
                    if (i % 3 == 0) {
                        world.method_8406((class_2394)class_2398.field_29644, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, (world.field_9229.method_43058() - 0.5) * 0.2, 0.15, (world.field_9229.method_43058() - 0.5) * 0.2);
                    }
                    if (i % 4 != 0) continue;
                    world.method_8406((class_2394)class_2398.field_11237, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.08, 0.0);
                }
                break;
            }
        }
    }

    private void spawnSwordVisualEffect(class_1657 player, int chargeTime, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 pos = player.method_19538().method_1031(0.0, 1.5, 0.0);
        class_243 lookVec = player.method_5720();
        class_243 rightVec = lookVec.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        for (int i = 0; i < (switch (stage.ordinal()) {
            case 0 -> 3;
            case 1 -> 5;
            case 2 -> 8;
            case 3 -> 12;
            default -> 3;
        }); ++i) {
            double sideOffset = (world.field_9229.method_43058() - 0.5) * 2.0;
            class_243 particlePos = pos.method_1019(rightVec.method_1021(sideOffset));
            if (stage == ChargeStage.MAXIMUM) {
                world.method_8406((class_2394)class_2398.field_22246, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, lookVec.field_1352 * 0.15, lookVec.field_1351 * 0.15, lookVec.field_1350 * 0.15);
                continue;
            }
            if (stage == ChargeStage.STRONG) {
                world.method_8406((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, lookVec.field_1352 * 0.1, lookVec.field_1351 * 0.1, lookVec.field_1350 * 0.1);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_11205, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, lookVec.field_1352 * 0.08, lookVec.field_1351 * 0.08, lookVec.field_1350 * 0.08);
        }
    }

    private void spawnDashTrail(class_1657 player, double distance, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 startPos = player.method_19538();
        class_243 direction = player.method_5720().method_1029();
        int trailCount = switch (stage.ordinal()) {
            case 0 -> 15;
            case 1 -> 20;
            case 2 -> 25;
            case 3 -> 30;
            default -> 20;
        };
        for (int i = 0; i < trailCount; ++i) {
            double progress = (double)i / (double)trailCount * distance;
            class_243 trailPos = startPos.method_1019(direction.method_1021(progress));
            if (stage == ChargeStage.MAXIMUM) {
                world.method_8406((class_2394)class_2398.field_22246, trailPos.field_1352, trailPos.field_1351 + 0.5, trailPos.field_1350, 0.0, 0.08, 0.0);
                continue;
            }
            if (stage == ChargeStage.STRONG) {
                world.method_8406((class_2394)class_2398.field_11240, trailPos.field_1352, trailPos.field_1351 + 0.5, trailPos.field_1350, 0.0, 0.06, 0.0);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_11251, trailPos.field_1352, trailPos.field_1351 + 0.5, trailPos.field_1350, 0.0, 0.04, 0.0);
        }
    }

    private void spawnHitParticles(class_1309 target) {
        class_1937 world = target.method_37908();
        class_243 pos = target.method_19538();
        for (int i = 0; i < 10; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 1.0;
            double offsetY = world.field_9229.method_43058() * 2.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.0;
            world.method_8406((class_2394)class_2398.field_11205, pos.field_1352 + offsetX, pos.field_1351 + offsetY, pos.field_1350 + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void spawnReleaseParticles(class_1657 player, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 pos = player.method_19538();
        for (int i = 0; i < (switch (stage.ordinal()) {
            case 0 -> 15;
            case 1 -> 25;
            case 2 -> 40;
            case 3 -> 60;
            default -> 20;
        }); ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 6.0;
            double offsetY = (world.field_9229.method_43058() - 0.5) * 6.0;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 6.0;
            if (stage == ChargeStage.MAXIMUM) {
                world.method_8406((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, offsetX * 0.2, offsetY * 0.2, offsetZ * 0.2);
                continue;
            }
            if (stage == ChargeStage.STRONG) {
                world.method_8406((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, offsetX * 0.15, offsetY * 0.15, offsetZ * 0.15);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
        }
    }

    private static enum ChargeStage {
        WEAK(25),
        MEDIUM(50),
        STRONG(75),
        MAXIMUM(100);

        final int maxTick;

        private ChargeStage(int maxTick) {
            this.maxTick = maxTick;
        }
    }
}

