/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1452;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import s22.new_mod.datagen.ModAdvancementProvider;

public class FiveThunderTalismanItem
extends class_1792 {
    private static final int THUNDER_RADIUS = 5;
    private static final int REAL_THUNDER_COUNT = 3;
    private static final int PARTICLE_THUNDER_COUNT = 5;
    private boolean hasVillager = false;
    private boolean hasCreeper = false;
    private boolean hasPig = false;

    public FiveThunderTalismanItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.method_8608()) {
            this.hasVillager = false;
            this.hasCreeper = false;
            this.hasPig = false;
            user.method_6092(new class_1293(class_1294.field_5907, 100, 4));
            user.method_6092(new class_1293(class_1294.field_5918, 100, 0));
            this.summonThunderImmediately((class_3218)world, user);
            this.checkThreeEntityAchievement((class_3222)user);
            itemStack.method_7934(1);
            user.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b\u4e94\u96f7\u7b26\u00a7r: \u00a76\u5929\u96f7\u964d\u4e16!"), true);
        } else {
            world.method_8396(user, user.method_24515(), class_3417.field_15013, class_3419.field_15248, 1.0f, 0.8f);
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    private void summonThunderImmediately(class_3218 world, class_1657 user) {
        class_2338 userPos = user.method_24515();
        class_238 area = new class_238(userPos).method_1014(5.0);
        List targets = world.method_8390(class_1309.class, area, entity -> entity != user && entity.method_5805());
        for (class_1309 target : targets) {
            if (target instanceof class_1646) {
                this.hasVillager = true;
            }
            if (target instanceof class_1548) {
                this.hasCreeper = true;
            }
            if (!(target instanceof class_1452)) continue;
            this.hasPig = true;
        }
        List<class_2338> allThunderPositions = this.generateThunderPositionsWithPriority(world, userPos, targets);
        this.playThunderPreparation(world, user.method_19538());
        this.executeThunderStrikesImmediately(world, user, allThunderPositions, targets);
    }

    private void checkThreeEntityAchievement(class_3222 player) {
        if (this.hasVillager && this.hasCreeper && this.hasPig) {
            ModAdvancementProvider.THREE_ENTITY_THUNDER_HIT.trigger(player);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u6210\u5c31\u8fbe\u6210\uff01\u7cbe\u51c6\u96f7\u51fb\uff01\u540c\u65f6\u51fb\u4e2d\u6751\u6c11\u3001\u82e6\u529b\u6015\u548c\u732a\uff01"), true);
        }
    }

    private List<class_2338> generateThunderPositionsWithPriority(class_3218 world, class_2338 center, List<class_1309> targets) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_5819 random = world.method_8409();
        for (class_1309 target : targets) {
            if (positions.size() >= 3) break;
            class_2338 targetPos = target.method_24515();
            if (!this.isPositionValid(world, targetPos) || !center.method_19771((class_2382)targetPos, 5.0)) continue;
            positions.add(targetPos);
        }
        while (positions.size() < 8) {
            class_2338 randomPos = this.findRandomThunderPosition(world, center, random);
            if (randomPos == null || positions.contains(randomPos)) continue;
            positions.add(randomPos);
        }
        return positions;
    }

    private class_2338 findRandomThunderPosition(class_3218 world, class_2338 center, class_5819 random) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            double angle = random.method_43058() * Math.PI * 2.0;
            double distance = random.method_43058() * 5.0;
            int x = center.method_10263() + (int)(Math.cos(angle) * distance);
            int z = center.method_10260() + (int)(Math.sin(angle) * distance);
            for (int y = world.method_31600(); y > center.method_10264() - 5; --y) {
                class_2338 checkPos = new class_2338(x, y, z);
                if (!world.method_8320(checkPos).method_51367() || !world.method_8320(checkPos.method_10084()).method_26215()) continue;
                return checkPos.method_10084();
            }
        }
        return center;
    }

    private boolean isPositionValid(class_3218 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() && world.method_8320(pos.method_10074()).method_51367();
    }

    private void playThunderPreparation(class_3218 world, class_243 center) {
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14865, class_3419.field_15248, 2.0f, 0.4f);
        for (int i = 0; i < 15; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 15.0;
            double radius = 2.5;
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            world.method_14199((class_2394)class_2398.field_29644, x, center.field_1351 + 1.0, z, 1, 0.2, 0.5, 0.2, 0.08);
        }
    }

    private void executeThunderStrikesImmediately(class_3218 world, class_1657 user, List<class_2338> positions, List<class_1309> targets) {
        this.createThunderStrikeSequence(world, user, positions, targets, 0);
    }

    private void createThunderStrikeSequence(class_3218 world, class_1657 user, List<class_2338> positions, List<class_1309> targets, int currentIndex) {
        if (currentIndex >= positions.size()) {
            world.method_8503().execute(() -> new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    world.method_8503().execute(() -> this.clearFireEffects(world, user.method_24515()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start());
            return;
        }
        int strikeIndex = currentIndex;
        class_2338 strikePos = positions.get(currentIndex);
        boolean isRealThunder = strikeIndex < 3;
        boolean isTargetStrike = this.isPositionOnTarget(strikePos, targets);
        if (isRealThunder) {
            this.strikeRealThunderImmediately(world, strikePos, strikeIndex, isTargetStrike);
        } else {
            this.strikeParticleThunderImmediately(world, strikePos, strikeIndex);
        }
        if (currentIndex + 1 < positions.size()) {
            world.method_8503().execute(() -> this.createThunderStrikeSequence(world, user, positions, targets, currentIndex + 1));
        } else {
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    world.method_8503().execute(() -> this.clearFireEffects(world, user.method_24515()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }

    private boolean isPositionOnTarget(class_2338 pos, List<class_1309> targets) {
        for (class_1309 target : targets) {
            if (!target.method_24515().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private void strikeRealThunderImmediately(class_3218 world, class_2338 strikePos, int thunderIndex, boolean isTargetStrike) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_33574(class_243.method_24955((class_2382)strikePos));
        world.method_8649((class_1297)lightning);
        float volume = isTargetStrike ? 1.8f : 1.5f;
        world.method_43128(null, (double)strikePos.method_10263(), (double)strikePos.method_10264(), (double)strikePos.method_10260(), class_3417.field_14956, class_3419.field_15251, volume, 0.7f);
        this.spawnThunderParticlesImmediately(world, class_243.method_24955((class_2382)strikePos), thunderIndex, true, isTargetStrike);
        if (isTargetStrike) {
            this.spawnMinimalFireEffects(world, strikePos);
        }
    }

    private void strikeParticleThunderImmediately(class_3218 world, class_2338 strikePos, int thunderIndex) {
        world.method_43128(null, (double)strikePos.method_10263(), (double)strikePos.method_10264(), (double)strikePos.method_10260(), class_3417.field_14956, class_3419.field_15252, 1.2f, 0.9f);
        this.spawnThunderParticlesImmediately(world, class_243.method_24955((class_2382)strikePos), thunderIndex, false, false);
        world.method_14199((class_2394)class_2398.field_17909, (double)strikePos.method_10263() + 0.5, (double)(strikePos.method_10264() + 2), (double)strikePos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnThunderParticlesImmediately(class_3218 world, class_243 thunderPos, int thunderIndex, boolean isRealThunder, boolean isTargetStrike) {
        String colorTheme = this.getColorTheme(thunderIndex);
        int sparkCount = isTargetStrike ? 20 : (isRealThunder ? 15 : 12);
        world.method_14199((class_2394)class_2398.field_29644, thunderPos.field_1352, thunderPos.field_1351 + 2.0, thunderPos.field_1350, sparkCount, 0.6, 1.5, 0.6, 0.15);
        this.spawnColorParticles(world, thunderPos, colorTheme);
        this.spawnShockwave(world, thunderPos);
    }

    private String getColorTheme(int thunderIndex) {
        switch (thunderIndex % 5) {
            case 0: {
                return "BLUE";
            }
            case 1: {
                return "RED";
            }
            case 2: {
                return "GOLD";
            }
            case 3: {
                return "PURPLE";
            }
            case 4: {
                return "WHITE";
            }
        }
        return "BLUE";
    }

    private void spawnColorParticles(class_3218 world, class_243 center, String colorTheme) {
        block14: for (int i = 0; i < 6; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 6.0;
            double radius = 1.0;
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            double y = center.field_1351 + 1.2;
            switch (colorTheme) {
                case "BLUE": {
                    world.method_14199((class_2394)class_2398.field_22246, x, y, z, 1, 0.05, 0.08, 0.05, 0.03);
                    continue block14;
                }
                case "RED": {
                    world.method_14199((class_2394)class_2398.field_11240, x, y, z, 1, 0.05, 0.08, 0.05, 0.03);
                    continue block14;
                }
                case "GOLD": {
                    world.method_14199((class_2394)class_2398.field_28479, x, y, z, 1, 0.05, 0.08, 0.05, 0.03);
                    continue block14;
                }
                case "PURPLE": {
                    world.method_14199((class_2394)class_2398.field_11216, x, y, z, 1, 0.05, 0.08, 0.05, 0.03);
                    continue block14;
                }
                case "WHITE": {
                    world.method_14199((class_2394)class_2398.field_11207, x, y, z, 1, 0.05, 0.08, 0.05, 0.03);
                }
            }
        }
    }

    private void spawnShockwave(class_3218 world, class_243 center) {
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI * 2.0 / 8.0;
            double radius = 1.2;
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            world.method_14199((class_2394)class_2398.field_11251, x, center.field_1351 + 0.1, z, 1, 0.08, 0.03, 0.08, 0.01);
        }
    }

    private void spawnMinimalFireEffects(class_3218 world, class_2338 thunderPos) {
        class_2338 firePos = thunderPos;
        if (world.method_8320(firePos).method_26215() && world.method_8320(firePos.method_10074()).method_51367()) {
            world.method_8501(firePos, class_2246.field_10036.method_9564());
        }
    }

    private void clearFireEffects(class_3218 world, class_2338 center) {
        int clearRadius = 6;
        for (int x = -clearRadius; x <= clearRadius; ++x) {
            for (int y = -clearRadius; y <= clearRadius; ++y) {
                for (int z = -clearRadius; z <= clearRadius; ++z) {
                    class_2338 checkPos = center.method_10069(x, y, z);
                    if (!world.method_8320(checkPos).method_27852(class_2246.field_10036)) continue;
                    world.method_8501(checkPos, class_2246.field_10124.method_9564());
                }
            }
        }
    }
}

