/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.item.custom;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import s22.new_mod.datagen.ModAdvancementProvider;

public class ThunderEscapeBladeItem
extends class_1829 {
    private static final double INSTANT_DASH = 3.0;
    private static final double QUICK_DASH = 5.0;
    private static final double NORMAL_DASH = 7.0;
    private static final double POWER_DASH = 10.0;
    private double totalDashDistance = 0.0;
    private long lastDashTime = 0L;
    private int rapidDashCount = 0;

    public ThunderEscapeBladeItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        int chargeTime = this.method_7881(stack, user) - remainingUseTicks;
        ChargeStage stage = this.getChargeStage(chargeTime);
        this.performThunderDash(player, world, stack, stage);
    }

    private ChargeStage getChargeStage(int chargeTime) {
        if (chargeTime <= ChargeStage.INSTANT.maxTick) {
            return ChargeStage.INSTANT;
        }
        if (chargeTime <= ChargeStage.QUICK.maxTick) {
            return ChargeStage.QUICK;
        }
        if (chargeTime <= ChargeStage.NORMAL.maxTick) {
            return ChargeStage.NORMAL;
        }
        return ChargeStage.POWER;
    }

    private void performThunderDash(class_1657 player, class_1937 world, class_1799 stack, ChargeStage stage) {
        double dashDistance = this.getDashDistance(stage);
        String stageName = this.getStageName(stage);
        class_243 lookVec = player.method_5720().method_18805(dashDistance, 0.6, dashDistance);
        player.method_5762(lookVec.field_1352, lookVec.field_1351, lookVec.field_1350);
        player.field_6037 = true;
        float pitch = this.getStageSoundPitch(stage);
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14865, class_3419.field_15248, 0.3f, pitch);
        if (world.method_8608()) {
            this.spawnDashTrail(player, stage);
        }
        if (!world.method_8608()) {
            this.trackAchievements((class_3222)player, dashDistance, stage);
        }
        int durabilityCost = this.getStageDurabilityCost(stage);
        stack.method_7970(durabilityCost, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
        if (!world.method_8608()) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b\u9041\u7a7a\u5203\u00a7r: \u00a76" + stageName + "\u95ea\u73b0! \u00a7a(" + String.format("%.1f", dashDistance) + "\u7c73)")), true);
        }
    }

    private void trackAchievements(class_3222 player, double dashDistance, ChargeStage stage) {
        long currentTime;
        this.totalDashDistance += dashDistance;
        if (this.totalDashDistance >= 1000.0) {
            ModAdvancementProvider.THUNDER_DASH_DISTANCE.trigger(player);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76\u00a7l\u6210\u5c31\u8fbe\u6210\uff01\u865a\u7a7a\u884c\u8005\uff01\u7d2f\u8ba1\u95ea\u73b0" + String.format("%.1f", this.totalDashDistance) + "\u7c73\uff01")), true);
        }
        this.rapidDashCount = (currentTime = System.currentTimeMillis()) - this.lastDashTime < 10000L ? ++this.rapidDashCount : 1;
        this.lastDashTime = currentTime;
        if (this.rapidDashCount >= 5) {
            ModAdvancementProvider.RAPID_DASH.trigger(player);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u6210\u5c31\u8fbe\u6210\uff01\u77ac\u8eab\u8fde\u51fb\uff0110\u79d2\u5185\u8fde\u7eed\u95ea\u73b05\u6b21\uff01"), true);
            this.rapidDashCount = 0;
        }
    }

    private double getDashDistance(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 3.0;
            }
            case 1: {
                return 5.0;
            }
            case 2: {
                return 7.0;
            }
            case 3: {
                return 10.0;
            }
        }
        return 3.0;
    }

    private String getStageName(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return "\u00a7a\u8f7b\u70b9";
            }
            case 1: {
                return "\u00a7e\u5feb\u901f";
            }
            case 2: {
                return "\u00a76\u6b63\u5e38";
            }
            case 3: {
                return "\u00a7c\u5f3a\u529b";
            }
        }
        return "\u672a\u77e5";
    }

    private float getStageSoundPitch(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 2.0f;
            }
            case 1: {
                return 1.5f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    private int getStageDurabilityCost(ChargeStage stage) {
        switch (stage.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private void spawnDashTrail(class_1657 player, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 startPos = player.method_19538();
        class_243 direction = player.method_5720().method_1029();
        double dashDistance = this.getDashDistance(stage);
        int particleCount = switch (stage.ordinal()) {
            case 0 -> 8;
            case 1 -> 12;
            case 2 -> 16;
            case 3 -> 20;
            default -> 10;
        };
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount * dashDistance;
            class_243 trailPos = startPos.method_1019(direction.method_1021(progress));
            if (stage == ChargeStage.POWER) {
                world.method_8406((class_2394)class_2398.field_29644, trailPos.field_1352, trailPos.field_1351 + 0.3, trailPos.field_1350, 0.0, 0.1, 0.0);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_23190, trailPos.field_1352, trailPos.field_1351 + 0.3, trailPos.field_1350, 0.0, 0.05, 0.0);
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        int chargeTime = this.method_7881(stack, user) - remainingUseTicks;
        ChargeStage stage = this.getChargeStage(chargeTime);
        if (world.method_8608() && chargeTime > 2) {
            this.spawnChargingParticles((class_1657)user, stage);
        }
    }

    private void spawnChargingParticles(class_1657 player, ChargeStage stage) {
        class_1937 world = player.method_37908();
        class_243 pos = player.method_19538().method_1031(0.0, 1.0, 0.0);
        for (int i = 0; i < (switch (stage.ordinal()) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 5;
            default -> 1;
        }); ++i) {
            world.method_8406((class_2394)class_2398.field_29644, pos.field_1352 + (world.field_9229.method_43058() - 0.5) * 0.5, pos.field_1351 + world.field_9229.method_43058() * 1.5, pos.field_1350 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.02, 0.0);
        }
    }

    private static enum ChargeStage {
        INSTANT(5),
        QUICK(10),
        NORMAL(20),
        POWER(40);

        final int maxTick;

        private ChargeStage(int maxTick) {
            this.maxTick = maxTick;
        }
    }
}

