/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.item.custom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import s22.new_mod.item.custom.VoidGapBowItem;

public class VoidArrowManager {
    private static final Map<UUID, LinkedList<VoidArrowData>> playerVoidArrows = new HashMap<UUID, LinkedList<VoidArrowData>>();
    private static final Map<class_1923, Integer> loadedChunks = new HashMap<class_1923, Integer>();
    private static final int STACK_CAPACITY = 64;

    private static void loadChunkWeakly(class_1923 chunkPos) {
        loadedChunks.put(chunkPos, loadedChunks.getOrDefault(chunkPos, 0) + 1);
        System.out.println("\u5f31\u52a0\u8f7d\u533a\u5757: " + String.valueOf(chunkPos) + ", \u5f15\u7528\u8ba1\u6570: " + String.valueOf(loadedChunks.get(chunkPos)));
    }

    private static void unloadChunkWeakly(class_1923 chunkPos) {
        int count = loadedChunks.getOrDefault(chunkPos, 0) - 1;
        if (count <= 0) {
            loadedChunks.remove(chunkPos);
            System.out.println("\u5378\u8f7d\u533a\u5757: " + String.valueOf(chunkPos));
        } else {
            loadedChunks.put(chunkPos, count);
            System.out.println("\u51cf\u5c11\u533a\u5757\u5f15\u7528: " + String.valueOf(chunkPos) + ", \u5269\u4f59\u5f15\u7528: " + count);
        }
    }

    public static void addVoidArrow(class_3222 player, class_1665 arrow) {
        UUID playerId = player.method_5667();
        UUID arrowId = arrow.method_5667();
        class_243 position = arrow.method_19538();
        class_3218 world = (class_3218)arrow.method_37908();
        LinkedList arrowStack = playerVoidArrows.computeIfAbsent(playerId, k -> new LinkedList());
        VoidArrowData arrowData = new VoidArrowData(arrowId, position, world);
        arrowStack.addFirst(arrowData);
        System.out.println("\u6dfb\u52a0\u865a\u9699\u7bad\u77e2\u5230\u6808: \u73a9\u5bb6=" + player.method_5477().getString() + ", \u7bad\u77e2=" + String.valueOf(arrowId) + ", \u4f4d\u7f6e=" + String.valueOf(position) + ", \u6808\u5927\u5c0f=" + arrowStack.size() + "/64");
        if (arrowStack.size() > 64) {
            VoidArrowData removed = (VoidArrowData)arrowStack.removeLast();
            removed.cleanup();
            System.out.println("\u6808\u5df2\u6ee1\uff0c\u79fb\u9664\u6700\u65e7\u7684\u7bad\u77e2: " + String.valueOf(removed.arrowId));
        }
    }

    public static void updateArrowPositions() {
        for (LinkedList<VoidArrowData> arrowStack : playerVoidArrows.values()) {
            Iterator iterator = arrowStack.iterator();
            while (iterator.hasNext()) {
                VoidArrowData arrowData = (VoidArrowData)iterator.next();
                class_1665 arrow = arrowData.getArrow();
                if (arrow != null && arrow.method_5805() && !arrow.method_31481()) {
                    arrowData.updatePosition(arrow.method_19538());
                    continue;
                }
                arrowData.cleanup();
                iterator.remove();
                System.out.println("\u79fb\u9664\u5df2\u6d88\u5931\u7684\u7bad\u77e2: " + String.valueOf(arrowData.arrowId));
            }
        }
    }

    public static void handleTeleportRequest(class_3222 player) {
        UUID playerId = player.method_5667();
        LinkedList<VoidArrowData> arrowStack = playerVoidArrows.get(playerId);
        if (arrowStack == null || arrowStack.isEmpty()) {
            System.out.println("\u73a9\u5bb6 " + player.method_5477().getString() + " \u6ca1\u6709\u53ef\u4f20\u9001\u7684\u865a\u9699\u7bad\u77e2");
            return;
        }
        Iterator iterator = arrowStack.iterator();
        while (iterator.hasNext()) {
            VoidArrowData arrowData = (VoidArrowData)iterator.next();
            class_1665 arrow = arrowData.getArrow();
            if (arrow != null && arrow.method_5805() && !arrow.method_31481()) {
                System.out.println("\u73a9\u5bb6 " + player.method_5477().getString() + " \u4f20\u9001\u5230\u7bad\u77e2: " + String.valueOf(arrowData.arrowId));
                VoidGapBowItem.teleportToArrow((class_1657)player, arrow);
                arrowData.cleanup();
                iterator.remove();
                return;
            }
            arrowData.cleanup();
            iterator.remove();
            System.out.println("\u79fb\u9664\u65e0\u6548\u7bad\u77e2: " + String.valueOf(arrowData.arrowId));
        }
        System.out.println("\u73a9\u5bb6 " + player.method_5477().getString() + " \u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u865a\u9699\u7bad\u77e2");
    }

    public static void cleanup() {
        playerVoidArrows.entrySet().removeIf(entry -> ((LinkedList)entry.getValue()).isEmpty());
        loadedChunks.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
    }

    public static void clearPlayerArrows(class_3222 player) {
        UUID playerId = player.method_5667();
        LinkedList<VoidArrowData> arrowStack = playerVoidArrows.remove(playerId);
        if (arrowStack != null) {
            for (VoidArrowData arrowData : arrowStack) {
                arrowData.cleanup();
            }
            System.out.println("\u6e05\u7406\u73a9\u5bb6\u7bad\u77e2\u6570\u636e: " + player.method_5477().getString() + ", \u79fb\u9664 " + arrowStack.size() + " \u652f\u7bad");
        }
    }

    public static String getPlayerArrowStackInfo(class_3222 player) {
        UUID playerId = player.method_5667();
        LinkedList<VoidArrowData> arrowStack = playerVoidArrows.get(playerId);
        if (arrowStack == null || arrowStack.isEmpty()) {
            return "\u7bad\u77e2\u6808\u4e3a\u7a7a";
        }
        StringBuilder info = new StringBuilder("\u7bad\u77e2\u6808(" + arrowStack.size() + "/64): ");
        for (int i = 0; i < arrowStack.size(); ++i) {
            VoidArrowData arrowData = arrowStack.get(i);
            info.append("\n  ").append(i + 1).append(". ID: ").append(arrowData.arrowId.toString().substring(0, 8)).append("... \u4f4d\u7f6e: ").append(String.format("(%.1f, %.1f, %.1f)", arrowData.position.field_1352, arrowData.position.field_1351, arrowData.position.field_1350)).append(" \u533a\u5757: ").append(arrowData.chunkPos);
        }
        info.append("\n\u5f31\u52a0\u8f7d\u533a\u5757\u6570\u91cf: ").append(loadedChunks.size());
        return info.toString();
    }

    public static String getLoadedChunksInfo() {
        if (loadedChunks.isEmpty()) {
            return "\u6ca1\u6709\u5f31\u52a0\u8f7d\u7684\u533a\u5757";
        }
        StringBuilder info = new StringBuilder("\u5f31\u52a0\u8f7d\u533a\u5757(" + loadedChunks.size() + "):");
        for (Map.Entry<class_1923, Integer> entry : loadedChunks.entrySet()) {
            info.append("\n  ").append(entry.getKey()).append(" -> \u5f15\u7528\u8ba1\u6570: ").append(entry.getValue());
        }
        return info.toString();
    }

    private static class VoidArrowData {
        public final UUID arrowId;
        public class_243 position;
        public final long spawnTime;
        public final class_3218 world;
        public final class_1923 chunkPos;

        public VoidArrowData(UUID arrowId, class_243 position, class_3218 world) {
            this.arrowId = arrowId;
            this.position = position;
            this.world = world;
            this.chunkPos = new class_1923(class_2338.method_49638((class_2374)position));
            this.spawnTime = System.currentTimeMillis();
            VoidArrowManager.loadChunkWeakly(this.chunkPos);
        }

        public void updatePosition(class_243 newPosition) {
            this.position = newPosition;
            class_1923 newChunkPos = new class_1923(class_2338.method_49638((class_2374)newPosition));
            if (!this.chunkPos.equals((Object)newChunkPos)) {
                VoidArrowManager.unloadChunkWeakly(this.chunkPos);
                VoidArrowManager.loadChunkWeakly(newChunkPos);
            }
        }

        public class_1665 getArrow() {
            class_1297 entity = this.world.method_14190(this.arrowId);
            if (entity instanceof class_1665) {
                class_1665 arrow = (class_1665)entity;
                return arrow;
            }
            return null;
        }

        public void cleanup() {
            VoidArrowManager.unloadChunkWeakly(this.chunkPos);
        }
    }
}

