/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.networking;

import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import s22.new_mod.item.custom.HimSkillBookItem;
import s22.new_mod.item.custom.VoidArrowManager;
import s22.new_mod.networking.ShakeScreenS2CPacket;
import s22.new_mod.networking.ShowVoidImageS2CPacket;
import s22.new_mod.networking.UseSkillPayload;
import s22.new_mod.networking.VoidArrowTeleportPayload;

public class ModMessages {
    public static final class_2960 USE_SKILL_PACKET_ID = class_2960.method_60655((String)"new_mod", (String)"use_skill");
    private static boolean registered = false;

    public static void registerC2SPackets() {
        if (registered) {
            return;
        }
        PayloadTypeRegistry.playC2S().register(UseSkillPayload.ID, UseSkillPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(VoidArrowTeleportPayload.ID, VoidArrowTeleportPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ShakeScreenS2CPacket.ID, ShakeScreenS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ShowVoidImageS2CPacket.ID, ShowVoidImageS2CPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(UseSkillPayload.ID, ModMessages::receiveUseSkill);
        ServerPlayNetworking.registerGlobalReceiver(VoidArrowTeleportPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> VoidArrowManager.handleTeleportRequest(player));
        });
        registered = true;
    }

    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver(ShakeScreenS2CPacket.ID, ShakeScreenS2CPacket::handle);
        ClientPlayNetworking.registerGlobalReceiver(ShowVoidImageS2CPacket.ID, ShowVoidImageS2CPacket::handle);
    }

    public static void sendVoidArrowTeleport() {
        ClientPlayNetworking.send((class_8710)new VoidArrowTeleportPayload());
    }

    public static void receiveUseSkill(UseSkillPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_1268 hand = payload.hand();
        Objects.requireNonNull(player.method_5682()).execute(() -> {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() instanceof HimSkillBookItem) {
                int skillId = ((HimSkillBookItem)stack.method_7909()).getCurrentSkill(stack);
                HimSkillBookItem.useSkill(player.method_37908(), (class_1657)player, skillId);
            }
        });
    }

    public static void sendUseSkill(class_1268 hand) {
        ClientPlayNetworking.send((class_8710)new UseSkillPayload(hand));
    }

    public static void sendToPlayer(ShakeScreenS2CPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    public static void sendToPlayer(ShowVoidImageS2CPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }
}

