/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.networking;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4969;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record TeleportToNetherPacket(boolean toSpawn) implements class_8710
{
    public static final class_8710.class_9154<TeleportToNetherPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"new_mod", (String)"teleport_to_nether"));
    public static final class_9139<class_9129, TeleportToNetherPacket> CODEC = class_9139.method_56434((class_9139)class_9135.field_48547, TeleportToNetherPacket::toSpawn, TeleportToNetherPacket::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void register() {
        PayloadTypeRegistry.playS2C().register(ID, CODEC);
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            class_3222 player = context.player();
            TeleportToNetherPacket.handleTeleport(player, payload.toSpawn());
        });
    }

    private static void handleTeleport(class_3222 player, boolean toSpawn) {
        if (player == null || player.method_31481()) {
            return;
        }
        if (player.method_5682() == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668"), false);
            return;
        }
        class_3218 netherWorld = player.method_5682().method_3847(class_1937.field_25180);
        if (netherWorld == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u4e0b\u754c\u7ef4\u5ea6\u672a\u52a0\u8f7d"), false);
            return;
        }
        try {
            if (toSpawn) {
                TeleportToNetherPacket.teleportToSpawn(player, netherWorld);
            } else {
                TeleportToNetherPacket.teleportToSameCoords(player, netherWorld);
            }
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u4f20\u9001\u5931\u8d25: " + e.getMessage())), false);
            e.printStackTrace();
        }
    }

    private static void teleportToSpawn(class_3222 player, class_3218 netherWorld) {
        class_2338 respawnPos;
        if (player.method_26281() == class_1937.field_25180 && (respawnPos = player.method_26280()) != null && TeleportToNetherPacket.isValidRespawnAnchor(netherWorld, respawnPos)) {
            TeleportToNetherPacket.teleportToRespawnAnchor(player, netherWorld, respawnPos);
            return;
        }
        TeleportToNetherPacket.teleportToWorldSpawn(player, netherWorld);
    }

    private static boolean isValidRespawnAnchor(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof class_4969)) {
            return false;
        }
        if ((Integer)state.method_11654((class_2769)class_4969.field_23153) <= 0) {
            return false;
        }
        return world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074());
    }

    private static void teleportToRespawnAnchor(class_3222 player, class_3218 world, class_2338 pos) {
        player.method_14251(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        player.method_7353((class_2561)class_2561.method_43470((String)"\u5df2\u4f20\u9001\u5230\u4f60\u7684\u91cd\u751f\u951a\u4f4d\u7f6e"), false);
    }

    private static void teleportToWorldSpawn(class_3222 player, class_3218 world) {
        class_2338 spawnPos = world.method_43126();
        player.method_14251(world, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        player.method_7353((class_2561)class_2561.method_43470((String)"\u5df2\u4f20\u9001\u5230\u4e0b\u754c\u4e16\u754c\u51fa\u751f\u70b9"), false);
    }

    private static void teleportToSameCoords(class_3222 player, class_3218 netherWorld) {
        player.method_14251(netherWorld, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.method_7353((class_2561)class_2561.method_43470((String)"\u5df2\u4f20\u9001\u5230\u4e0b\u754c\u76f8\u540c\u5750\u6807\u4f4d\u7f6e"), false);
    }

    public static void send(boolean toSpawn) {
        try {
            ClientPlayNetworking.send((class_8710)new TeleportToNetherPacket(toSpawn));
        }
        catch (Exception e) {
            System.err.println("Failed to send teleport packet: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

