/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.kyrptonaught.customportalapi.api.CustomPortalBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import s22.new_mod.block.ModBlocks;
import s22.new_mod.block.entity.ModBlockEntities;
import s22.new_mod.command.HimCommand;
import s22.new_mod.datagen.ModAdvancementProvider;
import s22.new_mod.effect.ModEffects;
import s22.new_mod.entity.ModEntities;
import s22.new_mod.entity.custom.AutumnHeraldEntity;
import s22.new_mod.entity.custom.HematicSerenityEntity;
import s22.new_mod.entity.custom.HimEntity;
import s22.new_mod.entity.custom.SpringHeraldEntity;
import s22.new_mod.entity.custom.SummerHeraldEntity;
import s22.new_mod.entity.custom.WinterHeraldEntity;
import s22.new_mod.item.ModItemGroups;
import s22.new_mod.item.ModItemGroups_funny;
import s22.new_mod.item.ModItems;
import s22.new_mod.networking.ModMessages;
import s22.new_mod.networking.TeleportToEndPacket;
import s22.new_mod.networking.TeleportToNetherPacket;
import s22.new_mod.networking.TeleportToOverworldPacket;
import s22.new_mod.networking.UseSkillPayload;
import s22.new_mod.ritual.HematiteSerenityAltarHandler;
import s22.new_mod.ritual.HimAltarHandler;
import s22.new_mod.ritual.ThunderCraftingHandler;
import s22.new_mod.screen.ModScreenHandlers;
import s22.new_mod.serializer.ModRecipeSerializers;
import s22.new_mod.sound.ModSoundEvents;
import s22.new_mod.type.ModRecipeTypes;
import s22.new_mod.world.TimeFreezeManager;
import s22.new_mod.world.gen.ModWorldGeneration;

public class NEWMod
implements ModInitializer {
    public static final String MOD_ID = "new-mod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"new-mod");

    public void onInitialize() {
        LOGGER.info("Initializing new-mod...");
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModBlockEntities.register();
        ModEffects.registerEffects();
        ModSoundEvents.registerModSoundEvents();
        ModWorldGeneration.registerWorldGeneration();
        ModEntities.register();
        ModItemGroups.registerModItemGroups();
        ModItemGroups_funny.registerModItemGroups();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 world : server.method_3738()) {
                TimeFreezeManager.tick(world);
            }
        });
        ModMessages.registerC2SPackets();
        TeleportToEndPacket.register();
        TeleportToNetherPacket.register();
        TeleportToOverworldPacket.register();
        ModRecipeTypes.registerModRecipeTypes();
        ModRecipeSerializers.registerModRecipeSerializers();
        ModScreenHandlers.registerModScreenHandlers();
        ModRecipeTypes.printRegisteredTypes();
        ModRecipeSerializers.printRegisteredSerializers();
        ModScreenHandlers.printRegisteredScreenHandlers();
        FabricDefaultAttributeRegistry.register(ModEntities.HIM, (class_5132.class_5133)HimEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HEMATICSERENITY, (class_5132.class_5133)HematicSerenityEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SPRING_HERALD, (class_5132.class_5133)SpringHeraldEntity.createSpringHeraldAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SUMMER_HERALD, (class_5132.class_5133)SummerHeraldEntity.createSummerHeraldAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.AUTUMN_HERALD, (class_5132.class_5133)AutumnHeraldEntity.createAutumnHeraldAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.WINTER_HERALD, (class_5132.class_5133)WinterHeraldEntity.createWinterHeraldAttributes());
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2338 pos = hitResult.method_17777();
            if (world.method_8320(pos).method_27852(class_2246.field_10036)) {
                HimAltarHandler.handleAltarActivation(world, pos);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2338 pos = hitResult.method_17777();
            System.out.println("\u73a9\u5bb6\u4ea4\u4e92\u65b9\u5757: " + String.valueOf(world.method_8320(pos).method_26204()) + " \u4f4d\u7f6e: " + String.valueOf(pos));
            if (world.method_8320(pos).method_27852(ModBlocks.BLUE_FIRE)) {
                System.out.println("\u68c0\u6d4b\u5230\u84dd\u8272\u706b\u7130\uff0c\u6fc0\u6d3b\u796d\u575b!");
                HematiteSerenityAltarHandler.handleAltarActivation(world, pos, player);
            }
            return class_1269.field_5811;
        });
        class_174.method_767((String)ModAdvancementProvider.BossSuppressorCriterion.ID.toString(), (class_179)ModAdvancementProvider.BossSuppressorCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.SpringHeraldKilledCriterion.ID.toString(), (class_179)ModAdvancementProvider.SpringHeraldKilledCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.SummerHeraldKilledCriterion.ID.toString(), (class_179)ModAdvancementProvider.SummerHeraldKilledCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.AutumnHeraldKilledCriterion.ID.toString(), (class_179)ModAdvancementProvider.AutumnHeraldKilledCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.WinterHeraldKilledCriterion.ID.toString(), (class_179)ModAdvancementProvider.WinterHeraldKilledCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.HimKilledCriterion.ID.toString(), (class_179)ModAdvancementProvider.HimKilledCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.TimeStopHourglassUsedCriterion.ID.toString(), (class_179)ModAdvancementProvider.TimeStopHourglassUsedCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.ThreeEntityThunderHitCriterion.ID.toString(), (class_179)ModAdvancementProvider.ThreeEntityThunderHitCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.ThunderEscapeBladeCraftedCriterion.ID.toString(), (class_179)ModAdvancementProvider.ThunderEscapeBladeCraftedCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.PerfectThunderCraftingCriterion.ID.toString(), (class_179)ModAdvancementProvider.PerfectThunderCraftingCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.MaximumChargeAttackCriterion.ID.toString(), (class_179)ModAdvancementProvider.MaximumChargeAttackCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.MultiTargetHitCriterion.ID.toString(), (class_179)ModAdvancementProvider.MultiTargetHitCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.ThunderDashDistanceCriterion.ID.toString(), (class_179)ModAdvancementProvider.ThunderDashDistanceCriterion.INSTANCE);
        class_174.method_767((String)ModAdvancementProvider.RapidDashCriterion.ID.toString(), (class_179)ModAdvancementProvider.RapidDashCriterion.INSTANCE);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> HimCommand.register((CommandDispatcher<class_2168>)dispatcher));
        CustomPortalBuilder.beginPortal().frameBlock(ModBlocks.SEASON_BLOCK).lightWithItem(ModItems.FORTIFIER).destDimID(class_2960.method_60655((String)MOD_ID, (String)"season_root")).tintColor(38143).registerPortal();
        StrippableBlockRegistry.register((class_2248)ModBlocks.ICE_ETHER_LOG, (class_2248)ModBlocks.STRIPPED_ICE_ETHER_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.ICE_ETHER_WOOD, (class_2248)ModBlocks.STRIPPED_ICE_ETHER_LOG);
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 world : server.method_3738()) {
                if (world.method_8510() % 5L != 0L) continue;
                NEWMod.checkAllWorkbenches(world);
            }
        });
        LOGGER.info("new-mod initialized successfully!");
    }

    private static void checkAllWorkbenches(class_3218 world) {
        world.method_18456().forEach(player -> {
            class_2338 playerPos = player.method_24515();
            for (int x = -16; x <= 16; ++x) {
                for (int y = -8; y <= 8; ++y) {
                    for (int z = -16; z <= 16; ++z) {
                        class_2338 checkPos = playerPos.method_10069(x, y, z);
                        if (!world.method_8320(checkPos).method_27852(class_2246.field_9980)) continue;
                        ThunderCraftingHandler.checkThunderCrafting((class_1937)world, checkPos);
                    }
                }
            }
        });
    }

    public static void onUnload() {
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)UseSkillPayload.ID.comp_2242());
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)TeleportToEndPacket.ID.comp_2242());
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)TeleportToNetherPacket.ID.comp_2242());
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)TeleportToOverworldPacket.ID.comp_2242());
        LOGGER.info("new-mod network packets unregistered.");
    }
}

