/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.client;

import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ScreenShakeManager {
    private static float currentShakeIntensity = 0.0f;
    private static int shakeDuration = 0;
    private static int shakeTimer = 0;
    private static float lastShakeX = 0.0f;
    private static float lastShakeY = 0.0f;
    private static long lastWorldTime = 0L;

    public static void addShake(float intensity, int duration) {
        if (intensity > currentShakeIntensity) {
            currentShakeIntensity = intensity;
            shakeDuration = duration;
            shakeTimer = 0;
        }
    }

    public static void tick() {
        if (shakeDuration > 0) {
            if (++shakeTimer >= shakeDuration) {
                ScreenShakeManager.reset();
            } else {
                float progress = (float)shakeTimer / (float)shakeDuration;
                currentShakeIntensity *= 1.0f - progress * 0.7f;
            }
        }
    }

    public static void updateShakeOffsets(float tickDelta) {
        class_310 client = class_310.method_1551();
        if (currentShakeIntensity > 0.0f && client.field_1724 != null && client.field_1687 != null) {
            long worldTime = client.field_1687.method_8510();
            float totalTime = (float)worldTime + tickDelta;
            lastShakeX = (class_3532.method_15374((float)(totalTime * 0.8f)) + class_3532.method_15362((float)(totalTime * 0.5f)) * 0.3f) * currentShakeIntensity * 3.0f;
            lastShakeY = (class_3532.method_15362((float)(totalTime * 0.6f)) + class_3532.method_15374((float)(totalTime * 0.4f)) * 0.4f) * currentShakeIntensity * 2.0f;
            lastWorldTime = worldTime;
        } else {
            lastShakeX = 0.0f;
            lastShakeY = 0.0f;
        }
    }

    public static float getShakeOffsetX() {
        return lastShakeX;
    }

    public static float getShakeOffsetY() {
        return lastShakeY;
    }

    public static boolean isShaking() {
        return currentShakeIntensity > 0.0f && shakeDuration > 0;
    }

    public static void reset() {
        currentShakeIntensity = 0.0f;
        shakeDuration = 0;
        shakeTimer = 0;
        lastShakeX = 0.0f;
        lastShakeY = 0.0f;
        lastWorldTime = 0L;
    }

    public static float getCurrentIntensity() {
        return currentShakeIntensity;
    }

    public static int getRemainingDuration() {
        return Math.max(0, shakeDuration - shakeTimer);
    }
}

