/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.entity.custom;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7094;

public class HematicSerenityEntity
extends class_1588 {
    private int recentInhibitionCount = 0;
    private int inhibitionCooldown = 0;
    public static final int SKILL_VOID_GAZE = 6;
    private static final int VOID_GAZE_COOLDOWN = 200;
    private int voidGazeCooldown = 0;
    private static final class_3414 VOID_GAZE_CHARGE = class_3417.field_14671;
    private static final class_3414 VOID_GAZE_SHOOT = class_3417.field_14703;
    private static final class_2940<Integer> CURRENT_SKILL = class_2945.method_12791(HematicSerenityEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_CASTING_SKILL = class_2945.method_12791(HematicSerenityEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SKILL_ANIMATION_TICKS = class_2945.method_12791(HematicSerenityEntity.class, (class_2941)class_2943.field_13327);
    public static final int SKILL_NONE = 0;
    public static final int SKILL_VOID_NOVA = 1;
    public static final int SKILL_TENTACLE_LASH = 2;
    public static final int SKILL_COSMIC_POOL = 3;
    public static final int SKILL_ELDRITCH_GAZE = 4;
    public static final int SKILL_RITUAL_OF_THE_DEEP = 5;
    public static final class_7094 idleAnimationState = new class_7094();
    public static final class_7094 attackAnimationState = new class_7094();
    public static final class_7094 specialAnimationState = new class_7094();
    public int idleAnimationTimeout = 0;
    private boolean isInhibited = false;
    private int inhibitionLevel = 0;
    private int inhibitionTicks = 0;
    private int voidNovaCooldown = 0;
    private int tentacleLashCooldown = 0;
    private int cosmicPoolCooldown = 0;
    private int eldritchGazeCooldown = 0;
    private int ritualOfTheDeepCooldown = 0;
    private static final int VOID_NOVA_COOLDOWN = 120;
    private static final int TENTACLE_LASH_COOLDOWN = 80;
    private static final int COSMIC_POOL_COOLDOWN = 200;
    private static final int ELDRITCH_GAZE_COOLDOWN = 180;
    private static final int RITUAL_OF_THE_DEEP_COOLDOWN = 300;
    private static final int GLOBAL_COOLDOWN = 20;
    private int nextSkillDelay = 0;
    private int minSkillDelay = 30;
    private int maxSkillDelay = 120;
    private float skillRandomness = 0.4f;
    private boolean isDying = false;
    private int deathAnimationTicks = 0;
    private static final int DEATH_ANIMATION_DURATION = 120;
    private class_243 deathStartPos;
    private static final class_2940<Float> VOID_ENERGY = class_2945.method_12791(HematicSerenityEntity.class, (class_2941)class_2943.field_13320);
    private static final class_3414 VOID_NOVA_CHARGE = class_3417.field_38831;
    private static final class_3414 VOID_NOVA_EXPLODE = class_3417.field_38830;
    private static final class_3414 TENTACLE_LASH_SOUND = class_3417.field_15203;
    private static final class_3414 COSMIC_POOL_SOUND = class_3417.field_14632;
    private static final class_3414 ELDRITCH_GAZE_SOUND = class_3417.field_14671;
    private static final class_3414 RITUAL_SOUND = class_3417.field_14858;
    private static final class_3414 AMBIENT_SOUND = class_3417.field_15071;
    private static final class_3414 DEATH_CHARGE = class_3417.field_14792;
    private static final class_3414 DEATH_EXPLODE = class_3417.field_14773;
    private boolean isVoidRage = false;
    private int voidRageDuration = 0;
    private static final int MAX_VOID_RAGE_DURATION = 400;
    private int voidRageThreshold = 600;
    private static final class_2394 VOID_PARTICLE = class_2398.field_11216;
    private static final class_2394 COSMIC_PARTICLE = class_2398.field_29644;
    private static final class_2394 TENTACLE_PARTICLE = class_2398.field_11233;
    private static final class_2394 ELDRITCH_PARTICLE = class_2398.field_22246;
    private static final class_2394 RITUAL_PARTICLE = class_2398.field_23190;

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VOID_ENERGY, (Object)Float.valueOf(0.0f));
        builder.method_56912(CURRENT_SKILL, (Object)0);
        builder.method_56912(IS_CASTING_SKILL, (Object)false);
        builder.method_56912(SKILL_ANIMATION_TICKS, (Object)0);
    }

    public void applyInhibitionEffect(int level, int duration, class_1657 source) {
        if (this.inhibitionCooldown > 0) {
            return;
        }
        this.isInhibited = true;
        this.inhibitionLevel = level;
        this.inhibitionTicks = duration;
        ++this.recentInhibitionCount;
        this.inhibitionCooldown = 600;
        switch (level) {
            case 3: {
                this.applyHeavyInhibition(duration);
                break;
            }
            case 2: {
                this.applyMediumInhibition(duration);
                break;
            }
            case 1: {
                this.applyLightInhibition(duration);
            }
        }
    }

    private void applyLightInhibition(int duration) {
        this.method_6092(new class_1293(class_1294.field_5909, duration, 2, false, false));
        Objects.requireNonNull(Objects.requireNonNull(this.method_5996(class_5134.field_23719))).method_6192(0.3);
    }

    private void applyMediumInhibition(int duration) {
        this.method_6092(new class_1293(class_1294.field_5909, duration, 4, false, false));
        Objects.requireNonNull(Objects.requireNonNull(this.method_5996(class_5134.field_23719))).method_6192(0.1);
        this.method_6092(new class_1293(class_1294.field_5911, duration, 2, false, false));
    }

    private void applyHeavyInhibition(int duration) {
        this.method_6092(new class_1293(class_1294.field_5909, duration, 6, false, false));
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        this.method_6092(new class_1293(class_1294.field_5911, duration, 4, false, false));
        this.method_6092(new class_1293(class_1294.field_5919, duration, 0, false, false));
        if (this.isCastingSkill()) {
            this.endSkillAnimation();
        }
        this.method_5643(this.method_48923().method_48831(), 10.0f);
    }

    public boolean isCastingSkill() {
        return (Boolean)this.field_6011.method_12789(IS_CASTING_SKILL);
    }

    public int getCurrentSkill() {
        return (Integer)this.field_6011.method_12789(CURRENT_SKILL);
    }

    public int getSkillAnimationTicks() {
        return (Integer)this.field_6011.method_12789(SKILL_ANIMATION_TICKS);
    }

    public void triggerSkillAnimation(int skillType, int duration) {
        this.field_6011.method_12778(CURRENT_SKILL, (Object)skillType);
        this.field_6011.method_12778(IS_CASTING_SKILL, (Object)true);
        this.field_6011.method_12778(SKILL_ANIMATION_TICKS, (Object)0);
        Objects.requireNonNull(this.method_37908().method_8503()).execute(() -> {
            if (this.method_5805()) {
                this.method_37908().method_8503().method_20493(() -> {
                    try {
                        Thread.sleep((long)duration * 50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (this.method_5805()) {
                        this.endSkillAnimation();
                    }
                });
            }
        });
    }

    public void endSkillAnimation() {
        this.field_6011.method_12778(IS_CASTING_SKILL, (Object)false);
        this.field_6011.method_12778(CURRENT_SKILL, (Object)0);
        this.field_6011.method_12778(SKILL_ANIMATION_TICKS, (Object)0);
    }

    public HematicSerenityEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
        this.method_6033(this.method_6063());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.2, false));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(6, (class_1352)new VoidTeleportGoal(this, this));
        this.field_6201.method_6277(7, (class_1352)new VoidRageGoal(this, this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 1800.0).method_26868(class_5134.field_23721, 28.0).method_26868(class_5134.field_23724, 20.0).method_26868(class_5134.field_23725, 8.0).method_26868(class_5134.field_23718, 0.8).method_26868(class_5134.field_23719, 0.75).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23723, 1.8);
    }

    public void method_5773() {
        if (this.isDying) {
            --this.deathAnimationTicks;
            this.handleDeathAnimation();
            return;
        }
        super.method_5773();
        if (this.isInhibited) {
            --this.inhibitionTicks;
            if (this.inhibitionTicks <= 0) {
                this.endInhibition();
            }
            if (this.inhibitionLevel >= 2) {
                this.method_18800(0.0, this.method_18798().field_1351, 0.0);
                this.field_6007 = true;
                this.method_5942().method_6340();
            }
        }
        if (this.inhibitionCooldown > 0) {
            --this.inhibitionCooldown;
        }
        if (this.inhibitionCooldown == 0 && this.recentInhibitionCount > 0) {
            this.recentInhibitionCount = 0;
        }
        if (this.isCastingSkill() && this.method_37908() != null && !this.method_37908().field_9236) {
            int ticks = this.getSkillAnimationTicks();
            this.field_6011.method_12778(SKILL_ANIMATION_TICKS, (Object)(ticks + 1));
        }
        this.setupAnimation();
        if (this.isVoidRage) {
            --this.voidRageDuration;
            if (this.voidRageDuration <= 0) {
                this.endVoidRage();
            }
            if (this.field_6012 % 3 == 0 && this.method_37908().field_9236) {
                this.spawnVoidRageParticles();
            }
            if (this.field_6012 % 30 == 0 && !this.method_37908().method_8608()) {
                this.voidRageSkill();
            }
        }
        if (this.method_37908() != null && this.method_37908().field_9236 && this.field_6012 % 2 == 0) {
            this.spawnParticle(VOID_PARTICLE, 0.8, 1.2, 0.8, 0.03);
            this.spawnParticle(COSMIC_PARTICLE, 0.6, 1.0, 0.6, 0.02);
            if (this.isVoidRage && this.field_5974.method_43048(2) == 0) {
                this.spawnParticle(ELDRITCH_PARTICLE, 1.2, 1.8, 1.2, 0.08);
            }
            if (this.field_5974.method_43048(5) == 0) {
                this.spawnTentacleParticles();
            }
        }
        if (this.field_6012 % 40 == 0 && this.method_6032() < this.method_6063()) {
            float healthRatio = this.method_6032() / this.method_6063();
            float healAmount = healthRatio < 0.25f ? 3.0f : (healthRatio < 0.5f ? 2.0f : 1.0f);
            if (this.isVoidRage) {
                healAmount *= 2.0f;
            }
            this.method_6025(healAmount);
        }
        if (this.field_6012 % 200 == 0 && (double)this.field_5974.method_43057() < 0.4) {
            this.method_5783(AMBIENT_SOUND, this.isVoidRage ? 1.6f : 1.0f, 0.5f + this.field_5974.method_43057() * 0.3f);
        }
        if (this.method_37908() != null && !this.method_37908().field_9236) {
            this.updateCooldowns();
            this.checkSkillTriggers();
            this.updateVoidEnergy();
        }
    }

    private void endInhibition() {
        this.isInhibited = false;
        this.inhibitionLevel = 0;
        this.inhibitionTicks = 0;
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.75);
    }

    public boolean isInhibited() {
        return this.isInhibited;
    }

    public int getInhibitionLevel() {
        return this.inhibitionLevel;
    }

    private void handleDeathAnimation() {
        class_3218 serverWorld;
        class_1937 class_19372;
        float progress = 1.0f - (float)this.deathAnimationTicks / 120.0f;
        double yOffset = Math.sin((double)progress * Math.PI) * 8.0;
        double voidPulse = Math.sin((double)this.field_6012 * 0.25) * 0.6 * (double)progress;
        this.method_5814(this.deathStartPos.field_1352 + voidPulse, this.deathStartPos.field_1351 + yOffset, this.deathStartPos.field_1350 + voidPulse);
        if (this.deathAnimationTicks % 2 == 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            this.spawnDeathVoidBeam(serverWorld, progress);
            this.spawnVoidEnergyRings(serverWorld, progress);
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            this.spawnBodyVoidDissolveParticles(serverWorld, progress);
        }
        if (this.field_6012 % 5 == 0 && this.method_37908().field_9236) {
            for (int i = 0; i < 10; ++i) {
                double angle = this.field_5974.method_43058() * Math.PI * 2.0;
                double radius = 1.0 + (double)progress * 3.0;
                this.method_37908().method_8406(VOID_PARTICLE, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + 1.0, this.method_23321() + Math.sin(angle) * radius, -Math.cos(angle) * 0.2, 0.3, -Math.sin(angle) * 0.2);
            }
            if (this.field_5974.method_43057() < 0.3f) {
                this.spawnTentacleDissolveParticles();
            }
        }
        if (progress > 0.5f) {
            class_1937 class_19373;
            float intensity = (progress - 0.5f) * 2.0f;
            if (this.method_37908().field_9236) {
                for (int i = 0; i < (int)(intensity * 20.0f); ++i) {
                    this.spawnParticle(ELDRITCH_PARTICLE, 2.0f * intensity, 2.0f * intensity, 2.0f * intensity, 0.3f * intensity);
                }
            }
            if ((class_19373 = this.method_37908()) instanceof class_3218) {
                class_3218 serverWorld2 = (class_3218)class_19373;
                if (this.deathAnimationTicks % 4 == 0) {
                    int waves = 3 + (int)(intensity * 3.0f);
                    for (int w = 0; w < waves; ++w) {
                        double waveRadius = 2.0 + (double)w * 1.5 + (double)intensity * 4.0;
                        int particles = 20 + w * 10;
                        for (int i = 0; i < particles; ++i) {
                            double angle = Math.toRadians((double)i * (360.0 / (double)particles));
                            serverWorld2.method_14199(COSMIC_PARTICLE, this.method_23317() + Math.cos(angle) * waveRadius, this.method_23318() + 0.5, this.method_23321() + Math.sin(angle) * waveRadius, 1, 0.0, 0.2, 0.0, 0.1);
                        }
                    }
                }
            }
        }
        if (progress > 0.8f) {
            this.spawnFinalVoidExplosionEffects();
        }
        if (this.deathAnimationTicks <= 0) {
            this.completeVoidDeathAnimation();
        }
    }

    private void spawnTentacleDissolveParticles() {
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 8; ++i) {
                double angle = this.field_5974.method_43058() * Math.PI * 2.0;
                double length = 1.5 + this.field_5974.method_43058() * 2.5;
                double curl = Math.sin((double)this.field_6012 * 0.3) * 0.8;
                for (int j = 0; j < 6; ++j) {
                    double progress = (double)j / 6.0;
                    double curve = Math.sin(progress * Math.PI) * curl;
                    double x = Math.cos(angle + curve) * length * progress;
                    double z = Math.sin(angle + curve) * length * progress;
                    double y = progress * 1.2;
                    this.method_37908().method_8406(TENTACLE_PARTICLE, this.method_23317() + x, this.method_23318() + y, this.method_23321() + z, 0.0, 0.05, 0.0);
                    if (j % 2 != 0) continue;
                    this.method_37908().method_8406(ELDRITCH_PARTICLE, this.method_23317() + x, this.method_23318() + y, this.method_23321() + z, 0.0, 0.03, 0.0);
                }
            }
        }
    }

    private void spawnFinalVoidExplosionEffects() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float intensity = 1.0f - (float)this.deathAnimationTicks / 120.0f;
            if (this.deathAnimationTicks % 10 == 0) {
                serverWorld.method_14199((class_2394)class_2398.field_17909, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 8, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.deathAnimationTicks % 5 == 0) {
                int particles = 30 + (int)(intensity * 50.0f);
                for (int i = 0; i < particles; ++i) {
                    double angle = this.field_5974.method_43058() * Math.PI * 2.0;
                    double radius = 3.0 + this.field_5974.method_43058() * 4.0;
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    serverWorld.method_14199(VOID_PARTICLE, this.method_23317() + x, this.method_23318() + 1.5, this.method_23321() + z, 2, -x * 0.1, 0.2, -z * 0.1, 0.15);
                }
            }
            if (this.deathAnimationTicks == 20) {
                this.method_5783(class_3417.field_14865, 4.0f, 0.2f);
                this.method_5783(class_3417.field_14671, 3.5f, 0.3f);
            }
        }
    }

    private void completeVoidDeathAnimation() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 80; ++i) {
                serverWorld.method_14199((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 3, (this.field_5974.method_43058() - 0.5) * 2.5, 0.9, (this.field_5974.method_43058() - 0.5) * 2.5, 1.5);
                serverWorld.method_14199(VOID_PARTICLE, this.method_23317(), this.method_23318() + 1.8, this.method_23321(), 6, (this.field_5974.method_43058() - 0.5) * 3.0, 0.8, (this.field_5974.method_43058() - 0.5) * 3.0, 0.6);
                serverWorld.method_14199(COSMIC_PARTICLE, this.method_23317(), this.method_23318() + 1.6, this.method_23321(), 4, (this.field_5974.method_43058() - 0.5) * 2.5, 0.7, (this.field_5974.method_43058() - 0.5) * 2.5, 0.4);
            }
            for (int r = 1; r <= 5; ++r) {
                int segments = 36;
                double radius = (double)r * 5.0;
                for (int i = 0; i < segments; ++i) {
                    double angle = (double)i * (Math.PI * 2 / (double)segments);
                    serverWorld.method_14199((class_2394)class_2398.field_38908, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + 1.5, this.method_23321() + Math.sin(angle) * radius, 2, 0.0, 0.0, 0.0, 0.0);
                }
            }
            this.method_5783(DEATH_EXPLODE, 7.0f, 0.1f);
            this.method_5783(class_3417.field_14773, 5.0f, 0.3f);
            this.method_5783(class_3417.field_14865, 4.5f, 0.4f);
            this.method_5783(class_3417.field_14931, 3.5f, 0.1f);
        }
        this.method_5650(class_1297.class_5529.field_26998);
    }

    private void setupAnimation() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void updateCooldowns() {
        if (this.voidGazeCooldown > 0) {
            --this.voidGazeCooldown;
        }
        if (this.voidNovaCooldown > 0) {
            --this.voidNovaCooldown;
        }
        if (this.tentacleLashCooldown > 0) {
            --this.tentacleLashCooldown;
        }
        if (this.cosmicPoolCooldown > 0) {
            --this.cosmicPoolCooldown;
        }
        if (this.eldritchGazeCooldown > 0) {
            --this.eldritchGazeCooldown;
        }
        if (this.ritualOfTheDeepCooldown > 0) {
            --this.ritualOfTheDeepCooldown;
        }
    }

    private void updateVoidEnergy() {
        float voidEnergy = 1.0f - this.method_6032() / this.method_6063();
        this.field_6011.method_12778(VOID_ENERGY, (Object)Float.valueOf(voidEnergy));
    }

    public float getVoidEnergy() {
        return ((Float)this.field_6011.method_12789(VOID_ENERGY)).floatValue();
    }

    private void checkSkillTriggers() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        if (this.nextSkillDelay <= 0) {
            double distance = this.method_5739((class_1297)target);
            float baseChance = this.isVoidRage ? 0.7f : 0.3f;
            float distanceFactor = 1.0f - (float)(distance / 25.0);
            float energyFactor = this.getVoidEnergy();
            float finalChance = baseChance * (1.0f + this.skillRandomness * (this.field_5974.method_43057() - 0.5f)) * distanceFactor * energyFactor;
            if (this.field_5974.method_43057() < finalChance) {
                this.useRandomSkill(target);
                this.nextSkillDelay = this.field_5974.method_43048(this.maxSkillDelay - this.minSkillDelay) + this.minSkillDelay;
            }
        } else {
            --this.nextSkillDelay;
        }
    }

    private void useRandomSkill(class_1309 target) {
        if (target == null) {
            return;
        }
        double distance = this.method_5739((class_1297)target);
        ArrayList<Runnable> availableSkills = new ArrayList<Runnable>();
        if (distance < 12.0 && this.voidNovaCooldown <= 0) {
            availableSkills.add(() -> {
                this.voidNovaAttack();
                this.voidNovaCooldown = 120;
            });
        }
        if (distance < 25.0 && this.voidGazeCooldown <= 0) {
            availableSkills.add(() -> {
                this.castVoidGaze();
                this.voidGazeCooldown = 200;
            });
        }
        if (distance < 10.0 && this.tentacleLashCooldown <= 0) {
            availableSkills.add(() -> {
                this.tentacleLashAttack(target);
                this.tentacleLashCooldown = 80;
            });
        }
        if (distance < 15.0 && this.cosmicPoolCooldown <= 0) {
            availableSkills.add(() -> {
                this.createCosmicPool();
                this.cosmicPoolCooldown = 200;
            });
        }
        if (this.eldritchGazeCooldown <= 0) {
            availableSkills.add(() -> {
                this.castEldritchGaze(target);
                this.eldritchGazeCooldown = 180;
            });
        }
        if (this.ritualOfTheDeepCooldown <= 0 && (double)this.method_6032() < (double)this.method_6063() * 0.4) {
            availableSkills.add(() -> {
                this.performRitualOfTheDeep();
                this.ritualOfTheDeepCooldown = 300;
            });
        }
        if (!availableSkills.isEmpty()) {
            int index = this.field_5974.method_43048(availableSkills.size());
            ((Runnable)availableSkills.get(index)).run();
            this.triggerGlobalCooldown();
        }
    }

    private void triggerGlobalCooldown() {
        this.voidGazeCooldown = Math.max(this.voidGazeCooldown, 20);
        this.voidNovaCooldown = Math.max(this.voidNovaCooldown, 20);
        this.tentacleLashCooldown = Math.max(this.tentacleLashCooldown, 20);
        this.cosmicPoolCooldown = Math.max(this.cosmicPoolCooldown, 20);
        this.eldritchGazeCooldown = Math.max(this.eldritchGazeCooldown, 20);
        this.ritualOfTheDeepCooldown = Math.max(this.ritualOfTheDeepCooldown, 20);
    }

    public void voidNovaAttack() {
        class_1937 class_19372;
        this.triggerSkillAnimation(1, 30);
        this.method_5783(VOID_NOVA_CHARGE, 2.0f, 0.3f);
        specialAnimationState.method_41322(this.field_6012);
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 30; ++i) {
                double angle = Math.toRadians(i * 12);
                double radius = 1.5 + Math.sin((double)this.field_6012 * 0.2) * 0.5;
                this.method_37908().method_8406(VOID_PARTICLE, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + 1.0, this.method_23321() + Math.sin(angle) * radius, 0.0, 0.1, 0.0);
            }
        }
        if (this.method_37908() != null && !this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805()) {
                    return;
                }
                this.method_5783(VOID_NOVA_EXPLODE, 2.5f, 0.2f);
                for (int r = 1; r <= 4; ++r) {
                    double radius = (double)r * 3.0;
                    int particles = 25 * r;
                    for (int i = 0; i < particles; ++i) {
                        double angle = Math.toRadians((double)i * (360.0 / (double)particles));
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        serverWorld.method_14199(VOID_PARTICLE, this.method_23317() + x, this.method_23318() + 0.8, this.method_23321() + z, 3, 0.2, 0.3, 0.2, 0.08);
                        if (i % 4 != 0) continue;
                        serverWorld.method_14199(COSMIC_PARTICLE, this.method_23317() + x, this.method_23318() + 0.8, this.method_23321() + z, 2, 0.1, 0.2, 0.1, 0.05);
                    }
                }
                double radius = 8.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805())) {
                    float damage = this.isVoidRage ? 40.0f : 25.0f;
                    entity.method_5643(this.method_48923().method_48831(), damage);
                    this.method_6025(damage * 0.2f);
                    class_243 knockback = entity.method_19538().method_1020(this.method_19538()).method_1029().method_1021(2.5);
                    entity.method_5762(knockback.field_1352, 1.0, knockback.field_1350);
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = entity;
                    living.method_6092(new class_1293(class_1294.field_5919, 80, 0, true, false, false));
                    living.method_6092(new class_1293(class_1294.field_5909, 100, 2, true, false, false));
                }
            });
        }
        this.method_37908().method_8503().execute(() -> {
            if (this.method_5805()) {
                this.endSkillAnimation();
            }
        });
    }

    public void tentacleLashAttack(class_1309 target) {
        class_1937 class_19372;
        this.triggerSkillAnimation(2, 20);
        this.method_5783(TENTACLE_LASH_SOUND, 1.8f, 0.4f);
        attackAnimationState.method_41322(this.field_6012);
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 20; ++i) {
                double progress = (double)i / 20.0;
                double x = this.method_23317() + (target.method_23317() - this.method_23317()) * progress;
                double y = this.method_23318() + 1.2 + (target.method_23320() - this.method_23318() - 1.2) * progress;
                double z = this.method_23321() + (target.method_23321() - this.method_23321()) * progress;
                this.method_37908().method_8406(TENTACLE_PARTICLE, x, y, z, (this.field_5974.method_43058() - 0.5) * 0.1, 0.08, (this.field_5974.method_43058() - 0.5) * 0.1);
                if (i % 3 != 0) continue;
                this.method_37908().method_8406(ELDRITCH_PARTICLE, x, y, z, 0.0, 0.05, 0.0);
            }
        }
        if (this.method_37908() != null && !this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805() || !target.method_5805()) {
                    return;
                }
                float damage = this.isVoidRage ? 35.0f : 22.0f;
                target.method_5643(this.method_48923().method_48812((class_1309)this), damage);
                this.method_6025(damage * 0.3f);
                class_243 pullDirection = this.method_19538().method_1020(target.method_19538()).method_1029().method_1021(2.0);
                target.method_5762(pullDirection.field_1352, 0.7, pullDirection.field_1350);
                target.method_6092(new class_1293(class_1294.field_5902, 60, 0, true, false, false));
                target.method_6092(new class_1293(class_1294.field_5911, 120, 1, true, false, false));
                serverWorld.method_14199(COSMIC_PARTICLE, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 15, 0.6, 0.7, 0.6, 0.15);
            });
        }
        Objects.requireNonNull(this.method_37908().method_8503()).execute(() -> {
            if (this.method_5805()) {
                this.endSkillAnimation();
            }
        });
    }

    public void createCosmicPool() {
        class_1937 class_19372;
        this.triggerSkillAnimation(3, 40);
        this.method_5783(COSMIC_POOL_SOUND, 1.8f, 0.5f);
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 40; ++i) {
                double angle = Math.toRadians(i * 9);
                double radius = 4.0;
                double yOffset = Math.sin((double)this.field_6012 * 0.1 + (double)i * 0.2) * 0.3;
                this.method_37908().method_8406(RITUAL_PARTICLE, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + 0.1 + yOffset, this.method_23321() + Math.sin(angle) * radius, Math.cos(angle) * 0.05, 0.08, Math.sin(angle) * 0.05);
            }
        }
        if (this.method_37908() != null && !this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805()) {
                    return;
                }
                double radius = 5.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805())) {
                    if (!(entity instanceof class_1657)) continue;
                    entity.method_5643(this.method_48923().method_48831(), 8.0f);
                    entity.method_6092(new class_1293(class_1294.field_38092, 100, 0, true, false, false));
                    entity.method_6092(new class_1293(class_1294.field_5909, 100, 3, true, false, false));
                    this.method_6025(3.0f);
                    this.method_6092(new class_1293(class_1294.field_5907, 120, 0, true, false, false));
                }
                for (int i = 0; i < 60; ++i) {
                    double angle = Math.toRadians(serverWorld.method_8409().method_43048(360));
                    double dist = serverWorld.method_8409().method_43058() * radius;
                    double yOffset = Math.sin((double)this.field_6012 * 0.2 + (double)i * 0.1) * 0.4;
                    serverWorld.method_14199(RITUAL_PARTICLE, this.method_23317() + Math.cos(angle) * dist, this.method_23318() + 0.1 + yOffset, this.method_23321() + Math.sin(angle) * dist, 2, 0.0, 0.1, 0.0, 0.02);
                    if (serverWorld.method_8409().method_43048(3) != 0) continue;
                    serverWorld.method_14199(COSMIC_PARTICLE, this.method_23317() + Math.cos(angle) * dist, this.method_23318() + 0.2 + yOffset, this.method_23321() + Math.sin(angle) * dist, 1, 0.0, 0.05, 0.0, 0.01);
                }
            });
        }
        this.method_37908().method_8503().execute(() -> {
            if (this.method_5805()) {
                this.endSkillAnimation();
            }
        });
    }

    public void castEldritchGaze(class_1309 target) {
        class_1937 class_19372;
        this.triggerSkillAnimation(4, 30);
        this.method_5783(ELDRITCH_GAZE_SOUND, 2.0f, 0.3f);
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 25; ++i) {
                double progress = (double)i / 25.0;
                double x = this.method_23317() + (target.method_23317() - this.method_23317()) * progress;
                double y = this.method_23318() + 1.8 + (target.method_23320() - this.method_23318() - 1.8) * progress;
                double z = this.method_23321() + (target.method_23321() - this.method_23321()) * progress;
                this.method_37908().method_8406(ELDRITCH_PARTICLE, x, y, z, 0.0, 0.04, 0.0);
                if (i % 4 != 0) continue;
                double offset = Math.sin((double)this.field_6012 * 0.3 + (double)i * 0.5) * 0.3;
                this.method_37908().method_8406(COSMIC_PARTICLE, x + offset, y, z + offset, 0.0, 0.03, 0.0);
            }
        }
        if (this.method_37908() != null && !this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805() || !target.method_5805()) {
                    return;
                }
                float sanityDamage = 20.0f + 30.0f * (1.0f - target.method_6032() / target.method_6063());
                if (this.isVoidRage) {
                    sanityDamage *= 1.8f;
                }
                target.method_5643(this.method_48923().method_48831(), sanityDamage);
                this.method_6025(sanityDamage * 0.4f);
                if (target.method_6032() / target.method_6063() < 0.4f) {
                    target.method_6092(new class_1293(class_1294.field_5916, 150, 1, true, false, false));
                    target.method_6092(new class_1293(class_1294.field_5919, 120, 0, true, false, false));
                    this.method_6092(new class_1293(class_1294.field_5910, 180, 2, true, false, false));
                }
                serverWorld.method_14199(ELDRITCH_PARTICLE, target.method_23317(), target.method_23318() + 1.5, target.method_23321(), 20, 0.5, 0.6, 0.5, 0.2);
            });
        }
        this.method_37908().method_8503().execute(() -> {
            if (this.method_5805()) {
                this.endSkillAnimation();
            }
        });
    }

    public boolean isVoidRage() {
        return this.isVoidRage;
    }

    public void performRitualOfTheDeep() {
        class_1937 class_19372;
        this.triggerSkillAnimation(5, 60);
        this.method_5783(RITUAL_SOUND, 2.5f, 0.2f);
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 360; i += 10) {
                double rad = Math.toRadians(i);
                double radius = 3.0 + Math.sin((double)this.field_6012 * 0.1) * 0.5;
                this.method_37908().method_8406(RITUAL_PARTICLE, this.method_23317() + Math.cos(rad) * radius, this.method_23318() + 0.1, this.method_23321() + Math.sin(rad) * radius, Math.cos(rad) * 0.08, 0.12, Math.sin(rad) * 0.08);
                if (i % 30 != 0) continue;
                this.method_37908().method_8406(ELDRITCH_PARTICLE, this.method_23317() + Math.cos(rad) * (radius + 1.0), this.method_23318() + 0.2, this.method_23321() + Math.sin(rad) * (radius + 1.0), 0.0, 0.15, 0.0);
            }
            this.method_37908().method_8503().execute(() -> {
                if (this.method_5805()) {
                    this.endSkillAnimation();
                }
            });
        }
        if (this.method_37908() != null && !this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805()) {
                    return;
                }
                float healAmount = this.method_6063() * 0.5f;
                this.method_6025(healAmount);
                this.method_6092(new class_1293(class_1294.field_5924, 250, 3, true, false, false));
                this.method_6092(new class_1293(class_1294.field_5910, 250, 2, true, false, false));
                this.method_6092(new class_1293(class_1294.field_5907, 250, 2, true, false, false));
                double radius = 6.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805() && e instanceof class_1657)) {
                    entity.method_5643(this.method_48923().method_48831(), 25.0f);
                    entity.method_6092(new class_1293(class_1294.field_5920, 150, 2, true, false, false));
                    entity.method_6092(new class_1293(class_1294.field_5902, 80, 0, true, false, false));
                }
                for (int i = 0; i < 80; ++i) {
                    serverWorld.method_14199(RITUAL_PARTICLE, this.method_23317(), this.method_23318() + 2.5, this.method_23321(), 4, 1.2, 0.8, 1.2, 0.3);
                    serverWorld.method_14199(COSMIC_PARTICLE, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 3, 0.8, 0.6, 0.8, 0.2);
                }
                this.method_5783(class_3417.field_14671, 2.0f, 0.4f);
            });
        }
    }

    private void spawnTentacleParticles() {
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 3; ++i) {
                double angle = this.field_5974.method_43058() * Math.PI * 2.0;
                double length = 2.0 + this.field_5974.method_43058() * 3.0;
                double swing = Math.sin((double)this.field_6012 * 0.2 + (double)i) * 0.5;
                for (int j = 0; j < 5; ++j) {
                    double progress = (double)j / 5.0;
                    double x = Math.cos(angle + swing) * length * progress;
                    double z = Math.sin(angle + swing) * length * progress;
                    this.method_37908().method_8406(TENTACLE_PARTICLE, this.method_23317() + x, this.method_23318() + 0.5, this.method_23321() + z, 0.0, 0.02, 0.0);
                }
            }
        }
    }

    private void spawnVoidRageParticles() {
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 8; ++i) {
                this.spawnParticle(VOID_PARTICLE, 1.5, 1.8, 1.5, 0.12);
                this.spawnParticle(ELDRITCH_PARTICLE, 1.8, 1.5, 1.8, 0.1);
            }
            if (this.field_6012 % 8 == 0) {
                this.spawnTentacleParticles();
            }
            if (this.field_6012 % 5 == 0) {
                double radius = 2.0 + Math.sin((double)this.field_6012 * 0.15) * 0.3;
                for (int i = 0; i < 24; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / 24.0 + (double)this.field_6012 * 0.08;
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    this.method_37908().method_8406(RITUAL_PARTICLE, this.method_23317() + x, this.method_23318() + 0.1, this.method_23321() + z, -Math.cos(angle) * 0.1, 0.15, -Math.sin(angle) * 0.1);
                }
            }
        }
    }

    private void spawnParticle(class_2394 type, double width, double height, double depth, double speed) {
        if (this.method_37908() != null && this.method_37908().field_9236) {
            this.method_37908().method_8406(type, this.method_23317() + (this.field_5974.method_43058() - 0.5) * width, this.method_23318() + this.field_5974.method_43058() * height, this.method_23321() + (this.field_5974.method_43058() - 0.5) * depth, (this.field_5974.method_43058() - 0.5) * speed, this.field_5974.method_43058() * speed * 0.5, (this.field_5974.method_43058() - 0.5) * speed);
        }
    }

    public void triggerVoidRage() {
        if (this.isVoidRage) {
            return;
        }
        this.isVoidRage = true;
        this.voidRageDuration = 400;
        this.voidRageThreshold = (int)((double)this.method_6063() * 0.2);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_1657 player : serverWorld.method_18456()) {
                if (!(player.method_5858((class_1297)this) < 256.0)) continue;
                player.method_7353((class_2561)class_2561.method_43470((String)"\u865a\u7a7a\u89c9\u9192\uff01").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), true);
                player.method_5783(class_3417.field_14671, 2.5f, 0.5f);
            }
        }
        if (this.method_37908() != null) {
            for (int i = 0; i < 100; ++i) {
                this.spawnParticle(VOID_PARTICLE, 3.0, 3.0, 3.0, 0.4);
                this.spawnParticle(ELDRITCH_PARTICLE, 2.5, 2.5, 2.5, 0.3);
            }
            this.method_5783(class_3417.field_14671, 4.5f, 0.3f);
            this.method_5783(class_3417.field_38830, 3.0f, 0.6f);
        }
        this.method_5996(class_5134.field_23721).method_6192(45.0);
        this.method_5996(class_5134.field_23719).method_6192(1.1);
        this.method_5996(class_5134.field_23724).method_6192(28.0);
        this.method_6092(new class_1293(class_1294.field_5910, 400, 3, true, false, false));
        this.method_6092(new class_1293(class_1294.field_5907, 400, 2, true, false, false));
        this.voidNovaCooldown = 0;
        this.tentacleLashCooldown = 0;
        if (!this.method_37908().method_8608()) {
            this.voidRageExplosion();
        }
    }

    private void endVoidRage() {
        this.isVoidRage = false;
        this.voidRageDuration = 0;
        this.method_5996(class_5134.field_23721).method_6192(28.0);
        this.method_5996(class_5134.field_23719).method_6192(0.75);
        this.method_5996(class_5134.field_23724).method_6192(20.0);
        this.method_6016(class_1294.field_5910);
        this.method_6016(class_1294.field_5907);
        if (this.method_37908() != null) {
            for (int i = 0; i < 50; ++i) {
                this.spawnParticle(VOID_PARTICLE, 2.5, 2.5, 2.5, 0.15);
                this.spawnParticle(COSMIC_PARTICLE, 2.0, 2.0, 2.0, 0.1);
            }
            this.method_5783(class_3417.field_14879, 2.5f, 0.8f);
        }
    }

    private void voidRageSkill() {
        int skill = this.field_5974.method_43048(4);
        switch (skill) {
            case 0: {
                this.voidRageNova();
                break;
            }
            case 1: {
                this.voidRageTentacles();
                break;
            }
            case 2: {
                this.voidRageTeleport();
                break;
            }
            case 3: {
                this.voidRageVortex();
            }
        }
    }

    public void voidRageNova() {
        this.method_5783(VOID_NOVA_CHARGE, 3.0f, 0.1f);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199(VOID_PARTICLE, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 80, 3.5, 3.5, 3.5, 0.4);
            serverWorld.method_8503().execute(() -> {
                double radius = 15.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805())) {
                    entity.method_5643(this.method_48923().method_48831(), 80.0f);
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = entity;
                    living.method_6092(new class_1293(class_1294.field_5920, 300, 3, true, false, false));
                    living.method_6092(new class_1293(class_1294.field_5919, 250, 1, true, false, false));
                    living.method_6092(new class_1293(class_1294.field_5909, 250, 4, true, false, false));
                }
                this.method_5783(VOID_NOVA_EXPLODE, 4.0f, 0.1f);
            });
        }
    }

    public void voidRageTentacles() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                for (int i = 0; i < 5 && target.method_5805(); ++i) {
                    float damage = 35.0f;
                    target.method_5643(this.method_48923().method_48812((class_1309)this), damage);
                    this.method_6025(damage * 0.4f);
                    serverWorld.method_14199(TENTACLE_PARTICLE, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 15, 0.7, 0.8, 0.7, 0.2);
                    try {
                        Thread.sleep(150L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.method_5783(TENTACLE_LASH_SOUND, 2.5f, 0.3f);
            });
        }
    }

    public void voidRageTeleport() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            double angle = this.field_5974.method_43058() * Math.PI * 2.0;
            double distance = 1.5 + this.field_5974.method_43058() * 4.0;
            double x = target.method_23317() + Math.cos(angle) * distance;
            double z = target.method_23321() + Math.sin(angle) * distance;
            this.method_5859(x, target.method_23318(), z);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14199(RITUAL_PARTICLE, x, target.method_23318() + 1.0, z, 20, 0.5, 0.6, 0.5, 0.3);
            }
            this.method_5783(class_3417.field_14879, 2.0f, 0.4f);
            if (i % 2 == 0) {
                this.tentacleLashAttack(target);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void voidRageVortex() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805()) {
                    return;
                }
                double radius = 12.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805())) {
                    class_243 pullDirection = this.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(3.0 + this.field_5974.method_43058() * 2.0);
                    entity.method_5762(pullDirection.field_1352, 0.8 + this.field_5974.method_43058(), pullDirection.field_1350);
                    entity.method_5643(this.method_48923().method_48831(), 50.0f);
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = entity;
                    living.method_6092(new class_1293(class_1294.field_5916, 200, 2, true, false, false));
                    living.method_6092(new class_1293(class_1294.field_38092, 180, 0, true, false, false));
                }
                for (int i = 0; i < 100; ++i) {
                    double angle = Math.toRadians((double)i * 3.6);
                    double dist = radius * (0.5 + this.field_5974.method_43058() * 0.5);
                    serverWorld.method_14199(RITUAL_PARTICLE, this.method_23317() + Math.cos(angle) * dist, this.method_23318() + 1.0, this.method_23321() + Math.sin(angle) * dist, 2, 0.0, 0.2, 0.0, 0.1);
                }
                this.method_5783(class_3417.field_14550, 3.5f, 0.4f);
            });
        }
    }

    public void castVoidGaze() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        this.triggerSkillAnimation(6, 60);
        this.method_5783(VOID_GAZE_CHARGE, 3.0f, 0.2f);
        this.method_18799(class_243.field_1353);
        this.method_5942().method_6340();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                try {
                    this.voidGazeAscendPhase(target, serverWorld);
                    Thread.sleep(1000L);
                    if (this.method_5805() && target.method_5805()) {
                        this.voidGazeBeamPhase(target, serverWorld);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (this.method_5805()) {
                        this.endSkillAnimation();
                    }
                }
            });
        }
    }

    private void voidGazeAscendPhase(class_1309 target, class_3218 world) {
        double startY = this.method_23318();
        double targetY = startY + 8.0;
        world.method_8503().execute(() -> {
            for (int tick = 0; tick < 20; ++tick) {
                if (!this.method_5805()) {
                    return;
                }
                float progress = (float)((double)tick / 20.0);
                double currentY = startY + (targetY - startY) * (double)progress;
                this.method_5859(this.method_23317(), currentY, this.method_23321());
                this.spawnEnderDragonBeam(world, progress);
                this.method_5951((class_1297)target, 180.0f, 180.0f);
                this.spawnVoidGazeChargeParticles(world, progress);
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
    }

    private void voidGazeBeamPhase(class_1309 target, class_3218 world) {
        this.method_5783(VOID_GAZE_SHOOT, 4.0f, 0.3f);
        world.method_8503().execute(() -> {
            for (int tick = 0; tick < 40; ++tick) {
                if (!this.method_5805() || !target.method_5805()) {
                    return;
                }
                this.method_5951((class_1297)target, 180.0f, 180.0f);
                this.shootVoidBeam(target, world, tick);
                if (tick % 5 == 0) {
                    this.applyVoidBeamDamage(target, world);
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.voidGazeEndEffect(world);
        });
    }

    private void spawnEnderDragonBeam(class_3218 world, float progress) {
        int beamHeight = 30;
        float beamWidth = 1.5f + progress * 2.0f;
        for (int i = 0; i < beamHeight; ++i) {
            double y = this.method_23318() + (double)i * 0.5;
            world.method_14199((class_2394)class_2398.field_11216, this.method_23317(), y, this.method_23321(), 8, (double)beamWidth, 0.1, (double)beamWidth, 0.1);
            if (i % 3 == 0) {
                for (int j = 0; j < 12; ++j) {
                    double angle = (double)j * Math.PI * 2.0 / 12.0;
                    double radius = (double)beamWidth * 1.2;
                    world.method_14199((class_2394)class_2398.field_23190, this.method_23317() + Math.cos(angle) * radius, y, this.method_23321() + Math.sin(angle) * radius, 3, 0.0, 0.0, 0.0, 0.05);
                }
            }
            if (!(progress > 0.5f) || i % 5 != 0) continue;
            world.method_14199((class_2394)class_2398.field_29644, this.method_23317(), y, this.method_23321(), 5, (double)beamWidth * 0.8, 0.2, (double)beamWidth * 0.8, 0.15);
        }
    }

    private void spawnVoidGazeChargeParticles(class_3218 world, float progress) {
        int particleCount = (int)(50.0f * progress);
        for (int i = 0; i < particleCount; ++i) {
            double angle = world.method_8409().method_43058() * Math.PI * 2.0;
            double radius = 2.0 + (double)progress * 3.0;
            double yOffset = world.method_8409().method_43058() * 3.0;
            world.method_14199((class_2394)class_2398.field_11214, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + yOffset, this.method_23321() + Math.sin(angle) * radius, 2, 0.1, 0.1, 0.1, 0.2);
            if (!(world.method_8409().method_43057() < 0.3f)) continue;
            world.method_14199((class_2394)class_2398.field_29644, this.method_23317() + (world.method_8409().method_43058() - 0.5) * 2.0, this.method_23318() + world.method_8409().method_43058() * 4.0, this.method_23321() + (world.method_8409().method_43058() - 0.5) * 2.0, 1, 0.0, 0.1, 0.0, 0.05);
        }
        if (progress > 0.3f) {
            int rings = 3;
            for (int r = 0; r < rings; ++r) {
                int segments = 24;
                double ringRadius = 1.0 + (double)r * 1.5;
                double ringHeight = 1.0 + (double)r * 0.8;
                double rotation = (double)this.field_6012 * 0.1 + (double)r * 0.5;
                for (int i = 0; i < segments; ++i) {
                    double angle = (double)i * (Math.PI * 2 / (double)segments) + rotation;
                    world.method_14199((class_2394)class_2398.field_22246, this.method_23317() + Math.cos(angle) * ringRadius, this.method_23318() + ringHeight, this.method_23321() + Math.sin(angle) * ringRadius, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        }
    }

    private void shootVoidBeam(class_1309 target, class_3218 world, int tick) {
        double startX = this.method_23317();
        double startY = this.method_23318() + 2.0;
        double startZ = this.method_23321();
        double targetX = target.method_23317();
        double targetY = target.method_23320();
        double targetZ = target.method_23321();
        double dx = targetX - startX;
        double dy = targetY - startY;
        double dz = targetZ - startZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        int segments = (int)(distance * 2.0);
        for (int i = 0; i < segments; ++i) {
            double progress = (double)i / (double)segments;
            double x = startX + dx * progress;
            double y = startY + dy * progress;
            double z = startZ + dz * progress;
            world.method_14199((class_2394)class_2398.field_11214, x, y, z, 2, 0.1, 0.1, 0.1, 0.05);
            world.method_14199((class_2394)class_2398.field_29644, x, y, z, 1, 0.05, 0.05, 0.05, 0.03);
            world.method_14199((class_2394)class_2398.field_23190, x, y, z, 1, 0.08, 0.08, 0.08, 0.02);
            if (tick % 4 != 0) continue;
            for (int j = 0; j < 3; ++j) {
                double offsetAngle = world.method_8409().method_43058() * Math.PI * 2.0;
                double offsetDist = 0.3 + world.method_8409().method_43058() * 0.4;
                world.method_14199((class_2394)class_2398.field_22246, x + Math.cos(offsetAngle) * offsetDist, y, z + Math.sin(offsetAngle) * offsetDist, 1, 0.0, 0.02, 0.0, 0.01);
            }
        }
        if (tick % 2 == 0) {
            world.method_14199((class_2394)class_2398.field_11216, targetX, targetY, targetZ, 10, 0.5, 0.5, 0.5, 0.2);
            world.method_14199((class_2394)class_2398.field_29644, targetX, targetY, targetZ, 8, 0.3, 0.3, 0.3, 0.15);
            world.method_14199((class_2394)class_2398.field_22246, targetX, targetY, targetZ, 5, 0.4, 0.4, 0.4, 0.1);
            world.method_14199((class_2394)class_2398.field_38002, targetX, targetY, targetZ, 6, 0.3, 0.3, 0.3, 0.08);
        }
    }

    public int getRecentInhibitionCount() {
        return this.recentInhibitionCount;
    }

    private void applyVoidBeamDamage(class_1309 target, class_3218 world) {
        if (target.method_5739((class_1297)this) > 25.0f) {
            return;
        }
        float damage = this.isVoidRage ? 12.0f : 8.0f;
        target.method_5643(this.method_48923().method_48831(), damage);
        target.method_6092(new class_1293(class_1294.field_5909, 40, 2, false, false));
        target.method_6092(new class_1293(class_1294.field_5919, 30, 0, false, false));
        class_243 knockback = target.method_19538().method_1020(this.method_19538()).method_1029().method_1021(0.5);
        target.method_5762(knockback.field_1352, 0.3, knockback.field_1350);
        world.method_14199((class_2394)class_2398.field_38002, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 15, 0.3, 0.5, 0.3, 0.1);
    }

    private void voidGazeEndEffect(class_3218 world) {
        for (int i = 0; i < 30; ++i) {
            world.method_14199((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 3, 1.0, 1.0, 1.0, 0.3);
        }
        double currentY = this.method_23318();
        for (int tick = 0; tick < 10 && this.method_5805(); ++tick) {
            double progress = (double)tick / 10.0;
            double newY = currentY - (currentY - (this.method_23318() - 8.0)) * progress;
            this.method_5859(this.method_23317(), newY, this.method_23321());
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.method_5783(class_3417.field_14879, 2.0f, 0.5f);
    }

    public void voidRageExplosion() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8503().execute(() -> {
                if (!this.method_5805()) {
                    return;
                }
                double radius = 12.0;
                for (class_1309 entity : serverWorld.method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805())) {
                    class_243 knockback = entity.method_19538().method_1020(this.method_19538()).method_1029().method_1021(6.0 + this.field_5974.method_43058() * 3.0);
                    entity.method_5762(knockback.field_1352, 1.5 + this.field_5974.method_43058(), knockback.field_1350);
                    entity.method_5643(this.method_48923().method_48831(), 60.0f);
                    entity.method_5639(10.0f);
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = entity;
                    living.method_6092(new class_1293(class_1294.field_5920, 300, 3, true, false, false));
                    living.method_6092(new class_1293(class_1294.field_5919, 250, 1, true, false, false));
                }
                for (int i = 0; i < 120; ++i) {
                    serverWorld.method_14199(VOID_PARTICLE, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 2, (this.field_5974.method_43058() - 0.5) * 3.0, 0.8, (this.field_5974.method_43058() - 0.5) * 3.0, 0.4);
                    if (i % 3 != 0) continue;
                    serverWorld.method_14199(COSMIC_PARTICLE, this.method_23317(), this.method_23318() + 1.2, this.method_23321(), 1, (this.field_5974.method_43058() - 0.5) * 2.5, 0.6, (this.field_5974.method_43058() - 0.5) * 2.5, 0.3);
                }
                this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15152, 5.0f, 0.4f);
                this.method_5783(class_3417.field_14671, 4.0f, 0.3f);
            });
        }
    }

    private void playSound(class_6880.class_6883<class_3414> entityGenericExplode, float volume, float pitch) {
        if (!this.method_5701()) {
            this.method_37908().method_60511((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), entityGenericExplode, this.method_5634(), volume, pitch);
        }
    }

    private void spawnDeathVoidBeam(class_3218 world, float progress) {
        int beamHeight = 30 + (int)(progress * 20.0f);
        for (int i = 0; i < beamHeight; ++i) {
            double y = this.method_23318() + (double)i * 0.25;
            world.method_14199(VOID_PARTICLE, this.method_23317(), y, this.method_23321(), 6, 0.4, 0.0, 0.4, 0.1);
            if (i % 3 != 0) continue;
            for (int j = 0; j < 16; ++j) {
                double angle = (double)j * Math.PI * 2.0 / 16.0;
                double radius = 1.0 + (double)progress * 3.0;
                world.method_14199(COSMIC_PARTICLE, this.method_23317() + Math.cos(angle) * radius, y, this.method_23321() + Math.sin(angle) * radius, 3, 0.0, 0.0, 0.0, 0.2);
            }
        }
        if ((double)progress < 0.7) {
            int segments = 48;
            double innerRadius = 2.0 + (double)progress * 5.0;
            double outerRadius = 3.0 + (double)progress * 6.0;
            for (int i = 0; i < segments; ++i) {
                double angle = (double)i * (Math.PI * 2 / (double)segments) + (double)(progress * 15.0f);
                world.method_14199(VOID_PARTICLE, this.method_23317() + Math.cos(angle) * innerRadius, this.method_23318() + 0.1, this.method_23321() + Math.sin(angle) * innerRadius, 2, 0.0, 0.1, 0.0, 0.05);
                if (i % 6 != 0) continue;
                world.method_14199(ELDRITCH_PARTICLE, this.method_23317() + Math.cos(angle) * outerRadius, this.method_23318() + 0.2, this.method_23321() + Math.sin(angle) * outerRadius, 3, 0.0, 0.3, 0.0, 0.1);
            }
        }
    }

    private void spawnVoidEnergyRings(class_3218 world, float progress) {
        int rings = 5;
        for (int r = 0; r < rings; ++r) {
            int segments = 24;
            double radius = 1.5 + (double)r * 2.0;
            double yOffset = 1.0 + (double)r * 0.8 + (double)progress * 4.0;
            double rotationSpeed = 0.1 + (double)r * 0.04;
            for (int i = 0; i < segments; ++i) {
                double angle = (double)i * (Math.PI * 2 / (double)segments) + (double)this.field_6012 * rotationSpeed;
                world.method_14199(RITUAL_PARTICLE, this.method_23317() + Math.cos(angle) * radius, this.method_23318() + yOffset, this.method_23321() + Math.sin(angle) * radius, 3, 0.0, 0.0, 0.0, 0.15);
            }
        }
    }

    private void spawnBodyVoidDissolveParticles(class_3218 world, float progress) {
        int i;
        int particleCount = (int)(60.0 * (1.0 - (double)progress));
        for (i = 0; i < particleCount; ++i) {
            world.method_14199(VOID_PARTICLE, this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0, this.method_23318() + this.field_5974.method_43058() * 3.5, this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0, 3, 0.0, 0.0, 0.0, 0.2);
            if (!(this.field_5974.method_43057() < 0.5f)) continue;
            class_2394 type = this.field_5974.method_43056() ? COSMIC_PARTICLE : ELDRITCH_PARTICLE;
            world.method_14199(type, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), 4, (this.field_5974.method_43058() - 0.5) * 1.0, 0.8, (this.field_5974.method_43058() - 0.5) * 1.0, 0.3);
        }
        if ((double)progress > 0.8) {
            for (i = 0; i < 20; ++i) {
                world.method_14199((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 2, (this.field_5974.method_43058() - 0.5) * 1.5, 0.7, (this.field_5974.method_43058() - 0.5) * 1.5, 0.8);
            }
        }
    }

    public void startDeathAnimation() {
        this.isDying = true;
        this.deathAnimationTicks = 120;
        this.deathStartPos = this.method_19538();
        this.method_18799(class_243.field_1353);
        this.method_5875(true);
        this.method_5684(true);
        this.method_5783(DEATH_CHARGE, 3.0f, 0.3f);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 30; ++i) {
                serverWorld.method_14199(VOID_PARTICLE, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.5, 0.5, 0.5, 0.2);
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.isVoidRage && this.method_6032() - amount < (float)this.voidRageThreshold) {
            if (this.field_5974.method_43057() < 0.4f) {
                this.triggerVoidRage();
            } else {
                this.voidRageThreshold = (int)((double)this.method_6063() * 0.12);
            }
        }
        if (this.method_37908() != null && this.method_37908().field_9236) {
            for (int i = 0; i < 15; ++i) {
                this.spawnParticle(VOID_PARTICLE, 1.2, 1.8, 1.2, 0.25);
                this.spawnParticle(COSMIC_PARTICLE, 0.8, 1.5, 0.8, 0.15);
            }
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(class_1282 damageSource) {
    }

    public boolean method_29504() {
        return super.method_29504() || this.isDying;
    }

    public class VoidTeleportGoal
    extends class_1352 {
        private final HematicSerenityEntity entity;
        private final double teleportChance;

        public VoidTeleportGoal(HematicSerenityEntity this$0, HematicSerenityEntity entity) {
            this.entity = entity;
            this.teleportChance = 0.4;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 target = this.entity.method_5968();
            return target != null && this.entity.method_5739((class_1297)target) > 6.0f && (double)this.entity.field_5974.method_43057() < this.teleportChance;
        }

        public void method_6269() {
            int i;
            class_1309 target = this.entity.method_5968();
            if (target == null) {
                return;
            }
            double angle = this.entity.field_5974.method_43058() * Math.PI * 2.0;
            double distance = 3.0 + this.entity.field_5974.method_43058() * 4.0;
            double x = target.method_23317() + Math.cos(angle) * distance;
            double z = target.method_23321() + Math.sin(angle) * distance;
            class_2338 pos = new class_2338((int)x, (int)target.method_23318(), (int)z);
            while (!this.entity.method_37908().method_8320(pos).method_26215() && pos.method_10264() < 255) {
                pos = pos.method_10084();
            }
            if (this.entity.method_37908() != null) {
                for (i = 0; i < 20; ++i) {
                    this.entity.method_37908().method_8406(VOID_PARTICLE, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), (this.entity.field_5974.method_43058() - 0.5) * 0.4, 0.2, (this.entity.field_5974.method_43058() - 0.5) * 0.4);
                }
            }
            this.entity.method_5859(pos.method_10263(), pos.method_10264(), pos.method_10260());
            this.entity.method_5783(class_3417.field_14879, 1.5f, 0.3f);
            if (this.entity.method_37908() != null) {
                for (i = 0; i < 20; ++i) {
                    this.entity.method_37908().method_8406(COSMIC_PARTICLE, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (this.entity.field_5974.method_43058() - 0.5) * 0.4, 0.2, (this.entity.field_5974.method_43058() - 0.5) * 0.4);
                }
            }
            this.entity.method_5951((class_1297)target, 180.0f, 180.0f);
        }
    }

    public class VoidRageGoal
    extends class_1352 {
        private final HematicSerenityEntity entity;

        public VoidRageGoal(HematicSerenityEntity this$0, HematicSerenityEntity entity) {
            this.entity = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.entity.isVoidRage;
        }

        public void method_6269() {
            this.entity.method_5996(class_5134.field_23719).method_6192(1.1);
        }

        public void method_6270() {
            this.entity.method_5996(class_5134.field_23719).method_6192(0.75);
        }

        public void method_6268() {
            super.method_6268();
            class_1309 target = this.entity.method_5968();
            if (target == null || !target.method_5805()) {
                return;
            }
            double dx = target.method_23317() - this.entity.method_23317();
            double dz = target.method_23321() - this.entity.method_23321();
            class_243 direction = new class_243(dx, 0.0, dz).method_1029();
            this.entity.method_18800(direction.field_1352 * 0.8, this.entity.method_18798().field_1351, direction.field_1350 * 0.8);
            this.entity.method_5988().method_6226((class_1297)target, 180.0f, 180.0f);
            if (this.entity.field_6012 % 2 == 0) {
                this.entity.spawnParticle(VOID_PARTICLE, 1.2, 0.4, 1.2, 0.15);
                this.entity.spawnParticle(COSMIC_PARTICLE, 0.8, 0.3, 0.8, 0.1);
            }
        }
    }
}

