/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import s22.new_mod.recipe.IngredientWithCount;
import s22.new_mod.recipe.ShadowAltarRecipeInput;
import s22.new_mod.serializer.ModRecipeSerializers;
import s22.new_mod.type.ModRecipeTypes;

public class ShadowAltarRecipe
implements class_1860<ShadowAltarRecipeInput> {
    private final class_2960 id;
    private final List<IngredientWithCount> ingredients;
    private final class_1799 output;
    private final int ritualTime;
    private final String ritualEffect;

    public ShadowAltarRecipe(class_2960 id, List<IngredientWithCount> ingredients, class_1799 output, int ritualTime, String ritualEffect) {
        this.id = id;
        this.ingredients = new ArrayList<IngredientWithCount>(ingredients);
        this.output = output;
        this.ritualTime = ritualTime;
        this.ritualEffect = ritualEffect;
    }

    public boolean matches(ShadowAltarRecipeInput input, class_1937 world) {
        if (world.method_8608()) {
            return false;
        }
        ArrayList<IngredientWithCount> remainingRequirements = new ArrayList<IngredientWithCount>();
        for (IngredientWithCount requirement : this.ingredients) {
            remainingRequirements.add(new IngredientWithCount(requirement.ingredient(), requirement.count()));
        }
        class_2371<class_1799> inputStacks = input.getStacks();
        block1: for (class_1799 inputStack : inputStacks) {
            if (inputStack.method_7960()) continue;
            for (int i = 0; i < remainingRequirements.size(); ++i) {
                int requiredCount;
                IngredientWithCount requirement = (IngredientWithCount)remainingRequirements.get(i);
                if (!requirement.testPartial(inputStack)) continue;
                int availableCount = inputStack.method_7947();
                if (availableCount >= (requiredCount = requirement.count())) {
                    remainingRequirements.remove(i);
                    continue block1;
                }
                int remainingCount = requiredCount - availableCount;
                remainingRequirements.set(i, new IngredientWithCount(requirement.ingredient(), remainingCount));
                continue block1;
            }
        }
        return remainingRequirements.isEmpty();
    }

    public class_1799 craft(ShadowAltarRecipeInput input, class_7225.class_7874 lookup) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width >= 5 && height >= 5;
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.output.method_7972();
    }

    public class_1799 getOutput() {
        return this.output.method_7972();
    }

    public class_2371<class_1856> method_8117() {
        class_2371 list = class_2371.method_10211();
        for (IngredientWithCount ingredientWithCount : this.ingredients) {
            list.add((Object)ingredientWithCount.ingredient());
        }
        return list;
    }

    public List<IngredientWithCount> getIngredientsWithCount() {
        return new ArrayList<IngredientWithCount>(this.ingredients);
    }

    public int getRitualTime() {
        return this.ritualTime;
    }

    public String getRitualEffect() {
        return this.ritualEffect;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.SHADOW_ALTAR;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.SHADOW_ALTAR;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShadowAltarRecipe that = (ShadowAltarRecipe)obj;
        return this.ritualTime == that.ritualTime && Objects.equals(this.id, that.id) && Objects.equals(this.ingredients, that.ingredients) && Objects.equals(this.output, that.output) && Objects.equals(this.ritualEffect, that.ritualEffect);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ingredients, this.output, this.ritualTime, this.ritualEffect);
    }

    public String toString() {
        return "ShadowAltarRecipe{id=" + String.valueOf(this.id) + ", ingredients=" + String.valueOf(this.ingredients) + ", output=" + String.valueOf(this.output) + ", ritualTime=" + this.ritualTime + ", ritualEffect='" + this.ritualEffect + "'}";
    }

    public static class Serializer
    implements class_1865<ShadowAltarRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final String ID = "shadow_altar";
        public static final MapCodec<ShadowAltarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("ritual_time").orElse((Object)100).forGetter(ShadowAltarRecipe::getRitualTime), (App)Codec.STRING.fieldOf("ritual_effect").orElse((Object)"shadow_pulse").forGetter(ShadowAltarRecipe::getRitualEffect), (App)IngredientWithCount.CODEC.listOf().fieldOf("ingredients").forGetter(ShadowAltarRecipe::getIngredientsWithCount), (App)class_1799.field_51397.fieldOf("output").forGetter(recipe -> recipe.output)).apply((Applicative)instance, (ritualTime, ritualEffect, ingredients, output) -> new ShadowAltarRecipe(class_2960.method_60654((String)ID), (List<IngredientWithCount>)ingredients, (class_1799)output, (int)ritualTime, (String)ritualEffect)));
        public static final class_9139<class_9129, ShadowAltarRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private static ShadowAltarRecipe read(class_9129 buf) {
            int ritualTime = buf.method_10816();
            String ritualEffect = buf.method_19772();
            int ingredientCount = buf.method_10816();
            ArrayList<IngredientWithCount> ingredients = new ArrayList<IngredientWithCount>();
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add(IngredientWithCount.readFromBuf(buf));
            }
            class_1799 output = (class_1799)class_1799.field_48349.decode((Object)buf);
            return new ShadowAltarRecipe(class_2960.method_60654((String)ID), ingredients, output, ritualTime, ritualEffect);
        }

        private static void write(class_9129 buf, ShadowAltarRecipe recipe) {
            buf.method_10804(recipe.ritualTime);
            buf.method_10814(recipe.ritualEffect);
            buf.method_10804(recipe.ingredients.size());
            for (IngredientWithCount ingredient : recipe.ingredients) {
                IngredientWithCount.writeToBuf(buf, ingredient);
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.output);
        }

        public MapCodec<ShadowAltarRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ShadowAltarRecipe> method_56104() {
            return PACKET_CODEC;
        }

        @Deprecated
        public ShadowAltarRecipe read(class_2960 id, class_2540 buf) {
            return Serializer.read((class_9129)buf);
        }

        @Deprecated
        public void write(class_2540 buf, ShadowAltarRecipe recipe) {
            Serializer.write((class_9129)buf, recipe);
        }

        public String toString() {
            return "ShadowAltarRecipe.Serializer";
        }
    }
}

