/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import s22.new_mod.recipe.IngredientWithCount;
import s22.new_mod.recipe.ShadowAltarRecipe;

public class ShadowAltarRecipeSerializer
implements class_1865<ShadowAltarRecipe> {
    public static final ShadowAltarRecipeSerializer INSTANCE = new ShadowAltarRecipeSerializer();
    public static final String ID = "shadow_altar";
    private static final Codec<IngredientWithCount> INGREDIENT_WITH_COUNT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1856.field_46096.fieldOf("ingredient").forGetter(IngredientWithCount::ingredient), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(IngredientWithCount::count)).apply((Applicative)instance, IngredientWithCount::new));
    private static final MapCodec<ShadowAltarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("ritual_time").orElse((Object)100).forGetter(ShadowAltarRecipe::getRitualTime), (App)Codec.STRING.fieldOf("ritual_effect").orElse((Object)"shadow_pulse").forGetter(ShadowAltarRecipe::getRitualEffect), (App)INGREDIENT_WITH_COUNT_CODEC.listOf().fieldOf("ingredients").forGetter(ShadowAltarRecipe::getIngredientsWithCount), (App)class_1799.field_51397.fieldOf("output").forGetter(recipe -> recipe.getOutput())).apply((Applicative)instance, (ritualTime, ritualEffect, ingredients, output) -> new ShadowAltarRecipe(class_2960.method_60654((String)ID), (List<IngredientWithCount>)ingredients, (class_1799)output, (int)ritualTime, (String)ritualEffect)));
    public static final class_9139<class_9129, ShadowAltarRecipe> PACKET_CODEC = class_9139.method_56437(ShadowAltarRecipeSerializer::write, ShadowAltarRecipeSerializer::read);

    private static ShadowAltarRecipe read(class_9129 buf) {
        int ritualTime = buf.method_10816();
        String ritualEffect = buf.method_19772();
        int ingredientCount = buf.method_10816();
        ArrayList<IngredientWithCount> ingredients = new ArrayList<IngredientWithCount>();
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.add(IngredientWithCount.readFromBuf(buf));
        }
        class_1799 output = (class_1799)class_1799.field_48349.decode((Object)buf);
        return new ShadowAltarRecipe(class_2960.method_60654((String)ID), ingredients, output, ritualTime, ritualEffect);
    }

    private static void write(class_9129 buf, ShadowAltarRecipe recipe) {
        buf.method_10804(recipe.getRitualTime());
        buf.method_10814(recipe.getRitualEffect());
        buf.method_10804(recipe.getIngredientsWithCount().size());
        for (IngredientWithCount ingredient : recipe.getIngredientsWithCount()) {
            IngredientWithCount.writeToBuf(buf, ingredient);
        }
        class_1799.field_48349.encode((Object)buf, (Object)recipe.getOutput());
    }

    public MapCodec<ShadowAltarRecipe> method_53736() {
        return CODEC;
    }

    public class_9139<class_9129, ShadowAltarRecipe> method_56104() {
        return PACKET_CODEC;
    }

    public String toString() {
        return "ShadowAltarRecipeSerializer";
    }
}

