/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.ritual;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import s22.new_mod.entity.ModEntities;
import s22.new_mod.ritual.HematiteSerenityAltarChecker;

public class HematiteSerenityAltarHandler {
    public static void handleAltarActivation(class_1937 world, class_2338 firePos, class_1657 player) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2338 altarBase = firePos.method_10087(2);
        class_243 centerVec = class_243.method_24953((class_2382)altarBase);
        if (!HematiteSerenityAltarChecker.isCompleteAltar(world, altarBase)) {
            return;
        }
        HematiteSerenityAltarHandler.teleportPlayerToSafeLocation(world, player, firePos);
        HematiteSerenityAltarHandler.startSummoningAnimation(serverWorld, altarBase, centerVec);
    }

    private static void teleportPlayerToSafeLocation(class_1937 world, class_1657 player, class_2338 firePos) {
        if (player == null) {
            return;
        }
        class_2350 facing = player.method_5735();
        class_2338 targetPos = firePos.method_10079(facing, 5);
        class_2338 safePos = HematiteSerenityAltarHandler.findSafeGroundPosition(world, targetPos);
        if (safePos != null) {
            player.method_5859((double)safePos.method_10263() + 0.5, (double)safePos.method_10264() + 1.0, (double)safePos.method_10260() + 0.5);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
                world.method_8396(null, safePos, class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    private static class_2338 findSafeGroundPosition(class_1937 world, class_2338 startPos) {
        int i;
        class_2338 currentPos = startPos;
        if (HematiteSerenityAltarHandler.isSafePosition(world, currentPos)) {
            return currentPos;
        }
        for (i = 1; i <= 10; ++i) {
            class_2338 upPos = currentPos.method_10086(i);
            if (!HematiteSerenityAltarHandler.isSafePosition(world, upPos)) continue;
            return upPos;
        }
        for (i = 1; i <= 10; ++i) {
            class_2338 downPos = currentPos.method_10087(i);
            if (!HematiteSerenityAltarHandler.isSafePosition(world, downPos)) continue;
            return downPos;
        }
        return startPos;
    }

    private static boolean isSafePosition(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26212((class_1922)world, pos) && world.method_8320(pos.method_10084()).method_26215() && world.method_8320(pos.method_10086(2)).method_26215();
    }

    private static void startSummoningAnimation(class_3218 world, class_2338 altarBase, class_243 centerVec) {
        class_243 center = class_243.method_24955((class_2382)altarBase.method_10084());
        world.method_29199(18000L);
        world.method_27910(0, 6000, true, true);
        world.method_8396(null, altarBase, class_3417.field_14792, class_3419.field_15251, 2.0f, 0.6f);
        world.method_8396(null, altarBase, class_3417.field_14703, class_3419.field_15256, 1.5f, 0.8f);
        HematiteSerenityAltarHandler.spawnSummoningParticles(world, center);
        world.method_8503().execute(() -> world.method_8503().execute(() -> {
            HematiteSerenityAltarHandler.spawnLightningEffect(world, centerVec);
            world.method_8503().execute(() -> {
                HematiteSerenityAltarHandler.summonHematiteSerenity((class_1937)world, center);
                HematiteSerenityAltarHandler.destroyAltar((class_1937)world, altarBase);
                HematiteSerenityAltarHandler.applyPlayerEffects((class_1937)world, center);
            });
        }));
    }

    private static void spawnSummoningParticles(class_3218 world, class_243 center) {
        double z;
        double x;
        double radius;
        double rad;
        int i;
        for (i = 0; i < 360; i += 12) {
            rad = Math.toRadians(i);
            radius = 2.5;
            x = center.field_1352 + radius * Math.cos(rad);
            z = center.field_1350 + radius * Math.sin(rad);
            world.method_14199((class_2394)class_2398.field_22246, x, center.field_1351 + 0.5, z, 2, 0.1, 0.3, 0.1, 0.05);
        }
        for (i = 0; i < 180; i += 10) {
            rad = Math.toRadians(i);
            radius = 1.8;
            x = center.field_1352 + radius * Math.cos(rad);
            z = center.field_1350 + radius * Math.sin(rad);
            world.method_14199((class_2394)class_2398.field_28013, x, center.field_1351 + 1.5, z, 3, 0.15, 0.2, 0.15, 0.02);
        }
        for (i = 0; i < 25; ++i) {
            world.method_14199((class_2394)class_2398.field_29644, center.field_1352, center.field_1351 + (double)i * 0.15, center.field_1350, 4, 0.2, 0.1, 0.2, 0.08);
        }
    }

    private static void spawnLightningEffect(class_3218 world, class_243 centerVec) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
        lightning.method_29495(centerVec);
        lightning.method_29498(true);
        world.method_8649((class_1297)lightning);
        world.method_8396(null, class_2338.method_49638((class_2374)centerVec), class_3417.field_14865, class_3419.field_15252, 3.0f, 0.8f);
    }

    private static void summonHematiteSerenity(class_1937 world, class_243 center) {
        class_1297 hematiteSerenity = ModEntities.HEMATICSERENITY.method_5883(world);
        if (hematiteSerenity != null) {
            hematiteSerenity.method_5808(center.field_1352, center.field_1351 + 1.0, center.field_1350, 0.0f, 0.0f);
            hematiteSerenity.method_5780("ritual_summoned");
            hematiteSerenity.method_5780("fire_immune");
            hematiteSerenity.method_5780("fall_immune");
            world.method_8649(hematiteSerenity);
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_14199((class_2394)class_2398.field_11236, center.field_1352, center.field_1351 + 1.0, center.field_1350, 10, 1.0, 1.0, 1.0, 0.5);
            }
        }
    }

    private static void destroyAltar(class_1937 world, class_2338 base) {
        int y = 0;
        while (y < 3) {
            int currentY = y++;
            world.method_8503().execute(() -> {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 pos = base.method_10069(x, currentY, z);
                        world.method_22352(pos, false);
                        if (!(world instanceof class_3218)) continue;
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)class_2398.field_11203, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3, 0.2, 0.2, 0.2, 0.05);
                    }
                }
            });
        }
    }

    private static void applyPlayerEffects(class_1937 world, class_243 center) {
        world.method_18456().forEach(player -> {
            if (player.method_5707(center) < 400.0) {
                player.method_6092(new class_1293(class_1294.field_5919, 200, 1, false, false));
                player.method_6092(new class_1293(class_1294.field_5909, 100, 1, false, false));
                player.method_6092(new class_1293(class_1294.field_5912, 300, 0, false, false));
            }
        });
    }
}

