/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_642;
import net.minecraft.class_8646;
import net.minecraft.class_9011;

public class SubserverManager {
    public static boolean playerOn90gQopen = false;
    private static Subserver activeSubServer = Subserver.UNKNOWN;
    private static final List<Consumer<Subserver>> listeners = new ArrayList<Consumer<Subserver>>();

    public static void registerListener(Consumer<Subserver> listener) {
        listeners.add(listener);
    }

    public static Subserver getActiveSubServer() {
        return activeSubServer;
    }

    public static void setSubServer(Subserver newSubServer) {
        if (activeSubServer != newSubServer) {
            activeSubServer = newSubServer;
        }
    }

    public static void updateListeners() {
        for (Consumer<Subserver> listener : listeners) {
            listener.accept(activeSubServer);
        }
    }

    public static void detectSubserver(class_310 client) {
        class_642 serverInfo = client.method_1558();
        playerOn90gQopen = serverInfo != null ? serverInfo.field_3761.equalsIgnoreCase("90gqopen.se") : false;
        SubserverManager.setSubServer(Subserver.UNKNOWN);
        if (client.field_1687 == null) {
            SubserverManager.updateListeners();
            return;
        }
        class_269 scoreboard = client.field_1687.method_8428();
        Collection entries = scoreboard.method_1184(scoreboard.method_1189(class_8646.field_45157));
        for (class_9011 entry : entries) {
            String lineContent = class_268.method_1142((class_270)scoreboard.method_1164(entry.comp_2127()), (class_2561)entry.method_55387()).getString();
            if (lineContent.contains("Hub")) {
                SubserverManager.setSubServer(Subserver.HUB);
                continue;
            }
            if (lineContent.contains("Creative")) {
                SubserverManager.setSubServer(Subserver.CREATIVE);
                continue;
            }
            if (lineContent.contains("UHC") || lineContent.contains("Ultra Hardcore")) {
                SubserverManager.setSubServer(Subserver.UHC);
                continue;
            }
            if (lineContent.contains("Parkour")) {
                SubserverManager.setSubServer(Subserver.PARKOUR);
                continue;
            }
            if (lineContent.contains("Event")) {
                SubserverManager.setSubServer(Subserver.EVENT);
                continue;
            }
            if (!lineContent.contains("Survival") || lineContent.contains("Survival Games")) continue;
            boolean found = false;
            for (class_9011 subEntry : entries) {
                String subLineContent = class_268.method_1142((class_270)scoreboard.method_1164(subEntry.comp_2127()), (class_2561)subEntry.method_55387()).getString();
                if (!subLineContent.contains("\u00c4gare")) continue;
                SubserverManager.setSubServer(Subserver.SURVIVAL_PLOT);
                found = true;
                break;
            }
            if (found || client.field_1724 == null) continue;
            SubserverManager.setSubServer(client.field_1724.method_68876() == class_1934.field_9216 ? Subserver.SURVIVAL_SPAWN : Subserver.SURVIVAL_RESOURCE);
        }
        SubserverManager.updateListeners();
    }

    public static enum Subserver {
        UNKNOWN,
        SURVIVAL_SPAWN,
        SURVIVAL_PLOT,
        SURVIVAL_RESOURCE,
        PARKOUR,
        CREATIVE,
        HUB,
        EVENT,
        UHC;

    }
}

