/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import net.minecraft.class_310;

public abstract class Module<T extends ModuleConfig> {
    private final String id;
    public final int priority;
    protected T config;

    public Module(String id, int priority, Class<T> configClass) {
        this.id = id;
        this.priority = priority;
        this.config = this.createDefaultConfig(configClass);
    }

    public String getId() {
        return this.id;
    }

    public abstract void tick(class_310 var1);

    public void applyConfig(Object loaded) {
        if (loaded != null) {
            try {
                Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
                String jsonString = gson.toJson(loaded);
                this.config = (ModuleConfig)gson.fromJson(jsonString, this.getConfigClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getConfigForSaving() {
        return this.config;
    }

    protected abstract Class<T> getConfigClass();

    protected T createDefaultConfig(Class<T> configClass) {
        try {
            return (T)((ModuleConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create default config for module: " + this.id, e);
        }
    }

    public abstract void loadConfig(ConfigCategory.Builder var1);

    public static abstract class ModuleConfig {
        @SerialEntry
        public boolean moduleEnabled = true;
    }
}

