/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats.screen;

import avox.openutils.modules.stats.Formatter;
import avox.openutils.modules.stats.screen.types.StatTabTypes;
import avox.openutils.modules.stats.screen.widgets.navigation.StatCategory;
import avox.openutils.modules.stats.screen.widgets.navigation.StatEntry;
import avox.openutils.modules.stats.screen.widgets.navigation.StatFolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;

public class StatViewer
extends class_4265<Entry> {
    private final class_310 client;
    private final int screenWidth;
    public ArrayList<StatCategory> lastCategories;
    public boolean drawMessage = true;
    public String specialMessage = "";
    private StatTabTypes tabType;

    public StatViewer(StatTabTypes tabType, class_310 client, int width, int height) {
        super(client, width - width / 3 - 10 - 5 - 10, height - 24 - 15 - 10, 34, 20);
        this.client = client;
        this.screenWidth = width;
        this.tabType = tabType;
        this.method_46421(width / 3 + 10 + 5);
    }

    public void updateEntries(ArrayList<StatCategory> categories) {
        this.method_25339();
        if (!categories.isEmpty()) {
            this.drawMessage = false;
        }
        for (StatCategory category : categories) {
            this.method_25321((class_350.class_351)new Entry(null, null, category));
            for (StatEntry statEntry : category.directStats) {
                this.method_25321((class_350.class_351)new Entry(statEntry, null, category));
            }
            for (StatFolder folder : category.folders) {
                this.method_25321((class_350.class_351)new Entry(null, folder, category));
                if (!folder.open) continue;
                for (StatEntry entry : folder.entries) {
                    this.method_25321((class_350.class_351)new Entry(entry, folder, category));
                }
            }
        }
        this.method_65506();
        this.lastCategories = categories;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);
        if (this.drawMessage && !this.specialMessage.isEmpty()) {
            context.method_51440(this.client.field_1772, (class_5348)class_2561.method_30163((String)this.specialMessage), this.screenWidth / 3 + 10 + 5 + 5, this.method_46427() + 5, this.screenWidth - this.screenWidth / 3 - 10 - 5 - 10 - 10, -1, true);
        }
    }

    protected int method_65507() {
        return this.screenWidth / 3 + 10 + 5 + (this.screenWidth - this.screenWidth / 3 - 10 - 5 - 10) - 10;
    }

    public int method_25322() {
        return this.field_22758 - 20;
    }

    public class Entry
    extends class_4265.class_4266<Entry> {
        public class_5250 category;
        public class_5250 key;
        public class_5250 value;
        public StatFolder folder;
        public class_5250 folderName;
        public class_4185 folderBtn;

        public Entry(StatEntry statEntry, StatFolder folder, StatCategory category) {
            String folderName = folder == null ? "" : folder.name;
            String categoryName = category.title;
            if (statEntry != null) {
                this.key = Formatter.formatKey(StatViewer.this.tabType, statEntry.key, categoryName, folderName);
                this.value = Formatter.formatValue(StatViewer.this.tabType, statEntry.value, statEntry.key, category.title, folder == null ? "" : folder.name);
            } else if (folder != null) {
                this.folder = folder;
                this.folderName = Formatter.formatFolder(StatViewer.this.tabType, folder.name, categoryName);
                this.folderBtn = class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> {
                    folder.open = !folder.open;
                    StatViewer.this.updateEntries(StatViewer.this.lastCategories);
                }).method_46434(0, 0, 100, 20).method_46431();
            } else {
                this.category = Formatter.formatCategory(StatViewer.this.tabType, category.title, category.suffix);
            }
        }

        public List<? extends class_6379> method_37025() {
            ArrayList<class_4185> children = new ArrayList<class_4185>();
            if (this.folderBtn != null) {
                children.add(this.folderBtn);
            }
            return children;
        }

        public List<? extends class_364> method_25396() {
            ArrayList<class_4185> children = new ArrayList<class_4185>();
            if (this.folderBtn != null) {
                children.add(this.folderBtn);
            }
            return children;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int n = y + entryHeight / 2;
            Objects.requireNonNull(StatViewer.this.client.field_1772);
            int centerHeight = n - 9 / 2;
            if (this.category != null) {
                context.method_51439(StatViewer.this.client.field_1772, (class_2561)this.category, x - 5, centerHeight, -2304, true);
            } else if (this.folderBtn != null) {
                this.folderBtn.method_48229(x - 5, y);
                this.folderBtn.method_55445(18, 18);
                if (this.folderBtn.method_25405((double)mouseX, (double)mouseY)) {
                    this.folderBtn.method_25394(context, mouseX, mouseY, tickDelta);
                }
                context.method_51439(StatViewer.this.client.field_1772, class_2561.method_30163((String)(this.folder.open ? "\u25bc" : "\u25b6")), x + 1, centerHeight + 1, -1, true);
                context.method_51439(StatViewer.this.client.field_1772, (class_2561)this.folderName, x + 18, centerHeight + 1, -1, true);
            } else {
                context.method_25294(x - 5, y, x + entryWidth - (StatViewer.this.method_44392() ? 8 : 0), y + entryHeight, Integer.MIN_VALUE);
                context.method_51439(StatViewer.this.client.field_1772, (class_2561)this.key, x, centerHeight, -1, true);
                context.method_51439(StatViewer.this.client.field_1772, (class_2561)this.value, x + entryWidth - (StatViewer.this.method_44392() ? 8 : 0) - StatViewer.this.client.field_1772.method_27525((class_5348)this.value) - 3, centerHeight, -1, true);
            }
        }
    }
}

