/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stock;

import avox.openutils.OpenItemStack;
import java.time.LocalDate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class StockItem {
    public OpenItemStack itemStack;
    public class_2561 name;
    public int storage;
    public class_243 position;
    public LocalDate created;
    public int bought;
    public int transactions;
    public int earned;
    public boolean inStock;

    public StockItem(class_1799 stack, boolean inStock) {
        this.itemStack = new OpenItemStack(stack, false);
        this.inStock = inStock;
        class_9290 lore = (class_9290)stack.method_58694(class_9334.field_49632);
        if (lore == null) {
            return;
        }
        for (class_2561 line : lore.comp_2400()) {
            String text = line.getString().trim();
            if (text.isEmpty()) continue;
            Matcher storageMatcher = Pattern.compile("Lager: ([\\d ]+) st").matcher(text);
            if (storageMatcher.find()) {
                this.storage = this.getInteger(storageMatcher.group(1));
                continue;
            }
            Matcher positionMatcher = Pattern.compile("Position: (-*\\d+), (-*\\d+), (-*\\d+)").matcher(text);
            if (positionMatcher.find()) {
                this.position = new class_243(Double.parseDouble(positionMatcher.group(1)), Double.parseDouble(positionMatcher.group(2)), Double.parseDouble(positionMatcher.group(3)));
                continue;
            }
            Matcher createdMatcher = Pattern.compile("Skapades: ([\\d-]+)").matcher(text);
            if (createdMatcher.find()) {
                this.created = LocalDate.parse(createdMatcher.group(1));
                continue;
            }
            Matcher boughtMatcher = Pattern.compile("Antal k\u00f6pta: ([\\d ]+) st").matcher(text);
            if (boughtMatcher.find()) {
                this.bought = this.getInteger(boughtMatcher.group(1));
                continue;
            }
            Matcher transactionsMatcher = Pattern.compile("Antal transaktioner: ([\\d ]+) st").matcher(text);
            if (transactionsMatcher.find()) {
                this.transactions = this.getInteger(transactionsMatcher.group(1));
                continue;
            }
            Matcher earnedMatcher = Pattern.compile("Tj\u00e4nat: ([\\d ]+) kr").matcher(text);
            if (!earnedMatcher.find()) continue;
            this.earned = this.getInteger(earnedMatcher.group(1));
        }
        this.name = this.itemStack.getItemName();
    }

    private int getInteger(String value) {
        return Integer.parseInt(value.replaceAll(" ", ""));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StockItem other = (StockItem)obj;
        if (this.itemStack == null || other.itemStack == null) {
            return false;
        }
        return this.itemStack.equals(other.itemStack);
    }

    public int hashCode() {
        return this.itemStack != null ? this.itemStack.hashCode() : 0;
    }
}

