/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules;

import avox.openutils.Module;
import avox.openutils.OpenUtils;
import avox.openutils.SubserverManager;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.Calendar;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_9779;

public class MarketResetModule
extends Module<Config> {
    public static final MarketResetModule INSTANCE = new MarketResetModule(class_310.method_1551());
    private boolean remindedForToday = false;
    private static boolean renderPartyBackground = false;
    private static int currentPartyTick = 0;
    private static final int[] party_colors = new int[]{0x20FF0000, 553624832, 0x20FFFF00, 0x2000FF00, 0x2000FFFF, 0x20FF00FF};

    private MarketResetModule(class_310 client) {
        super("market_reset", 3, Config.class);
        HudElementRegistry.addFirst((class_2960)class_2960.method_60655((String)"openutils", (String)"market_party"), this::renderPartyBackground);
    }

    @Override
    public void tick(class_310 client) {
        if (renderPartyBackground) {
            ++currentPartyTick;
        }
        if (((Config)this.config).moduleEnabled) {
            boolean checkTimer = ((Config)this.config).sendRequirement.equals((Object)SurvivalMarket.NONE);
            if (!checkTimer) {
                checkTimer = ((Config)this.config).sendRequirement.equals((Object)SurvivalMarket.IN_SURVIVAL) ? OpenUtils.playerInSurvival() : SubserverManager.playerOn90gQopen;
            }
            if (checkTimer) {
                int minute = Calendar.getInstance().get(12);
                if (minute == ((Config)this.config).notificationOffset || minute == 20 + ((Config)this.config).notificationOffset || minute == (40 + ((Config)this.config).notificationOffset) % 60) {
                    if (!this.remindedForToday) {
                        this.remindedForToday = true;
                        if (((Config)this.config).partyMode) {
                            this.sendPartyModeNotification(client);
                        } else {
                            this.sendNormalNotification(client);
                        }
                    }
                } else {
                    this.remindedForToday = false;
                }
            }
        }
    }

    private void sendPartyModeNotification(class_310 client) {
        int i;
        new Thread(() -> {
            renderPartyBackground = true;
            currentPartyTick = 0;
            String[] colors = new String[]{"\u00a7c", "\u00a76", "\u00a7e", "\u00a7a", "\u00a7b", "\u00a7d"};
            client.field_1705.method_34001(0, 1000, 0);
            for (int i = 0; i < 25; ++i) {
                String color = colors[i % colors.length];
                client.field_1705.method_34003();
                client.field_1705.method_34004(class_2561.method_30163((String)(color + "\u00a7lMARKNAD RESET!!!")));
                client.field_1705.method_34002(class_2561.method_30163((String)"\u00a7b\u00a7lS\u00c4LJ S\u00c4LJ S\u00c4LJ!!!"));
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            client.field_1705.method_34003();
            client.field_1705.method_1742();
        }).start();
        for (i = 0; i < 3; ++i) {
            OpenUtils.addToast(client, "Marknadsgr\u00e4nsen har \u00e5terst\u00e4llts!", "Du kan nu s\u00e4lja igen!");
        }
        for (i = 0; i < 5; ++i) {
            if (!((Config)this.config).useSound) continue;
            if (client.field_1724 == null) {
                return;
            }
            client.field_1724.method_56078(class_3417.field_17265);
        }
    }

    private void sendNormalNotification(class_310 client) {
        OpenUtils.addToast(client, "Marknadsgr\u00e4nsen har \u00e5terst\u00e4llts!", "Du kan nu s\u00e4lja igen!");
        if (((Config)this.config).useSound) {
            if (client.field_1724 == null) {
                return;
            }
            client.field_1724.method_56078(class_3417.field_17265);
        }
    }

    private void renderPartyBackground(class_332 context, class_9779 renderTickCounter) {
        if (((Config)this.config).moduleEnabled) {
            if (!renderPartyBackground) {
                return;
            }
            long elapsed = currentPartyTick;
            if (currentPartyTick >= 100) {
                renderPartyBackground = false;
                return;
            }
            class_310 client = class_310.method_1551();
            int index = (int)(elapsed / 2L % (long)party_colors.length);
            int color = party_colors[index];
            int width = client.method_22683().method_4486();
            int height = client.method_22683().method_4502();
            context.method_25294(0, 0, width, height, color);
        }
    }

    @Override
    protected Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public void loadConfig(ConfigCategory.Builder category) {
        category.group(OptionGroup.createBuilder().name(class_2561.method_30163((String)"Marknadsnotifikationer")).option(Option.createBuilder().name(class_2561.method_30163((String)"Anv\u00e4nd Modul")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Sl\u00e5 p\u00e5 eller av marknadsnotifikationerna.")})).binding((Object)true, () -> ((Config)this.config).moduleEnabled, val -> {
            ((Config)this.config).moduleEnabled = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Notifikationskrav")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Vilket krav som kr\u00e4vs f\u00f6r att notifikationen ska skickas.")})).binding((Object)SurvivalMarket.IN_SURVIVAL, () -> ((Config)this.config).sendRequirement, newVal -> {
            ((Config)this.config).sendRequirement = newVal;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(SurvivalMarket.class)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Party Mode")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om du vill aktivera party mode eller inte.")})).binding((Object)false, () -> ((Config)this.config).partyMode, newVal -> {
            ((Config)this.config).partyMode = newVal;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Notifikationsf\u00f6rdr\u00f6jning")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Hur m\u00e5nga minuter efter resetten som notifikationen ska skickas.")})).binding((Object)0, () -> ((Config)this.config).notificationOffset, newVal -> {
            ((Config)this.config).notificationOffset = newVal;
        }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)19)).step((Number)1)).formatValue(val -> class_2561.method_30163((String)(val + " min")))).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Anv\u00e4nd Ljud")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om ett litet klock-ljud ska spelas n\u00e4r notifikationen skickas.")})).binding((Object)true, () -> ((Config)this.config).useSound, newVal -> {
            ((Config)this.config).useSound = newVal;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).build());
    }

    public static class Config
    extends Module.ModuleConfig {
        @SerialEntry
        public SurvivalMarket sendRequirement = SurvivalMarket.IN_SURVIVAL;
        @SerialEntry
        public boolean partyMode = false;
        @SerialEntry
        public int notificationOffset = 0;
        @SerialEntry
        public boolean useSound = true;
    }

    public static enum SurvivalMarket implements NameableEnum
    {
        NONE,
        ON_OPEN,
        IN_SURVIVAL;


        public class_2561 getDisplayName() {
            class_2561 returnText = null;
            switch (this.name()) {
                case "NONE": {
                    returnText = class_2561.method_30163((String)"Inget");
                    break;
                }
                case "ON_OPEN": {
                    returnText = class_2561.method_30163((String)"Inne p\u00e5 90gQopen");
                    break;
                }
                case "IN_SURVIVAL": {
                    returnText = class_2561.method_30163((String)"Inne i survival");
                }
            }
            return returnText;
        }
    }
}

