/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.quests;

import avox.openutils.OpenUtils;
import avox.openutils.modules.quests.Quest;
import avox.openutils.modules.quests.QuestModule;
import avox.openutils.modules.quests.questScreen.QuestScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7417;

public class QuestManager {
    public static final ArrayList<Quest> quests = new ArrayList();
    private static final List<Integer> validSlots = List.of(11, 12, 13, 14, 20, 21, 22, 23, 29, 30, 31, 32, 38, 39, 40, 41);
    public static boolean autoClose = false;
    public static boolean openQuestScreen = false;

    public static void updateQuestList() {
        class_310 client = class_310.method_1551();
        if (!QuestModule.renderQuestHud) {
            client.field_1724.method_7353(class_2561.method_30163((String)("\u00a76OpenModpack: \u00a7eQuest Pad is disabled! \u00a7fToggle with: \u00a77[" + QuestModule.toggleQuestPad.method_16007().getString() + "]")), false);
        }
        class_1703 screenHandler = client.field_1724.field_7512;
        List<String> questIDs = quests.stream().map(quest -> quest.ID).toList();
        ArrayList<String> correctIDs = new ArrayList<String>();
        for (int slot : validSlots) {
            Quest quest2 = new Quest(screenHandler.method_7611(slot).method_7677());
            if (!quest2.claimed) continue;
            correctIDs.add(quest2.ID);
            if (questIDs.contains(quest2.ID)) continue;
            quests.add(quest2);
        }
        quests.removeIf(quest -> !correctIDs.contains(quest.ID));
        if (autoClose) {
            autoClose = false;
            if (openQuestScreen) {
                openQuestScreen = false;
                if (!quests.isEmpty()) {
                    client.method_1507((class_437)new QuestScreen());
                } else {
                    client.method_1507(null);
                }
            } else {
                client.method_1507(null);
            }
        }
    }

    public static void newActionBar(class_2561 message) {
        if (!OpenUtils.playerInSurvival()) {
            return;
        }
        String text = message.getString();
        Pattern pattern = Pattern.compile("\\w+\\s+\\d+\u00d7\\s+([^(/)]+)\\s+\\((\\d+)/(\\d+)\\)");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String material = QuestManager.extractTranslationKey(message);
            int done = Integer.parseInt(matcher.group(2));
            int total = Integer.parseInt(matcher.group(3));
            List<Quest> questList = quests.stream().filter(quest -> quest.missionTranslationKey.equals(material) && quest.total == total).toList();
            if (!questList.isEmpty()) {
                Quest quest2 = questList.getFirst();
                quest2.completed = done;
                quests.remove(quest2);
                if (quest2.completed < quest2.total) {
                    quests.add(quest2);
                }
            } else {
                QuestManager.reloadQuests();
            }
        }
    }

    public static void reloadQuests() {
        class_310 client = class_310.method_1551();
        autoClose = true;
        client.method_1562().method_45730("quests");
    }

    public static String extractTranslationKey(class_2561 text) {
        Object[] objectArray = text.method_10851();
        if (objectArray instanceof class_2588) {
            class_2588 content = (class_2588)objectArray;
            for (Object arg : content.method_11023()) {
                class_2561 argText;
                class_7417 class_74172;
                if (!(arg instanceof class_2561) || !((class_74172 = (argText = (class_2561)arg).method_10851()) instanceof class_2588)) continue;
                class_2588 innerContent = (class_2588)class_74172;
                return innerContent.method_11022();
            }
        }
        for (class_2561 sibling : text.method_10855()) {
            String result = QuestManager.extractTranslationKey(sibling);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void checkQuestExpireTimes() {
        if (QuestModule.INSTANCE.getConfig().moduleEnabled && OpenUtils.playerInSurvival()) {
            long currentTime = System.currentTimeMillis();
            quests.removeIf(quest -> quest.expiresAt < currentTime);
        }
    }
}

