/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats;

import java.text.NumberFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class FormatTools {
    private static final NumberFormat numberFormat = NumberFormat.getInstance(Locale.forLanguageTag("sv-SE"));

    public static String toTitleCase(String input) {
        return Arrays.stream(input.trim().replaceAll("_", " ").split("\\s+")).map(word -> word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public static String formatNumber(long number) {
        return numberFormat.format(number);
    }

    public static String parseMillis(String millis) {
        try {
            long milliSecs = Long.parseLong(millis.replaceAll("\\D", ""));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(milliSecs);
            long minutes = TimeUnit.MILLISECONDS.toMinutes(milliSecs);
            long hours = TimeUnit.MILLISECONDS.toHours(milliSecs);
            long days = TimeUnit.MILLISECONDS.toDays(milliSecs);
            long months = days / 30L;
            days %= 30L;
            hours %= 24L;
            minutes %= 60L;
            seconds %= 60L;
            StringBuilder sb = new StringBuilder();
            if (months > 0L) {
                sb.append(months).append(" m\u00e5n, ");
            }
            if (days > 0L) {
                sb.append(days).append(" d, ");
            }
            if (hours > 0L) {
                sb.append(hours).append(" h, ");
            }
            if (minutes > 0L) {
                sb.append(minutes).append(" min, ");
            }
            if (seconds > 0L) {
                sb.append(seconds).append(" sek");
            }
            if (!sb.isEmpty() && sb.charAt(sb.length() - 2) == ',') {
                sb.delete(sb.length() - 2, sb.length());
            }
            return sb.toString();
        }
        catch (Exception e) {
            return millis;
        }
    }

    public static String parkourTime(String millis) {
        try {
            long milliSecs = Long.parseLong(millis.replaceAll("\\D", ""));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(milliSecs);
            long seconds = TimeUnit.MILLISECONDS.toSeconds(milliSecs) % 60L;
            long milliseconds = milliSecs % 1000L;
            return String.format("%02d:%02d.%03d", minutes, seconds, milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return millis;
        }
    }

    public static class_5250 parseRank(String rank) {
        class_5250 text = class_2561.method_43470((String)rank);
        switch (rank) {
            case "Norendor": {
                text = text.method_54663(43690);
                break;
            }
            case "Avalon": {
                text = text.method_54663(0x55FFFF);
                break;
            }
            case "Nirethia": {
                text = text.method_54663(0xFFAA00);
                break;
            }
            case "Bashlang": {
                text = class_2561.method_43470((String)"B").method_54663(0x557FFF).method_10852((class_2561)class_2561.method_43470((String)"a").method_54663(5625087).method_10852((class_2561)class_2561.method_43470((String)"s").method_54663(0x55FFD5).method_10852((class_2561)class_2561.method_43470((String)"h").method_54663(5635968).method_10852((class_2561)class_2561.method_43470((String)"l").method_54663(0x7FFF55).method_10852((class_2561)class_2561.method_43470((String)"a").method_54663(13958997).method_10852((class_2561)class_2561.method_43470((String)"n").method_54663(0xFFD555).method_10852((class_2561)class_2561.method_43470((String)"g").method_54663(16744533))))))));
                break;
            }
            case "Gq": {
                text = class_2561.method_43470((String)"90gq").method_54663(43520);
                break;
            }
            case "Media": {
                text = text.method_54663(11104511);
                break;
            }
            case "Hjalpare": {
                text = class_2561.method_43470((String)"Hj\u00e4lpare").method_54663(0x55FF55);
                break;
            }
            case "Moderator": {
                text = text.method_54663(0xFF5555);
                break;
            }
            case "Byggare": {
                text = text.method_54663(0x5555FF);
                break;
            }
            case "Utvecklare": {
                text = text.method_54663(3652597);
                break;
            }
            case "Admin": {
                text = text.method_54663(0xAA0000);
                break;
            }
            default: {
                return class_2561.method_43470((String)("\u00a77" + text.getString()));
            }
        }
        return class_2561.method_43473().method_10852((class_2561)text).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    }

    public static class_5250 parseCreativeRank(String rank) {
        class_5250 result = class_2561.method_43470((String)rank);
        switch (rank) {
            case "Newbie": {
                result = class_2561.method_43470((String)"Nyb\u00f6rjare").method_54663(8183094);
                break;
            }
            case "Apprentice": {
                result = class_2561.method_43470((String)"L\u00e4rling").method_54663(6400234);
                break;
            }
            case "Experienced": {
                result = class_2561.method_43470((String)"Erfaren").method_54663(15231442);
                break;
            }
            case "Expert": {
                result = class_2561.method_43470((String)"Expert").method_54663(11093475);
                break;
            }
            case "Architect": {
                result = class_2561.method_43470((String)"Arkitekt").method_54663(15711256);
            }
        }
        return result;
    }

    public static class_5250 parseParkourName(String name) {
        class_5250 result = class_2561.method_43470((String)name);
        switch (name) {
            case "Nyb\u00f6rjare": {
                result = result.method_54663(0x55FF55);
                break;
            }
            case "L\u00e4tt": {
                result = result.method_54663(43520);
                break;
            }
            case "Medium": {
                result = result.method_54663(0xFFAA00);
                break;
            }
            case "Sv\u00e5r": {
                result = result.method_54663(0xAA0000);
                break;
            }
            case "Extrem": {
                result = result.method_54663(43690);
                break;
            }
            case "Insane": {
                result = result.method_54663(0xFF55FF);
                break;
            }
            case "Mardr\u00f6m": {
                result = result.method_54663(0xFFFFFF);
            }
        }
        return result;
    }

    public static String reformatDate(String isoDate) {
        ZonedDateTime zdt = ZonedDateTime.parse(isoDate);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return zdt.format(formatter);
    }

    public static int experienceToLevel(int experience, boolean player) {
        if (player) {
            return (int)(-60.0 + Math.sqrt(40 * experience + 6400)) / 20;
        }
        return (int)((Math.sqrt(200 * experience + 2560000) - 1500.0) / 100.0);
    }

    public static int levelToExperience(int level, boolean player) {
        if (player) {
            return (int)(10.0 * (Math.pow(level, 2.0) + (double)(6 * level) - 7.0));
        }
        return (int)((Math.pow(100 * level + 1500, 2.0) - 2560000.0) / 200.0);
    }
}

