/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats;

import avox.openutils.modules.stats.FormatTools;
import avox.openutils.modules.stats.screen.types.StatTabTypes;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Formatter {
    public static class_5250 formatCategory(StatTabTypes tab, String category, String suffix) {
        if (category.equals("parkour")) {
            category = "Klarade parkours";
        }
        category = FormatTools.toTitleCase(category);
        category = category.replaceAll("Uhc", "UHC").replaceAll("Mb", "MB");
        return class_2561.method_43470((String)(category + suffix));
    }

    public static class_5250 formatFolder(StatTabTypes tab, String text, String category) {
        String newText = text;
        newText = FormatTools.toTitleCase(newText.replaceAll("_", " "));
        newText = newText.replaceAll("Oitc", "OITC").replaceAll("Sg", "Survival Games").replaceAll("Tnt", "TNT").replaceAll("Season", "This Season");
        class_5250 returnText = class_2561.method_43470((String)newText);
        return returnText;
    }

    public static class_5250 formatKey(StatTabTypes tab, String key, String category, String folder) {
        String newKey = key;
        if (List.of("id", "uuid").contains(key)) {
            newKey = newKey.toUpperCase();
        } else if (!(key.equals("gQmynt") || category.equals("members") || category.contains("leaderboard") || folder.equals("builders"))) {
            newKey = FormatTools.toTitleCase(newKey.replaceAll("_", " "));
        }
        if (tab.equals((Object)StatTabTypes.PLAYER) && category.equals("parkour") && key.equals("id")) {
            newKey = "Parkour ID";
        }
        if (key.equals("null")) {
            newKey = "Unknown";
        }
        newKey = newKey.replaceAll("Oitc", "OITC").replaceAll("Sg", "Survival Games").replaceAll("Tnt", "TNT").replaceAll("Mvps", "MVPs");
        class_5250 returnText = class_2561.method_43470((String)newKey);
        return returnText;
    }

    public static class_5250 formatValue(StatTabTypes tab, String value, String key, String category, String folder) {
        Object newValue = value;
        if (key.equals("progress")) {
            boolean survival = category.equals("survival");
            int totalExperience = Integer.parseInt((String)newValue);
            int currentLevel = FormatTools.experienceToLevel(totalExperience, survival);
            int experience = totalExperience - FormatTools.levelToExperience(currentLevel, survival);
            int nextLevelExp = FormatTools.levelToExperience(currentLevel + 1, survival) - FormatTools.levelToExperience(currentLevel, survival);
            double progress = (double)experience / (double)nextLevelExp * 100.0;
            newValue = String.format("%.2f", progress) + "% \u00a7a" + "\u258f".repeat((int)progress) + "\u00a7c" + "\u258f".repeat((int)Math.max(0.0, 100.0 - progress));
        }
        if (((String)newValue).matches("\\d+")) {
            newValue = FormatTools.formatNumber(Long.parseLong((String)newValue));
        }
        if (!(key.equals("last_server") || key.equals("username") || ((String)newValue).equals("N/A"))) {
            newValue = FormatTools.toTitleCase((String)newValue);
        }
        if (key.equals("onlinetime")) {
            newValue = FormatTools.parseMillis(value);
        }
        if (key.equals("lobby_parkour_time") || category.equals("leaderboard_speed")) {
            newValue = FormatTools.parkourTime((String)newValue);
        }
        if (key.equals("first_join") || category.equals("guild") && key.equals("created")) {
            newValue = FormatTools.reformatDate((String)newValue);
        }
        if (category.equals("parkour")) {
            if (key.equals("record")) {
                newValue = FormatTools.parkourTime((String)newValue);
            } else if (key.equals("rank")) {
                newValue = "#" + (String)newValue;
            }
        }
        switch (key) {
            case "money": {
                newValue = (String)newValue + " kr";
                break;
            }
            case "experience": {
                newValue = (String)newValue + " XP";
                break;
            }
            case "quest_streak": {
                newValue = (String)newValue + " dagar";
            }
        }
        if (category.equals("members")) {
            switch (newValue) {
                case "Owner": {
                    newValue = "\u00a7c" + (String)newValue;
                    break;
                }
                case "Moderator": {
                    newValue = "\u00a76" + (String)newValue;
                    break;
                }
                case "Member": {
                    newValue = "\u00a7e" + (String)newValue;
                }
            }
        }
        class_5250 returnText = class_2561.method_43470((String)newValue);
        if (key.equals("rank")) {
            switch (category) {
                case "Player": {
                    returnText = FormatTools.parseRank((String)newValue);
                    break;
                }
                case "creative": {
                    returnText = FormatTools.parseCreativeRank((String)newValue);
                }
            }
        }
        if (category.equals("parkour info") && key.equals("difficulty")) {
            returnText = FormatTools.parseParkourName((String)newValue);
        }
        return returnText;
    }
}

