/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats;

import avox.openutils.OpenUtils;
import avox.openutils.modules.stats.screen.StatViewer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

public class InformationFetcher {
    public static JsonObject fetchFromAPI(String url, StatViewer statViewer) {
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(60L)).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.body().matches("\\d+")) {
            JsonObject resp = new JsonObject();
            resp.addProperty("total", (Number)Integer.parseInt(response.body()));
            return resp;
        }
        try {
            JsonObject parsedData = JsonParser.parseString((String)response.body()).getAsJsonObject();
            if (parsedData.getAsJsonObject().has("error")) {
                statViewer.drawMessage = true;
                statViewer.specialMessage = "\u00a7c" + parsedData.get("error").getAsString();
                return null;
            }
            return parsedData;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                statViewer.drawMessage = true;
                statViewer.specialMessage = "\u00a7c" + response.body();
                OpenUtils.LOGGER.error("Fetching information failed with: " + response.body() + "\"");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                statViewer.drawMessage = true;
                statViewer.specialMessage = "\u00a7cUnknown error occurred!";
                OpenUtils.LOGGER.error("Fetching information failed");
            }
        }
        return null;
    }
}

