/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats.screen.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.joml.Matrix3x2fStack;

public class Suggestor {
    public final class_342 textField;
    private final class_327 textRenderer;
    public ArrayList<Integer> lengths = new ArrayList();
    public ArrayList<String> filteredSuggestions = new ArrayList();
    public ArrayList<String> displaySuggestions = new ArrayList();
    private final List<String> suggestions;
    private final List<String> entrySuggestions;
    public int scroll = 0;
    public int highlight = 0;
    public final int maxSuggestions;
    public int startX = 0;
    public int startY = 0;
    public int width = 0;
    public int height = 0;
    public double lastMouseX;
    public double lastMouseY;
    public boolean render = false;

    public Suggestor(class_342 textField, class_327 textRenderer, int maxHeight, ArrayList<String> suggestions) {
        this.textField = textField;
        this.textRenderer = textRenderer;
        this.maxSuggestions = maxHeight / 11;
        this.suggestions = suggestions;
        this.entrySuggestions = suggestions.stream().map(String::toLowerCase).toList();
    }

    public void updateSuggestionEntries() {
        String searchContent = this.textField.method_1882();
        this.filteredSuggestions.clear();
        this.lengths.clear();
        if (!this.entrySuggestions.contains(searchContent.toLowerCase())) {
            for (String suggestion : this.suggestions) {
                if (!suggestion.toLowerCase().contains(searchContent.toLowerCase())) continue;
                this.filteredSuggestions.add(suggestion);
                this.lengths.add(this.textRenderer.method_1727(suggestion));
            }
        }
        this.updateSuggestions();
    }

    public void updateSuggestions() {
        this.displaySuggestions.clear();
        this.scroll = this.filteredSuggestions.size() > this.maxSuggestions ? Math.clamp((long)this.scroll, 0, this.filteredSuggestions.size() - this.maxSuggestions) : 0;
        int end = Math.min(this.scroll + this.maxSuggestions, this.filteredSuggestions.size());
        if (end == 0) {
            this.render = false;
            return;
        }
        this.displaySuggestions = new ArrayList<String>(this.filteredSuggestions.subList(this.scroll, end));
        this.width = Collections.max(new ArrayList<Integer>(this.lengths.subList(this.scroll, end)));
        this.height = this.displaySuggestions.size() * 11;
        if (!this.displaySuggestions.isEmpty()) {
            this.render = true;
        }
    }

    public void render(class_332 context, double mouseX, double mouseY) {
        if (!this.render) {
            return;
        }
        this.startX = this.textField.method_46426();
        this.startY = this.textField.method_46427() + 20;
        int y = this.startY + 3;
        int x = this.startX + 3;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        context.method_25294(x - 3, y - 3, x + this.width + 3, y + this.displaySuggestions.size() * 11, -872415232);
        if ((this.lastMouseX != mouseX || this.lastMouseY != mouseY) && (double)this.startX < mouseX && (double)(this.startX + this.width) > mouseX && (double)this.startY < mouseY && (double)(this.startY + this.height) > mouseY) {
            this.highlight = (int)Math.ceil((mouseY - (double)this.startY) / 11.0) - 1;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        for (String suggestion : this.displaySuggestions) {
            if (this.displaySuggestions.indexOf(suggestion) == this.highlight) {
                context.method_25303(this.textRenderer, suggestion, x, y, -6346);
            } else {
                context.method_25303(this.textRenderer, suggestion, x, y, -1);
            }
            y += 11;
        }
        matrices.popMatrix();
    }

    public void mouseScrolled(boolean up, double mouseX, double mouseY) {
        this.scroll += up ? 1 : -1;
        this.updateSuggestions();
    }

    public void mouseClicked() {
        this.textField.method_1852(this.filteredSuggestions.get(this.scroll + this.highlight));
    }
}

