/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats.screen.widgets.boxes;

import avox.openutils.modules.stats.FormatTools;
import avox.openutils.modules.stats.screen.StatViewer;
import avox.openutils.modules.stats.screen.types.ValidTypes;
import avox.openutils.modules.stats.screen.widgets.SearchBox;
import avox.openutils.modules.stats.screen.widgets.navigation.StatCategory;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class TotalTabBox {
    public SearchBox searchBox;
    private String lastSearchValue;

    public TotalTabBox(class_310 client, int width, int height, StatViewer viewer) {
        this.searchBox = new SearchBox(client, width, height, viewer, class_2561.method_30163((String)"Total Statistics"), this::parseJsonToCategories, this::getAPIUrl, this::verifyInput, new ArrayList<String>(ValidTypes.totalMessages.keySet().stream().map(this::parseMessage).toList()));
    }

    private String getAPIUrl(String searchValue) {
        this.lastSearchValue = searchValue;
        StringBuilder APIFetchString = new StringBuilder("https://api.90gqopen.se/total/?type=");
        APIFetchString.append(searchValue.replaceAll(" ", "_").toLowerCase());
        return APIFetchString.toString();
    }

    private ArrayList<StatCategory> parseJsonToCategories(JsonObject data) {
        this.searchBox.statViewer.specialMessage = String.format(ValidTypes.totalMessages.get(this.lastSearchValue.replaceAll(" ", "_").toLowerCase()), FormatTools.formatNumber(data.get("total").getAsInt()));
        return new ArrayList<StatCategory>();
    }

    private boolean verifyInput(String input) {
        return ValidTypes.totalMessages.containsKey(input.replaceAll(" ", "_").toLowerCase());
    }

    private String parseMessage(String message) {
        message = FormatTools.toTitleCase(message);
        message = message.replaceAll("Uhc", "UHC").replaceAll("Mb", "MB").replaceAll("Gqmynt", "gQmynt");
        return message;
    }
}

