/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.worldmap;

import avox.openutils.OpenUtils;
import avox.openutils.modules.worldmap.WorldMapModule;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class BannerManager {
    public static volatile ArrayList<Banner> banners = new ArrayList();
    private static long lastFetchTime = 0L;
    private static final long COOLDOWN = 600000L;
    private static final HashMap<String, class_2960> mapPins = new HashMap();

    public static class_2960 getBanner(String color) {
        if (mapPins.containsKey(color)) {
            return mapPins.get(color);
        }
        class_2960 texture = class_2960.method_60655((String)"openutils", (String)("textures/gui/map_pins/" + color + ".png"));
        mapPins.put(color, texture);
        return texture;
    }

    public static void fetchBanners() {
        long now = System.currentTimeMillis();
        if (now - lastFetchTime < 600000L) {
            return;
        }
        lastFetchTime = now;
        new Thread(() -> {
            try {
                HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://openavox.se/getbanners")).timeout(Duration.ofSeconds(10L)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                JsonArray arr = JsonParser.parseString((String)response.body()).getAsJsonArray();
                ArrayList<Banner> parsed = new ArrayList<Banner>();
                for (JsonElement el : arr) {
                    JsonObject obj = el.getAsJsonObject();
                    String map = obj.get("map").getAsString();
                    int x = obj.get("x").getAsInt();
                    int y = obj.get("y").getAsInt();
                    String name = obj.get("name").getAsString();
                    String color = obj.get("color").getAsString();
                    class_243 worldMapLocation = BannerManager.computeWorldMapLocation(map, x, y);
                    parsed.add(new Banner(map, x, y, worldMapLocation, name, color));
                }
                banners = parsed;
            }
            catch (Exception e) {
                OpenUtils.LOGGER.info("[OpenUtils]: Failed to load /warp Worldmap banners! " + e.getMessage());
            }
        }, "BannerFetcherThread").start();
    }

    private static class_243 computeWorldMapLocation(String map, int relative_x, int relative_y) {
        String[] parts = map.split(",");
        int x = Integer.parseInt(parts[0].trim());
        int z = Integer.parseInt(parts[1].trim());
        return new class_243(WorldMapModule.originBottomLeftMap.field_1352 + (double)x + (double)(relative_x + 128) / 255.0, 58.0, WorldMapModule.originBottomLeftMap.field_1350 - (double)z + (double)(relative_y + 128) / 255.0);
    }

    public record Banner(String map, int x, int y, class_243 worldMapLocation, String name, String color) {
    }
}

