/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.worldmap;

import avox.openutils.Module;
import avox.openutils.SubserverManager;
import avox.openutils.modules.worldmap.BannerManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_765;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WorldMapModule
extends Module<Config> {
    public static final WorldMapModule INSTANCE = new WorldMapModule(class_310.method_1551());
    public static final class_243 originBottomLeftMap = new class_243(8843.0, 58.0, -7366.0);
    public static final class_243 originBottomLeft = new class_243(8839.0, 58.0, -7362.0);
    public static final class_243 originTopRight = new class_243(8886.0, 65.0, -7409.0);
    private final double minTile = Math.floor(-19.40625);
    private final double maxTile = Math.floor(19.65625);
    public static boolean withinArea = false;
    public class_241 target;
    public static class_243 arrow;

    private WorldMapModule(class_310 client) {
        super("world_map", 10, Config.class);
        HudElementRegistry.addFirst((class_2960)class_2960.method_60655((String)"openutils", (String)"world_map"), this::renderHud);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_4597 consumer;
            class_4587 matrixStack;
            if (((Config)this.config).moduleEnabled && withinArea && arrow != null) {
                matrixStack = context.matrices();
                consumer = context.consumers();
                if (matrixStack != null && consumer != null) {
                    WorldMapModule.renderTextureAtBlock(matrixStack, consumer, context.gameRenderer().method_19418().method_19326(), 2.0f, class_2960.method_60655((String)"openutils", (String)"textures/gui/map_pins/red.png"), arrow, 128, 128);
                }
            }
            if (((Config)this.config).moduleEnabled && withinArea && ((Config)this.config).viewMapPins) {
                matrixStack = context.matrices();
                consumer = context.consumers();
                BannerManager.Banner candidateBanner = null;
                double closestCandidateDist = Double.MAX_VALUE;
                float hidePinDistance = ((Config)this.config).closeInvisiblePins ? 1.5f : 0.0f;
                float maxNameDistance = 10.0f;
                class_243 cameraPos = context.gameRenderer().method_19418().method_19326();
                class_243 lookEnd = cameraPos.method_1019(client.field_1724.method_5828(1.0f).method_1029().method_1021((double)maxNameDistance));
                for (BannerManager.Banner banner : BannerManager.banners) {
                    class_243 max;
                    class_243 min;
                    if (matrixStack == null || consumer == null || banner.worldMapLocation().equals((Object)arrow)) continue;
                    class_243 bannerCenter = banner.worldMapLocation().method_1031(0.0, 0.5, 0.0);
                    double dist = cameraPos.method_1022(bannerCenter);
                    if (dist > (double)hidePinDistance) {
                        class_2960 texture = BannerManager.getBanner(banner.color());
                        WorldMapModule.renderTextureAtBlock(matrixStack, consumer, cameraPos, 0.75f, texture, banner.worldMapLocation(), 128, 128);
                    }
                    if (!(dist >= (double)hidePinDistance) || !(dist <= (double)maxNameDistance) || !this.rayIntersectsBox(cameraPos, lookEnd, min = bannerCenter.method_1023(0.5, 0.5, 0.5), max = bannerCenter.method_1031(0.5, 0.5, 0.5)) || !(dist < closestCandidateDist)) continue;
                    closestCandidateDist = dist;
                    candidateBanner = banner;
                }
                if (candidateBanner != null) {
                    class_243 namePos = candidateBanner.worldMapLocation().method_1031(0.0, 1.0, 0.0);
                    WorldMapModule.renderNameTag(client, matrixStack, consumer, cameraPos, namePos, candidateBanner.name(), 0xF000F0);
                }
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder worldmapCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"worldmap").then(ClientCommandManager.literal((String)"mapid").executes(context -> this.executeMapId(client)))).then(ClientCommandManager.literal((String)"coord_to_id").then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
                int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
                return this.executeCoordToId(client, x, z);
            }))))).then(ClientCommandManager.literal((String)"id_to_coord").then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
                int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
                return this.executeIdToCoord(client, x, z);
            }))));
            dispatcher.register(worldmapCommand);
        });
    }

    private int executeIdToCoord(class_310 client, int x, int z) {
        if (client.field_1724 == null) {
            return 0;
        }
        if (39 >= x && x >= 0 && 39 >= z && z >= 0) {
            double tileX = this.minTile + (double)x;
            double tileZ = this.maxTile - (double)z;
            int xMin = (int)Math.floor(-64.0 + tileX * 512.0);
            int xMax = (int)Math.floor(-64.0 + (tileX + 1.0) * 512.0);
            int zMin = (int)Math.floor(-64.0 + tileZ * 512.0);
            int zMax = (int)Math.floor(-64.0 + (tileZ + 1.0) * 512.0);
            client.field_1724.method_7353(class_2561.method_30163((String)("\u00a77Map ID \u00a7e" + x + ", " + z + "\u00a77 motsvarar koordinaterna:\nX: \u00a7e\u00a7l" + xMin + " \u00a77till \u00a7e\u00a7l" + xMax + "\n\u00a77Z: \u00a7e\u00a7l" + zMin + " \u00a77till\u00a7e\u00a7l " + zMax)), false);
        } else {
            client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7cOgiltigt map ID!"), false);
        }
        return 1;
    }

    private int executeCoordToId(class_310 client, int x, int z) {
        if (client.field_1724 == null) {
            return 0;
        }
        if (x >= -10000 && x <= 10000 && z >= -10000 && z <= 10000) {
            double tileX = Math.floor((double)(x + 64) / 512.0);
            double tileZ = Math.floor((double)(z + 64) / 512.0);
            int mapIdX = (int)(tileX - this.minTile);
            int mapIdZ = (int)(this.maxTile - tileZ);
            client.field_1724.method_7353(class_2561.method_30163((String)("\u00a77Koordinaterna \u00a7e" + x + ", " + z + " \u00a77motsvarar map ID:t \u00a7e\u00a7l" + mapIdX + ", " + mapIdZ + "\u00a77!")), false);
        } else {
            client.field_1724.method_7353(class_2561.method_30163((String)"\u00a7cOgiltigt map ID!"), false);
        }
        return 1;
    }

    public boolean rayIntersectsBox(class_243 start, class_243 end, class_243 min, class_243 max) {
        double tzmax;
        double tzmin;
        double tymax;
        double tymin;
        double tmin = (min.field_1352 - start.field_1352) / (end.field_1352 - start.field_1352);
        double tmax = (max.field_1352 - start.field_1352) / (end.field_1352 - start.field_1352);
        if (tmin > tmax) {
            double tmp = tmin;
            tmin = tmax;
            tmax = tmp;
        }
        if ((tymin = (min.field_1351 - start.field_1351) / (end.field_1351 - start.field_1351)) > (tymax = (max.field_1351 - start.field_1351) / (end.field_1351 - start.field_1351))) {
            double tmp = tymin;
            tymin = tymax;
            tymax = tmp;
        }
        if (tmin > tymax || tymin > tmax) {
            return false;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        if ((tzmin = (min.field_1350 - start.field_1350) / (end.field_1350 - start.field_1350)) > (tzmax = (max.field_1350 - start.field_1350) / (end.field_1350 - start.field_1350))) {
            double tmp = tzmin;
            tzmin = tzmax;
            tzmax = tmp;
        }
        return !(tmin > tzmax) && !(tzmin > tmax);
    }

    private int executeMapId(class_310 client) {
        if (((Config)this.config).moduleEnabled && SubserverManager.getActiveSubServer().equals((Object)SubserverManager.Subserver.SURVIVAL_PLOT) && client.field_1724 != null && client.field_1687 != null) {
            double worldSizeHalf = 10000.0;
            double mapArtSize = 512.0;
            int minTile = (int)Math.floor((-worldSizeHalf + 64.0) / mapArtSize);
            int maxTile = (int)Math.floor((worldSizeHalf + 64.0) / mapArtSize);
            class_243 location = class_243.method_24954((class_2382)client.field_1724.method_24515());
            int tileX = (int)Math.floor((location.field_1352 + 64.0) / mapArtSize);
            int tileZ = (int)Math.floor((location.field_1350 + 64.0) / mapArtSize);
            int mapIdX = tileX - minTile;
            int mapIdZ = maxTile - tileZ;
            class_5250 copyButton = class_2561.method_43470((String)" [Kopiera]").method_10862(class_2583.field_24360.method_10977(class_124.field_1075).method_10958((class_2558)new class_2558.class_10606(mapIdX + ", " + mapIdZ)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Tryck f\u00f6r att kopiera..."))));
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Du befinner dig just nu i Map ID: \u00a7e\u00a7l" + mapIdX + ", " + mapIdZ + "\u00a77!")).method_10852((class_2561)copyButton), false);
            return 1;
        }
        return 0;
    }

    @Override
    public void tick(class_310 client) {
        if (((Config)this.config).moduleEnabled && client.field_1724 != null && client.field_1687 != null && WorldMapModule.withinWorldMap(class_243.method_24954((class_2382)client.field_1724.method_24515()))) {
            if (!withinArea) {
                BannerManager.fetchBanners();
            }
            withinArea = true;
            class_239 hit = client.field_1724.method_5745(10.0, 0.0f, false);
            if (hit.method_17783() == class_239.class_240.field_1332 && hit.method_17784().field_1351 == 58.0) {
                class_3965 blockHit = (class_3965)hit;
                class_243 pos = blockHit.method_17784();
                int x = -10304 + (int)Math.floor((pos.method_10216() - WorldMapModule.originBottomLeftMap.field_1352) * 512.0);
                int z = 9664 + (int)Math.floor((pos.method_10215() - WorldMapModule.originBottomLeftMap.field_1350) * 512.0);
                this.target = new class_241((float)x, (float)z);
                return;
            }
            this.target = null;
            return;
        }
        this.target = null;
        withinArea = false;
    }

    public void renderHud(class_332 context, class_9779 renderTickCounter) {
        if (!withinArea) {
            return;
        }
        class_310 client = class_310.method_1551();
        boolean aboveMap = this.target != null;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        int blockHeight = 10 + (aboveMap ? 15 : 0);
        ArrayList<Integer> widths = new ArrayList<Integer>();
        Object line1 = "";
        Object line2 = "";
        String line3 = "CTRL+F f\u00f6r att hitta position.";
        widths.add(client.field_1772.method_1727(line3));
        if (aboveMap) {
            line1 = "X: " + (int)this.target.field_1343 + " | Y: " + (int)this.target.field_1342;
            line2 = "Map ID: " + (int)Math.floor((10304.0f + this.target.field_1343) / 512.0f) + ", " + (int)Math.floor(1.0f + -(-9664.0f + this.target.field_1342) / 512.0f);
            widths.add(client.field_1772.method_1727((String)line1) + 12);
            widths.add(client.field_1772.method_1727((String)line2) + 12);
        }
        int textWidth = (Integer)Collections.max(widths);
        context.method_25294(width / 2 - textWidth / 2 - 5, height - 50 - blockHeight, width / 2 + textWidth / 2 + 5, height - 50, Integer.MIN_VALUE);
        if (aboveMap) {
            context.method_25300(client.field_1772, (String)line1, width / 2 + 4, height - 50 - blockHeight + 2, -1);
        }
        context.method_25290(class_10799.field_56883, class_2960.method_60655((String)"openutils", (String)"icon.png"), width / 2 - textWidth / 2 - 3, height - 50 - blockHeight + (aboveMap ? 1 : 0), 0.0f, 0.0f, 10, 10, 10, 10);
        Matrix3x2fStack matrixStack = context.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(0.5f, 0.5f);
        if (this.target != null) {
            context.method_25300(client.field_1772, (String)line2, (width / 2 + 4) * 2, (height - 50 - blockHeight + 11 + 2) * 2, -3881788);
        }
        context.method_25300(client.field_1772, line3, width / 2 * 2, (height - 50 + 4) * 2 - 20, -7895161);
        matrixStack.popMatrix();
    }

    public static void renderTextureAtBlock(class_4587 matrices, class_4597 vertexConsumers, class_243 camPos, float scale, class_2960 texture, class_243 position, int texWidth, int texHeight) {
        matrices.method_22903();
        float aspect = (float)texHeight / (float)texWidth;
        float heightWorld = aspect * scale;
        float halfW = scale * 0.5f;
        float halfH = heightWorld * 0.5f;
        float cameraYaw = class_310.method_1551().field_1773.method_19418().method_19330();
        double yawRad = Math.toRadians(cameraYaw);
        class_243 right = new class_243(Math.cos(yawRad), 0.0, Math.sin(yawRad)).method_1029();
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 center = new class_243(position.method_10216(), position.method_10214() + (double)halfH, position.method_10215());
        class_243 topLeft = center.method_1020(right.method_1021((double)halfW)).method_1019(up.method_1021((double)halfH));
        class_243 topRight = center.method_1019(right.method_1021((double)halfW)).method_1019(up.method_1021((double)halfH));
        class_243 botRight = center.method_1019(right.method_1021((double)halfW)).method_1020(up.method_1021((double)halfH));
        class_243 botLeft = center.method_1020(right.method_1021((double)halfW)).method_1020(up.method_1021((double)halfH));
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4588 buffer = vertexConsumers.method_73477(class_1921.method_23580((class_2960)texture));
        int light = 0xF000F0;
        buffer.method_22918(matrix, (float)(topLeft.field_1352 - camPos.field_1352), (float)(topLeft.field_1351 - camPos.field_1351), (float)(topLeft.field_1350 - camPos.field_1350)).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix, (float)(topRight.field_1352 - camPos.field_1352), (float)(topRight.field_1351 - camPos.field_1351), (float)(topRight.field_1350 - camPos.field_1350)).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix, (float)(botRight.field_1352 - camPos.field_1352), (float)(botRight.field_1351 - camPos.field_1351), (float)(botRight.field_1350 - camPos.field_1350)).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(matrix, (float)(botLeft.field_1352 - camPos.field_1352), (float)(botLeft.field_1351 - camPos.field_1351), (float)(botLeft.field_1350 - camPos.field_1350)).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        matrices.method_22909();
    }

    public static void renderNameTag(class_310 client, class_4587 matrices, class_4597 vertexConsumers, class_243 camPos, class_243 position, String text, int light) {
        class_327 textRenderer = client.field_1772;
        if (client.field_1724 == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(position.field_1352 - camPos.field_1352, position.field_1351 - camPos.field_1351, position.field_1350 - camPos.field_1350);
        float cameraYaw = client.field_1773.method_19418().method_19330();
        matrices.method_22907((Quaternionfc)new Quaternionf().rotateY((float)Math.toRadians(-cameraYaw)));
        float scale = 0.025f;
        matrices.method_22905(-scale, -scale, scale);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float xOffset = (float)(-textRenderer.method_1727(text)) / 2.0f;
        int backgroundColor = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
        textRenderer.method_27521(text, xOffset, 0.0f, -2130706433, false, matrix, vertexConsumers, class_327.class_6415.field_33994, backgroundColor, light);
        textRenderer.method_27521(text, xOffset, 0.0f, -1, false, matrix, vertexConsumers, class_327.class_6415.field_33993, 0, class_765.method_62228((int)light, (int)2));
        matrices.method_22909();
    }

    @Override
    protected Class<Config> getConfigClass() {
        return Config.class;
    }

    @Override
    public void loadConfig(ConfigCategory.Builder category) {
        category.group(OptionGroup.createBuilder().name(class_2561.method_30163((String)"/warp Worldmap")).option(Option.createBuilder().name(class_2561.method_30163((String)"Anv\u00e4nd Modul")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Sl\u00e5 p\u00e5 eller av worldmap tools.")})).binding((Object)true, () -> ((Config)this.config).moduleEnabled, val -> {
            ((Config)this.config).moduleEnabled = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Visa map pins")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om du vill se map pins hela tiden.")})).binding((Object)true, () -> ((Config)this.config).viewMapPins, val -> {
            ((Config)this.config).viewMapPins = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Ta Bort ItemFrame Namn")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om alla item frame namn i Worldmap ska tas bort (left alt s\u00e5 syns de \u00e4nd\u00e5).")})).binding((Object)true, () -> ((Config)this.config).removeItemFrameNames, val -> {
            ((Config)this.config).removeItemFrameNames = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"G\u00f6m Pins Vid N\u00e4rhet")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om alla pins ska g\u00f6mmas n\u00e4r man g\u00e5r f\u00f6r n\u00e4ra.")})).binding((Object)true, () -> ((Config)this.config).closeInvisiblePins, val -> {
            ((Config)this.config).closeInvisiblePins = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).build());
    }

    public Config getConfig() {
        return (Config)this.config;
    }

    public static boolean withinWorldMap(class_243 position) {
        if (SubserverManager.getActiveSubServer().equals((Object)SubserverManager.Subserver.SURVIVAL_PLOT)) {
            double x = position.field_1352;
            double y = position.field_1351;
            double z = position.field_1350;
            return x >= WorldMapModule.originBottomLeft.field_1352 && x <= WorldMapModule.originTopRight.field_1352 && y >= WorldMapModule.originBottomLeft.field_1351 && y <= WorldMapModule.originTopRight.field_1351 && z >= WorldMapModule.originTopRight.field_1350 && z <= WorldMapModule.originBottomLeft.field_1350;
        }
        return false;
    }

    public static class Config
    extends Module.ModuleConfig {
        @SerialEntry
        public boolean viewMapPins = true;
        @SerialEntry
        public boolean removeItemFrameNames = true;
        @SerialEntry
        public boolean closeInvisiblePins = true;
    }
}

