/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils;

import avox.openutils.ModuleManager;
import avox.openutils.SubserverManager;
import avox.openutils.config.ConfigSystem;
import avox.openutils.modules.AdvancementRemoverModule;
import avox.openutils.modules.MarketResetModule;
import avox.openutils.modules.quests.QuestModule;
import avox.openutils.modules.stats.StatsModule;
import avox.openutils.modules.stock.StockModule;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenUtils
implements ModInitializer {
    public static final String MOD_ID = "openutils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"openutils");
    public static final ModuleManager moduleManager = new ModuleManager();
    public static final List<DelayedTask> taskQueue = new ArrayList<DelayedTask>();

    public void onInitialize() {
        moduleManager.registerModule(StatsModule.INSTANCE);
        moduleManager.registerModule(QuestModule.INSTANCE);
        moduleManager.registerModule(MarketResetModule.INSTANCE);
        moduleManager.registerModule(AdvancementRemoverModule.INSTANCE);
        moduleManager.registerModule(StockModule.INSTANCE);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            ConfigSystem.CONFIG.load();
            ConfigSystem.applyModuleConfigs();
        });
        taskQueue.add(new DelayedTask(600, () -> SubserverManager.detectSubserver(class_310.method_1551()), 1));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            moduleManager.tick(client);
            if (!taskQueue.isEmpty()) {
                ArrayList<DelayedTask> toRun = new ArrayList<DelayedTask>(taskQueue);
                for (DelayedTask task : toRun) {
                    --task.ticksLeft;
                    if (task.ticksLeft > 0) continue;
                    task.runnable.run();
                    taskQueue.remove(task);
                    if (task.specialAction != 1) continue;
                    taskQueue.add(new DelayedTask(task));
                }
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            SubserverManager.playerOn90gQopen = false;
            SubserverManager.setSubServer(SubserverManager.Subserver.UNKNOWN);
            SubserverManager.updateListeners();
        });
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> taskQueue.add(new DelayedTask(20, () -> SubserverManager.detectSubserver(client))));
    }

    public static boolean playerInSurvival() {
        return SubserverManager.getActiveSubServer().equals((Object)SubserverManager.Subserver.SURVIVAL_SPAWN) || SubserverManager.getActiveSubServer().equals((Object)SubserverManager.Subserver.SURVIVAL_PLOT) || SubserverManager.getActiveSubServer().equals((Object)SubserverManager.Subserver.SURVIVAL_RESOURCE);
    }

    public static void addToast(class_310 client, String title, String message) {
        client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, class_2561.method_30163((String)title), class_2561.method_30163((String)message)));
    }

    public static String getToggledString(String mainString, boolean enabled) {
        return String.format(mainString, enabled ? "p\u00e5slagen" : "avst\u00e4ngd");
    }

    public static class DelayedTask {
        public int totalTicks;
        public int ticksLeft;
        public int specialAction;
        public Runnable runnable;

        public DelayedTask(int ticks, Runnable runnable) {
            this(ticks, runnable, -1);
        }

        public DelayedTask(int ticks, Runnable runnable, int specialAction) {
            this.totalTicks = ticks;
            this.ticksLeft = ticks;
            this.runnable = runnable;
            this.specialAction = specialAction;
        }

        public DelayedTask(DelayedTask delayedTask) {
            this(delayedTask.totalTicks, delayedTask.runnable, delayedTask.specialAction);
        }
    }
}

