/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stock;

import avox.openutils.Module;
import avox.openutils.OpenUtils;
import avox.openutils.modules.stock.StockItem;
import avox.openutils.modules.stock.screen.StockScreen;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class StockModule
extends Module<Config> {
    public static final StockModule INSTANCE = new StockModule(class_310.method_1551());
    public static boolean screenOpen = false;
    public static final List<Integer> itemSlots = List.of(10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34);
    public static boolean ignoreNextScreen = false;
    private boolean waitingForLoad;
    private Runnable foundWaiting;
    private SlotWaitCondition waitCondition;
    private final Pattern pagePattern = Pattern.compile("Sida (\\d+)/(\\d+)");
    private int page;
    private boolean inStockPage;
    public static final ArrayList<StockItem> stockItems = new ArrayList();
    public static boolean muteSounds = false;

    private StockModule(class_310 client) {
        super("stock", 4, Config.class);
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)"openutils", (String)"stock_loading"), (context, renderTickCounter) -> {
            if (screenOpen) {
                context.method_25300(client.field_1772, "\u00a7b\u00a7lLoading...", client.method_22683().method_4486() / 2, client.method_22683().method_4502() / 2 - 4, -1);
            }
        });
    }

    @Override
    public void tick(class_310 client) {
        if (this.waitingForLoad && client.field_1755 instanceof class_465 && this.waitCondition != null && this.waitCondition.check()) {
            this.foundWaiting.run();
        }
        if (((Config)this.config).moduleEnabled && !ignoreNextScreen && !screenOpen && OpenUtils.playerInSurvival() && client.field_1755 instanceof class_465 && List.of("Dina aff\u00e4rer", "Guild-aff\u00e4rer").contains(client.field_1755.method_25440().getString())) {
            screenOpen = true;
            class_1703 screen = ((class_465)client.field_1755).method_17577();
            stockItems.clear();
            this.processStockScreen(client, screen, client.field_1755.method_25440().getString().equals("Guild-aff\u00e4rer"));
        }
    }

    private void processStockScreen(class_310 client, class_1703 screen, boolean guildScreen) {
        muteSounds = true;
        this.switchMode(client, screen, true, () -> {
            this.page = 1;
            this.loadPages(client, screen, () -> this.switchMode(client, screen, false, () -> {
                this.page = 1;
                this.loadPages(client, screen, () -> {
                    muteSounds = false;
                    client.method_1507(null);
                    client.method_1507((class_437)new StockScreen(guildScreen));
                });
            }));
        });
    }

    private void loadPages(class_310 client, class_1703 screen, Runnable onComplete) {
        Matcher matcher;
        class_9290 lore;
        int pages = 1;
        class_1799 stack = screen.method_7611(44).method_7677();
        if (stack.method_7909() == class_1802.field_8107 && (lore = (class_9290)stack.method_57353().method_58694(class_9334.field_49632)) != null && (matcher = this.pagePattern.matcher(((class_2561)lore.comp_2400().getFirst()).getString())).matches()) {
            pages = Integer.parseInt(matcher.group(2));
        }
        this.page = 1;
        this.loadNextPage(client, screen, pages, onComplete);
    }

    private void loadNextPage(class_310 client, class_1703 screen, int totalPages, Runnable onComplete) {
        this.waitingForLoad = true;
        this.waitCondition = () -> {
            int thisPage = this.getCurrentPage(screen.method_7611(44).method_7677());
            return thisPage == this.page + 1 || thisPage == -1;
        };
        this.foundWaiting = () -> {
            this.waitingForLoad = false;
            for (int i : itemSlots) {
                StockItem item;
                if (!screen.method_7611(i).method_7681() || stockItems.contains(item = new StockItem(screen.method_7611(i).method_7677(), this.inStockPage))) continue;
                stockItems.add(item);
            }
            if (this.page < totalPages) {
                client.field_1761.method_2906(client.field_1724.field_7512.field_7763, 44, 0, class_1713.field_7790, (class_1657)client.field_1724);
                ++this.page;
                this.loadNextPage(client, screen, totalPages, onComplete);
            } else {
                onComplete.run();
            }
        };
    }

    private void switchMode(class_310 client, class_1703 screen, boolean inStock, Runnable onComplete) {
        this.inStockPage = inStock;
        client.field_1761.method_2906(client.field_1724.field_7512.field_7763, 42, 0, class_1713.field_7790, (class_1657)client.field_1724);
        this.waitingForLoad = true;
        class_1799 oldStack = screen.method_7611(42).method_7677().method_7972();
        this.waitCondition = () -> {
            class_1799 newStack = screen.method_7611(42).method_7677();
            class_9290 oldLore = (class_9290)oldStack.method_57353().method_58694(class_9334.field_49632);
            class_9290 newLore = (class_9290)newStack.method_57353().method_58694(class_9334.field_49632);
            return newLore != null && !newLore.equals((Object)oldLore);
        };
        this.foundWaiting = () -> {
            this.waitingForLoad = false;
            onComplete.run();
        };
    }

    private int getCurrentPage(class_1799 stack) {
        Matcher matcher;
        if (stack.method_7960()) {
            return -1;
        }
        class_9290 lore = (class_9290)stack.method_57353().method_58694(class_9334.field_49632);
        if (lore != null && (matcher = this.pagePattern.matcher(((class_2561)lore.comp_2400().getFirst()).getString())).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    @Override
    protected Class<Config> getConfigClass() {
        return Config.class;
    }

    public Config getConfig() {
        return (Config)this.config;
    }

    @Override
    public void loadConfig(ConfigCategory.Builder category) {
        category.group(OptionGroup.createBuilder().name(class_2561.method_30163((String)"Stock Sk\u00e4rm")).option(Option.createBuilder().name(class_2561.method_30163((String)"Anv\u00e4nd Modul")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Sl\u00e5 p\u00e5 eller av tydligare stock sk\u00e4rmar.")})).binding((Object)true, () -> ((Config)this.config).moduleEnabled, val -> {
            ((Config)this.config).moduleEnabled = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Endast Tomma Standard")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Om du vill ha endast tomma som standard.")})).binding((Object)true, () -> ((Config)this.config).standardEmpty, val -> {
            ((Config)this.config).standardEmpty = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true)).build()).build());
    }

    public static class Config
    extends Module.ModuleConfig {
        @SerialEntry
        public boolean standardEmpty = true;
    }

    public static interface SlotWaitCondition {
        public boolean check();
    }
}

