/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats.screen.widgets.boxes;

import avox.openutils.modules.stats.Reordering;
import avox.openutils.modules.stats.screen.StatViewer;
import avox.openutils.modules.stats.screen.types.EntryType;
import avox.openutils.modules.stats.screen.types.ValidTypes;
import avox.openutils.modules.stats.screen.widgets.SearchBox;
import avox.openutils.modules.stats.screen.widgets.navigation.StatCategory;
import avox.openutils.modules.stats.screen.widgets.navigation.StatEntry;
import avox.openutils.modules.stats.screen.widgets.navigation.StatFolder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class PlayerTabBox {
    public SearchBox searchBox;

    public PlayerTabBox(class_310 client, int width, int height, StatViewer viewer) {
        ArrayList<String> players = new ArrayList<String>(client.method_1562().method_2880().stream().map(entry -> entry.method_2966().name()).collect(Collectors.toSet()).stream().toList());
        this.searchBox = new SearchBox(client, width, height, viewer, class_2561.method_30163((String)"Player Statistics"), this::parseJsonToCategories, this::getAPIUrl, this::verifyInput, players);
        this.searchBox.addEntry(EntryType.Checkbox, "Survival Stats");
        this.searchBox.addEntry(EntryType.Checkbox, "Creative Stats");
        this.searchBox.addEntry(EntryType.Checkbox, "MB Stats");
        this.searchBox.addEntry(EntryType.Checkbox, "UHC Stats");
        this.searchBox.addEntry(EntryType.Checkbox, "Event Stats");
        this.searchBox.addEntry(EntryType.Checkbox, "Parkour Stats");
    }

    private String getAPIUrl(String searchValue) {
        StringBuilder APIFetchString = new StringBuilder("https://api.90gqopen.se/player/?username=");
        APIFetchString.append(searchValue);
        for (int i = 2; i < this.searchBox.method_25340(); ++i) {
            if (!((SearchBox.Entry)((Object)this.searchBox.method_25396().get((int)i))).checkboxWidget.method_20372()) continue;
            APIFetchString.append("&").append(((SearchBox.Entry)((Object)this.searchBox.method_25396().get((int)i))).checkboxWidget.method_25369().getString().toLowerCase().split(" ")[0]).append("=true");
        }
        return APIFetchString.toString();
    }

    private ArrayList<StatCategory> parseJsonToCategories(JsonObject data) {
        JsonObject originalSurvival;
        if (data.get("survival") != null && data.get("survival").isJsonObject() && (originalSurvival = data.getAsJsonObject("survival")) != null) {
            data.add("survival", (JsonElement)Reordering.reorderKeys(originalSurvival, List.of("money", "level", "experience"), false));
        }
        StatCategory playerCategory = new StatCategory("Player");
        ArrayList<StatCategory> categories = new ArrayList<StatCategory>();
        for (String key : data.keySet()) {
            if (data.get(key).isJsonObject()) {
                StatCategory newCategory = new StatCategory(key);
                JsonObject inner = data.get(key).getAsJsonObject();
                if (List.of("survival", "creative", "mb").contains(key)) {
                    for (String innerKey : inner.keySet()) {
                        if (innerKey.equals("experience") && key.equals("survival")) {
                            newCategory.directStats.add(new StatEntry("progress", this.getJsonString(inner.get(innerKey))));
                        }
                        newCategory.directStats.add(new StatEntry(innerKey, this.getJsonString(inner.get(innerKey))));
                        if (!innerKey.equals("wins")) continue;
                        newCategory.directStats.add(new StatEntry("win_percent", this.getWinPercent(inner, "")));
                    }
                } else if (List.of("event", "uhc").contains(key)) {
                    for (String innerKey : inner.keySet()) {
                        List<String> prefixes = List.of("anvil_", "border_runners_", "dragons_", "infection_", "maze_", "oitc_", "paintball_", "parkour_", "red_rover_", "snow_fight_", "spleef_", "sumo_", "sg_", "tnt_run_", "season_", "alltime_");
                        Optional<String> match = prefixes.stream().filter(innerKey::startsWith).findFirst();
                        if (match.isPresent()) {
                            ArrayList<StatFolder> folder = new ArrayList<StatFolder>(newCategory.folders.stream().filter(f -> f.id.equals(match.get())).toList());
                            if (folder.isEmpty()) {
                                StatFolder newFolder = new StatFolder(match.get().substring(0, match.get().length() - 1));
                                newFolder.id = match.get();
                                newCategory.folders.add(newFolder);
                                folder.add(newFolder);
                            }
                            folder.getFirst().entries.add(new StatEntry(innerKey, this.getJsonString(inner.get(innerKey))));
                            if (!innerKey.equals(match.get() + "wins")) continue;
                            folder.getFirst().entries.add(new StatEntry(match.get() + "win_percent", this.getWinPercent(inner, match.get())));
                            continue;
                        }
                        newCategory.directStats.add(new StatEntry(innerKey, this.getJsonString(inner.get(innerKey))));
                        if (!innerKey.equals("wins")) continue;
                        newCategory.directStats.add(new StatEntry("win_percent", this.getWinPercent(inner, "")));
                    }
                } else if (key.equals("parkour")) {
                    JsonArray parkourStats = inner.get("parkourStats").getAsJsonArray();
                    newCategory.suffix = " (" + parkourStats.size() + "/" + ValidTypes.parkours.size() + " - " + String.format("%.2f%%", (double)parkourStats.size() * 100.0 / (double)ValidTypes.parkours.size()) + ")";
                    ArrayList<String> finishedParkours = new ArrayList<String>();
                    for (JsonElement map : inner.get("parkourStats").getAsJsonArray()) {
                        JsonObject obj = map.getAsJsonObject();
                        StatFolder statFolder = new StatFolder(this.getJsonString(obj.get("parkour_name")) + " (\u00a7a\u2714\u00a7r)");
                        finishedParkours.add(obj.get("parkour_name").getAsString());
                        for (String innerKey : obj.keySet()) {
                            statFolder.entries.add(new StatEntry(innerKey, this.getJsonString(obj.get(innerKey))));
                        }
                        newCategory.folders.add(statFolder);
                    }
                    for (String other : ValidTypes.parkours) {
                        if (finishedParkours.contains(other.replaceAll(" ", "_").toLowerCase())) continue;
                        StatFolder statFolder = new StatFolder(other + " (\u00a7c\u2718\u00a7r)");
                        statFolder.entries.add(new StatEntry("parkour_name", other));
                        newCategory.folders.add(statFolder);
                    }
                }
                categories.add(newCategory);
                continue;
            }
            playerCategory.directStats.add(new StatEntry(key, this.getJsonString(data.get(key))));
        }
        categories.addFirst(playerCategory);
        return categories;
    }

    private String getWinPercent(JsonObject object, String prefix) {
        int gamesPlayed = -1;
        int wins = -1;
        if (object.has(prefix + "games_played")) {
            gamesPlayed = object.get(prefix + "games_played").getAsInt();
        }
        if (object.has(prefix + "wins")) {
            wins = object.get(prefix + "wins").getAsInt();
        }
        if (wins != -1 && gamesPlayed != -1 && gamesPlayed != 0) {
            return String.format("%.3g", (double)wins / (double)gamesPlayed * 100.0) + "%";
        }
        return "?";
    }

    private String getJsonString(JsonElement elm) {
        if (elm.isJsonNull()) {
            return "N/A";
        }
        return elm.getAsString();
    }

    private boolean verifyInput(String input) {
        return input.matches("\\w{3,16}");
    }
}

