/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.quests;

import avox.openutils.OpenUtils;
import avox.openutils.modules.quests.ImageHandler;
import avox.openutils.modules.quests.Quest;
import avox.openutils.modules.quests.QuestManager;
import avox.openutils.modules.quests.QuestModule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class QuestPadRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final HashMap<String, class_1792> specialQuestEntities = new HashMap<String, class_1792>(Map.of("mj\u00f6lka_cow", class_1802.field_8103, "klipp_sheep", class_1802.field_19044));

    public static void renderHud(class_332 context, class_9779 renderTickCounter) {
        int startY;
        if (!QuestModule.renderQuestHud || QuestManager.quests.isEmpty() || !OpenUtils.playerInSurvival()) {
            return;
        }
        Matrix3x2fStack matrixStack = context.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(0.7f, 0.7f);
        float revereScale = 1.4285715f;
        Quest infoQuest = QuestManager.quests.getLast();
        String infoQuestString = infoQuest.missionAction + " " + infoQuest.prettyMission + " (" + infoQuest.completed + "/" + infoQuest.total + ")";
        int infoQuestWidth = QuestPadRenderer.client.field_1772.method_1727(infoQuestString);
        int questBoxWidth = Math.max(20 + infoQuestWidth, Math.min(QuestManager.quests.size() - 1, 8) * 18);
        int questBoxHeight = 23 + Math.ceilDiv(QuestManager.quests.size() - 1, 8) * 18;
        int startX = (int)((float)((double)client.method_22683().method_4486() - (double)questBoxWidth * 0.7) / 2.0f * revereScale);
        int y = startY = QuestModule.INSTANCE.getConfig().questPadY;
        int x = startX;
        context.method_25294(startX - 2, startY - 2, startX + questBoxWidth + 1, startY + questBoxHeight + 2, 0x4C000000);
        if (QuestManager.quests.size() > 1) {
            for (Quest quest : QuestManager.quests.subList(0, QuestManager.quests.size() - 1)) {
                if (x > startX + 128) {
                    x = startX;
                    y += 20;
                }
                QuestPadRenderer.drawQuestImage(quest, context, x, y);
                int completed = (int)(16.0 * ((double)quest.completed / (double)quest.total));
                context.method_25294(x, y + 17, x + completed, y + 18, -12915916);
                context.method_25294(x + completed, y + 17, x + 16, y + 18, -13750738);
                x += 18;
            }
            y += 21;
            x = startX;
        }
        class_327 class_3272 = QuestPadRenderer.client.field_1772;
        Objects.requireNonNull(QuestPadRenderer.client.field_1772);
        context.method_51433(class_3272, infoQuestString, x + 18, y + 8 - 9 / 2 + 1, -1, true);
        QuestPadRenderer.drawQuestImage(QuestManager.quests.getLast(), context, x, y);
        int completed = (int)((double)(18 + infoQuestWidth) * ((double)infoQuest.completed / (double)infoQuest.total));
        context.method_25294(x, y + 17, x + completed, y + 18, -12915916);
        context.method_25294(x + completed, y + 17, x + 18 + infoQuestWidth, y + 18, -13750738);
        matrixStack.popMatrix();
    }

    public static void drawQuestImage(Quest quest, class_332 context, int x, int y) {
        String[] parts = quest.missionTranslationKey.split("\\.");
        if (parts.length < 3) {
            return;
        }
        String category = parts[0];
        String name = String.join((CharSequence)"_", Arrays.copyOfRange(parts, 2, parts.length));
        if (category.equals("block") || category.equals("item")) {
            class_1792 item = category.equals("block") ? ((class_2248)class_7923.field_41175.method_63535(class_2960.method_60655((String)"minecraft", (String)name))).method_8389() : (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)name));
            if (item != null) {
                context.method_51427(new class_1799((class_1935)item), x, y);
            }
        } else if (category.equals("entity")) {
            String value = quest.missionAction.toLowerCase() + "_" + name;
            if (specialQuestEntities.containsKey(value)) {
                context.method_51427(new class_1799((class_1935)specialQuestEntities.get(value)), x, y);
            } else {
                ImageHandler imageHandler = new ImageHandler();
                imageHandler.registerQuestEntity(name);
                context.method_25290(class_10799.field_56883, ImageHandler.questEntities.getOrDefault(name, class_2960.method_60655((String)"openutils", (String)"textures/gui/unknown.png")), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }
}

