/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stats.screen.widgets;

import avox.openutils.modules.stats.InformationFetcher;
import avox.openutils.modules.stats.screen.StatViewer;
import avox.openutils.modules.stats.screen.types.EntryType;
import avox.openutils.modules.stats.screen.widgets.Slider;
import avox.openutils.modules.stats.screen.widgets.Suggestor;
import avox.openutils.modules.stats.screen.widgets.navigation.StatCategory;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_6379;

public class SearchBox
extends class_4265<Entry> {
    private final class_310 client;
    private final class_2960 SEARCH_ICON = class_2960.method_60656((String)"icon/search");
    public final StatViewer statViewer;
    private class_4185 searchButton;
    private final Function<JsonObject, ArrayList<StatCategory>> getCategories;
    private final Function<String, String> getAPIString;
    private final Function<String, Boolean> verifyInput;
    private final class_2561 title;
    public Suggestor suggestor;

    public SearchBox(class_310 client, int width, int height, StatViewer statViewer, class_2561 title, Function<JsonObject, ArrayList<StatCategory>> parseJsonFunction, Function<String, String> getAPIString, Function<String, Boolean> verifyInput, ArrayList<String> suggestions) {
        super(client, width / 3, height - 24 - 15 - 10, 34, 25);
        this.client = client;
        this.statViewer = statViewer;
        this.title = title;
        this.method_46421(10);
        this.method_25321((class_350.class_351)new Entry(EntryType.Title, ""));
        this.method_25321((class_350.class_351)new Entry(EntryType.SearchBox, ""));
        this.suggestor = new Suggestor(((Entry)this.method_25326((int)1)).textFieldWidget, client.field_1772, 100, suggestions);
        this.getCategories = parseJsonFunction;
        this.getAPIString = getAPIString;
        this.verifyInput = verifyInput;
    }

    protected int method_65507() {
        return this.field_22758;
    }

    public int method_25322() {
        return this.field_22758 - 20;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_48579(context, mouseX, mouseY, delta);
        this.suggestor.render(context, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.suggestor.render && (double)this.suggestor.startX < mouseX && (double)(this.suggestor.startX + this.suggestor.width) > mouseX && (double)this.suggestor.startY < mouseY && (double)(this.suggestor.startY + this.suggestor.height) > mouseY) {
            this.suggestor.mouseClicked();
            return false;
        }
        if (this.suggestor.textField.method_25370() && !this.suggestor.textField.method_49606()) {
            this.suggestor.textField.method_25365(false);
            this.suggestor.render = false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.suggestor.render && (double)this.suggestor.startX < mouseX && (double)(this.suggestor.startX + this.suggestor.width) > mouseX && (double)this.suggestor.startY < mouseY && (double)(this.suggestor.startY + this.suggestor.height) > mouseY) {
            this.suggestor.mouseScrolled((verticalAmount = class_3532.method_15350((double)verticalAmount, (double)-1.0, (double)1.0)) < 0.0, mouseX, mouseY);
            return false;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void addEntry(EntryType entryType, String data) {
        this.method_25321((class_350.class_351)new Entry(entryType, data));
    }

    private void search() {
        String searchText = ((Entry)this.method_25326((int)1)).textFieldWidget.method_1882().toLowerCase();
        if (!this.verifyInput.apply(searchText).booleanValue()) {
            return;
        }
        this.searchButton.field_22763 = false;
        this.statViewer.updateEntries(new ArrayList<StatCategory>());
        this.statViewer.specialMessage = "Loading...";
        this.statViewer.drawMessage = true;
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject data = InformationFetcher.fetchFromAPI(this.getAPIString.apply(searchText), this.statViewer);
                if (data != null) {
                    ArrayList<StatCategory> categories = this.getCategories.apply(data);
                    this.client.execute(() -> {
                        this.statViewer.updateEntries(categories);
                        Executors.newSingleThreadScheduledExecutor().schedule(() -> this.client.execute(() -> {
                            this.searchButton.field_22763 = true;
                        }), 3L, TimeUnit.SECONDS);
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public class Entry
    extends class_4265.class_4266<Entry> {
        public class_4286 checkboxWidget;
        private class_342 textFieldWidget;
        public Slider sliderWidget;
        private boolean titleEntry = false;

        public Entry(EntryType entryType, String data) {
            if (entryType.equals((Object)EntryType.Title)) {
                this.titleEntry = true;
            } else if (entryType.equals((Object)EntryType.Checkbox)) {
                this.checkboxWidget = class_4286.method_54787((class_2561)class_2561.method_30163((String)data), (class_327)SearchBox.this.client.field_1772).method_54788();
            } else if (entryType.equals((Object)EntryType.SearchBox)) {
                this.textFieldWidget = new class_342(SearchBox.this.client.field_1772, SearchBox.this.field_22758 - 42, 20, (class_2561)class_2561.method_43473());
                this.textFieldWidget.method_1863(newValue -> {
                    SearchBox.this.searchButton.field_22763 = SearchBox.this.verifyInput.apply((String)newValue);
                    SearchBox.this.suggestor.updateSuggestionEntries();
                });
                SearchBox.this.searchButton = class_4185.method_46430((class_2561)class_2561.method_43473(), btn -> SearchBox.this.search()).method_46434(0, 0, 20, 20).method_46431();
                SearchBox.this.searchButton.field_22763 = false;
            } else if (entryType.equals((Object)EntryType.Slider)) {
                this.sliderWidget = new Slider(0, 0, SearchBox.this.field_22758 - 20, 20, (class_2561)class_2561.method_43473(), 0.1836734693877551);
            }
        }

        public List<? extends class_6379> method_37025() {
            ArrayList<Object> children = new ArrayList<Object>();
            if (this.checkboxWidget != null) {
                children.add(this.checkboxWidget);
            }
            if (this.textFieldWidget != null) {
                children.add(this.textFieldWidget);
                children.add(SearchBox.this.searchButton);
            }
            if (this.sliderWidget != null) {
                children.add((Object)this.sliderWidget);
            }
            return children;
        }

        public List<? extends class_364> method_25396() {
            ArrayList<Object> children = new ArrayList<Object>();
            if (this.checkboxWidget != null) {
                children.add(this.checkboxWidget);
            }
            if (this.textFieldWidget != null) {
                children.add(this.textFieldWidget);
                children.add(SearchBox.this.searchButton);
            }
            if (this.sliderWidget != null) {
                children.add((Object)this.sliderWidget);
            }
            return children;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.titleEntry) {
                class_327 class_3272 = SearchBox.this.client.field_1772;
                class_2561 class_25612 = SearchBox.this.title;
                int n = 15 + entryWidth / 2;
                int n2 = y + entryHeight / 2;
                Objects.requireNonNull(SearchBox.this.client.field_1772);
                context.method_27534(class_3272, class_25612, n, n2 - 9 / 2, -1);
            }
            if (this.checkboxWidget != null) {
                this.checkboxWidget.method_48229(15, y);
                this.checkboxWidget.method_25394(context, mouseX, mouseY, tickDelta);
            }
            if (this.textFieldWidget != null) {
                this.textFieldWidget.method_48229(15, y);
                this.textFieldWidget.method_25394(context, mouseX, mouseY, tickDelta);
                SearchBox.this.searchButton.method_48229(15 + entryWidth - 20, y);
                SearchBox.this.searchButton.method_25394(context, mouseX, mouseY, tickDelta);
                context.method_52706(class_10799.field_56883, SearchBox.this.SEARCH_ICON, 15 + entryWidth - 17, y + 4, 12, 12);
            }
            if (this.sliderWidget != null) {
                this.sliderWidget.method_48229(15, y);
                this.sliderWidget.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }
}

