/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.stock.screen;

import avox.openutils.modules.stats.FormatTools;
import avox.openutils.modules.stock.StockItem;
import avox.openutils.modules.stock.StockModule;
import avox.openutils.modules.stock.screen.StockScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_8052;

public class FilterManager {
    public static List<StockItem> filterItems(String search) {
        HashMap filterOptions = StockScreen.options.get("Filtrering");
        List<StockItem> filteredItems = !search.isEmpty() ? StockModule.stockItems.stream().filter(item -> item.name.getString().toLowerCase().contains(search)).toList() : new ArrayList<StockItem>(StockModule.stockItems);
        if (((Boolean)filterOptions.get("I Lager")).booleanValue()) {
            filteredItems = filteredItems.stream().filter(item -> item.inStock).toList();
        } else if (((Boolean)filterOptions.get("Tomma")).booleanValue()) {
            filteredItems = filteredItems.stream().filter(item -> !item.inStock).toList();
        }
        HashMap itemFilterOptions = StockScreen.options.get("Item Filtrering");
        ArrayList<StockItem> finalFilteredItems = new ArrayList<StockItem>();
        if (itemFilterOptions.getOrDefault("B\u00f6cker", false).booleanValue()) {
            finalFilteredItems.addAll(filteredItems.stream().filter(item -> item.itemStack.item == class_1802.field_8598).toList());
        }
        if (itemFilterOptions.getOrDefault("Trims", false).booleanValue()) {
            finalFilteredItems.addAll(filteredItems.stream().filter(item -> item.itemStack.item instanceof class_8052).toList());
        }
        if (itemFilterOptions.getOrDefault("Potions", false).booleanValue()) {
            finalFilteredItems.addAll(filteredItems.stream().filter(item -> List.of(class_1802.field_8574, class_1802.field_8150, class_1802.field_8436).contains(item.itemStack.item)).toList());
        }
        if (itemFilterOptions.getOrDefault("Annat", false).booleanValue()) {
            finalFilteredItems.addAll(filteredItems.stream().filter(item -> item.itemStack.item != class_1802.field_8598 && !(item.itemStack.item instanceof class_8052) && !List.of(class_1802.field_8574, class_1802.field_8150, class_1802.field_8436).contains(item.itemStack.item)).toList());
        }
        return finalFilteredItems;
    }

    public static List<StockItem> sortItems(List<StockItem> filteredItems) {
        HashMap sortingOptions = StockScreen.options.get("Sortering");
        if (((Boolean)sortingOptions.get("Lager")).booleanValue()) {
            filteredItems.sort((a, b) -> Integer.compare(b.storage, a.storage));
        } else if (((Boolean)sortingOptions.get("Tj\u00e4nat")).booleanValue()) {
            filteredItems.sort((a, b) -> Integer.compare(b.earned, a.earned));
        } else if (((Boolean)sortingOptions.get("Flest K\u00f6pta")).booleanValue()) {
            filteredItems.sort((a, b) -> Integer.compare(b.bought, a.bought));
        } else if (((Boolean)sortingOptions.get("Flest S\u00e5lda")).booleanValue()) {
            filteredItems.sort((a, b) -> Integer.compare(b.transactions - b.bought, a.transactions - a.bought));
        } else if (((Boolean)sortingOptions.get("Antal Transaktioner")).booleanValue()) {
            filteredItems.sort((a, b) -> Integer.compare(b.transactions, a.transactions));
        } else if (((Boolean)sortingOptions.get("Datum Skapat")).booleanValue()) {
            filteredItems.sort((a, b) -> b.created.compareTo(a.created));
        }
        return filteredItems;
    }

    public static class_2561 getInfoText(StockItem stockItem) {
        HashMap sortingOptions = StockScreen.options.get("Sortering");
        if (((Boolean)sortingOptions.get("Lager")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eLager:\u00a7f " + stockItem.storage + " st"));
        }
        if (((Boolean)sortingOptions.get("Tj\u00e4nat")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eTj\u00e4nat:\u00a7f " + FormatTools.formatNumber(stockItem.earned) + " kr"));
        }
        if (((Boolean)sortingOptions.get("Flest K\u00f6pta")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eTotalt k\u00f6pta:\u00a7f " + stockItem.bought + " st"));
        }
        if (((Boolean)sortingOptions.get("Flest S\u00e5lda")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eTotalt s\u00e5lda:\u00a7f " + (stockItem.transactions - stockItem.bought) + " st"));
        }
        if (((Boolean)sortingOptions.get("Antal Transaktioner")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eAntal transaktioner:\u00a7f " + stockItem.transactions + " st"));
        }
        if (((Boolean)sortingOptions.get("Datum Skapat")).booleanValue()) {
            return class_2561.method_30163((String)("\u00a7eSkapades:\u00a7f " + String.valueOf(stockItem.created)));
        }
        return class_2561.method_30163((String)"Ok\u00e4nd");
    }
}

