/*
 * Decompiled with CFR 0.152.
 */
package avox.openutils.modules.worldmap;

import avox.openutils.OpenUtils;
import avox.openutils.modules.stats.screen.widgets.Suggestor;
import avox.openutils.modules.worldmap.BannerManager;
import avox.openutils.modules.worldmap.SearchField;
import avox.openutils.modules.worldmap.WorldMapModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class SearchScreen
extends class_437 {
    private final Consumer<class_243> onComplete;
    private SearchField widgetX;
    private SearchField widgetZ;
    private SearchField bannerInput;
    private Suggestor suggestor;
    private class_4185 searchButton;
    private class_4185 coordTabBtn;
    private class_4185 mapIdTabBtn;
    private class_4185 bannerBtn;
    private static class_241 coordSearch;
    private static class_241 mapSearch;
    private static Tab activeTab;

    public SearchScreen(Consumer<class_243> onComplete) {
        super(class_2561.method_30163((String)"Search Screen"));
        this.onComplete = onComplete;
    }

    protected void method_25426() {
        super.method_25426();
        this.widgetX = new SearchField(this.field_22787.field_1772, this.field_22789 / 3, 20, (class_2561)class_2561.method_43473());
        this.widgetX.method_1863(text -> this.fieldChanged((String)text, this.widgetX));
        this.widgetX.method_1868(-5752782);
        this.widgetX.method_48229(this.field_22789 / 2 - 2 - this.field_22789 / 3, this.field_22790 / 2);
        this.widgetX.method_1862(!activeTab.equals((Object)Tab.BANNER));
        this.widgetX.method_1880(6);
        this.method_37063((class_364)this.widgetX);
        this.widgetZ = new SearchField(this.field_22787.field_1772, this.field_22789 / 3, 20, (class_2561)class_2561.method_43473());
        this.widgetZ.method_1863(text -> this.fieldChanged((String)text, this.widgetZ));
        this.widgetZ.method_1868(-5752782);
        this.widgetZ.method_48229(this.field_22789 / 2 + 2, this.field_22790 / 2);
        this.widgetZ.method_1862(!activeTab.equals((Object)Tab.BANNER));
        this.widgetZ.method_1880(6);
        this.method_37063((class_364)this.widgetZ);
        this.bannerInput = new SearchField(this.field_22787.field_1772, this.field_22789 / 2, 20, (class_2561)class_2561.method_43473());
        this.bannerInput.method_48229(this.field_22789 / 4, this.field_22790 / 2);
        this.bannerInput.method_1862(activeTab.equals((Object)Tab.BANNER));
        this.bannerInput.method_1863(newValue -> {
            this.fieldChanged((String)newValue, this.bannerInput);
            this.suggestor.updateSuggestionEntries();
        });
        this.method_37063((class_364)this.bannerInput);
        this.suggestor = new Suggestor(this.bannerInput, this.field_22787.field_1772, 100, new ArrayList<String>(BannerManager.banners.stream().map(BannerManager.Banner::name).toList()));
        int buttonWidth = (this.field_22789 - 40) / 3;
        this.coordTabBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Koordinater"), btn -> this.tabChanged(Tab.COORD)).method_46434(20, this.field_22790 / 2 - 50, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.coordTabBtn);
        this.coordTabBtn.field_22763 = !activeTab.equals((Object)Tab.COORD);
        this.mapIdTabBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Map ID"), btn -> this.tabChanged(Tab.MAP)).method_46434(20 + buttonWidth, this.field_22790 / 2 - 50, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.mapIdTabBtn);
        this.mapIdTabBtn.field_22763 = !activeTab.equals((Object)Tab.MAP);
        this.bannerBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Banner"), btn -> this.tabChanged(Tab.BANNER)).method_46434(20 + buttonWidth * 2, this.field_22790 / 2 - 50, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.bannerBtn);
        this.bannerBtn.field_22763 = !activeTab.equals((Object)Tab.BANNER);
        class_4185 eraseButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Rensa och st\u00e4ng"), btn -> this.erase()).method_46434(this.field_22789 / 4, this.field_22790 / 2 + 50, this.field_22789 / 4, 20).method_46431();
        this.method_37063((class_364)eraseButton);
        this.searchButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"Klar"), btn -> this.search(this.field_22787, this.widgetX, this.widgetZ)).method_46434(this.field_22789 / 2 + 2, this.field_22790 / 2 + 50, this.field_22789 / 4, 20).method_46431();
        this.method_37063((class_364)this.searchButton);
        if (!activeTab.equals((Object)Tab.BANNER)) {
            this.setTextSilent(this.widgetX, String.valueOf(activeTab.equals((Object)Tab.COORD) ? (coordSearch == null ? "" : Integer.valueOf((int)SearchScreen.coordSearch.field_1343)) : (mapSearch == null ? "" : Integer.valueOf((int)SearchScreen.mapSearch.field_1343))));
            this.setTextSilent(this.widgetZ, String.valueOf(activeTab.equals((Object)Tab.COORD) ? (coordSearch == null ? "" : Integer.valueOf((int)SearchScreen.coordSearch.field_1342)) : (mapSearch == null ? "" : Integer.valueOf((int)SearchScreen.mapSearch.field_1342))));
            this.fieldChanged(this.widgetX.method_1882(), this.widgetX);
            this.fieldChanged(this.widgetZ.method_1882(), this.widgetZ);
        } else {
            this.fieldChanged(this.bannerInput.method_1882(), this.bannerInput);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_25300(this.field_22793, activeTab.equals((Object)Tab.COORD) ? "Vilka koordinater?" : (activeTab.equals((Object)Tab.MAP) ? "Vilket map ID?" : "V\u00e4lj en banner!"), this.field_22789 / 2, this.field_22790 / 2 - 20, -1);
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        if (activeTab.equals((Object)Tab.BANNER)) {
            this.suggestor.render(context, mouseX, mouseY);
        } else {
            class_5250 class_52502 = class_2561.method_43470((String)"X").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
            int n = this.field_22789 / 2 - 14;
            int n2 = this.field_22790 / 2 + 10;
            Objects.requireNonNull(this.field_22793);
            context.method_51439(this.field_22793, (class_2561)class_52502, n, n2 - 9 / 2, -1, true);
            class_5250 class_52503 = class_2561.method_43470((String)"Z").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
            int n3 = this.field_22789 / 2 + this.field_22789 / 3 - 10;
            int n4 = this.field_22790 / 2 + 10;
            Objects.requireNonNull(this.field_22793);
            context.method_51439(this.field_22793, (class_2561)class_52503, n3, n4 - 9 / 2, -1, true);
        }
    }

    private void tabChanged(Tab pressed) {
        if (pressed.equals((Object)Tab.COORD)) {
            coordSearch = this.getValue(this.widgetX, this.widgetZ);
        } else if (pressed.equals((Object)Tab.MAP)) {
            mapSearch = this.getValue(this.widgetX, this.widgetZ);
        }
        activeTab = pressed;
        this.coordTabBtn.field_22763 = !activeTab.equals((Object)Tab.COORD);
        this.mapIdTabBtn.field_22763 = !activeTab.equals((Object)Tab.MAP);
        boolean bl = this.bannerBtn.field_22763 = !activeTab.equals((Object)Tab.BANNER);
        if (!activeTab.equals((Object)Tab.BANNER)) {
            this.widgetX.method_1862(true);
            this.widgetZ.method_1862(true);
            this.bannerInput.method_1862(false);
            this.setTextSilent(this.widgetX, String.valueOf(activeTab.equals((Object)Tab.COORD) ? (coordSearch == null ? "" : Integer.valueOf((int)SearchScreen.coordSearch.field_1343)) : (mapSearch == null ? "" : Integer.valueOf((int)SearchScreen.mapSearch.field_1343))));
            this.setTextSilent(this.widgetZ, String.valueOf(activeTab.equals((Object)Tab.COORD) ? (coordSearch == null ? "" : Integer.valueOf((int)SearchScreen.coordSearch.field_1342)) : (mapSearch == null ? "" : Integer.valueOf((int)SearchScreen.mapSearch.field_1342))));
            this.fieldChanged(this.widgetX.method_1882(), this.widgetX);
            this.fieldChanged(this.widgetZ.method_1882(), this.widgetZ);
        } else {
            this.widgetX.method_1862(false);
            this.widgetZ.method_1862(false);
            this.bannerInput.method_1862(true);
            this.fieldChanged(this.bannerInput.method_1882(), this.bannerInput);
        }
    }

    private void fieldChanged(String text, SearchField widget) {
        if (activeTab.equals((Object)Tab.BANNER)) {
            this.searchButton.field_22763 = !BannerManager.banners.stream().filter(banner -> text.equals(banner.name())).toList().isEmpty();
        } else {
            if (text.matches("-?\\d{1,5}")) {
                if (activeTab.equals((Object)Tab.COORD)) {
                    coordSearch = this.getValue(this.widgetX, this.widgetZ);
                } else {
                    mapSearch = this.getValue(this.widgetX, this.widgetZ);
                }
                int number = Integer.parseInt(text);
                if (activeTab.equals((Object)Tab.COORD) ? -10000 <= number && number <= 10000 : 0 <= number && number <= 39) {
                    widget.method_1868(-1);
                    widget.error = false;
                    this.searchButton.field_22763 = this.allowedCoords();
                    return;
                }
            }
            widget.method_1868(-5752782);
            widget.error = true;
            this.searchButton.field_22763 = this.allowedCoords();
        }
    }

    private class_241 getValue(SearchField x, SearchField z) {
        if (x != null && z != null) {
            return new class_241(x.method_1882().isEmpty() ? 0.0f : (float)Integer.parseInt(x.method_1882()), z.method_1882().isEmpty() ? 0.0f : (float)Integer.parseInt(z.method_1882()));
        }
        return null;
    }

    private void search(class_310 client, SearchField widgetX, SearchField widgetZ) {
        if (activeTab.equals((Object)Tab.COORD)) {
            double worldSizeHalf = 10000.0;
            double mapArtSize = 512.0;
            double mapIdX = (Double.parseDouble(widgetX.method_1882()) + 304.0) / mapArtSize - -worldSizeHalf / mapArtSize;
            double mapIdZ = worldSizeHalf / mapArtSize - (Double.parseDouble(widgetZ.method_1882()) + 336.0) / mapArtSize;
            this.onComplete.accept(new class_243(WorldMapModule.originBottomLeftMap.field_1352 + mapIdX, 58.0, WorldMapModule.originBottomLeftMap.field_1350 - mapIdZ));
        } else if (activeTab.equals((Object)Tab.MAP)) {
            this.onComplete.accept(new class_243(WorldMapModule.originBottomLeftMap.field_1352 + (double)Integer.parseInt(widgetX.method_1882()) + 0.5, 58.0, WorldMapModule.originBottomLeftMap.field_1350 - (double)Integer.parseInt(widgetZ.method_1882()) + 0.5));
        } else {
            List<BannerManager.Banner> banners = BannerManager.banners.stream().filter(b -> b.name().equals(this.bannerInput.method_1882())).toList();
            if (!banners.isEmpty()) {
                try {
                    BannerManager.Banner banner = banners.getFirst();
                    String[] parts = banner.map().split(",");
                    int x = Integer.parseInt(parts[0].trim());
                    int z = Integer.parseInt(parts[1].trim());
                    this.onComplete.accept(new class_243(WorldMapModule.originBottomLeftMap.field_1352 + (double)x + (double)(banner.x() + 128) / 255.0, 58.0, WorldMapModule.originBottomLeftMap.field_1350 - (double)z + (double)(banner.y() + 128) / 255.0));
                }
                catch (Exception e) {
                    OpenUtils.addToast(client, "\u00a7cWorldMap Error!", "Ok\u00e4nt error!");
                }
            } else {
                OpenUtils.addToast(client, "\u00a7cWorldMap Error!", "Flera banners hittades!");
            }
        }
        this.method_25419();
    }

    private void erase() {
        WorldMapModule.arrow = null;
        if (activeTab.equals((Object)Tab.COORD)) {
            coordSearch = null;
        } else if (activeTab.equals((Object)Tab.MAP)) {
            mapSearch = null;
        }
        this.method_25419();
    }

    private void setTextSilent(SearchField field, String text) {
        Consumer oldListener = field.field_2088;
        field.method_1863(s -> {});
        field.method_1852(text);
        field.method_1863(oldListener);
    }

    private boolean allowedCoords() {
        return !this.widgetX.error && !this.widgetZ.error;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.suggestor.render && (double)this.suggestor.startX < mouseX && (double)(this.suggestor.startX + this.suggestor.width) > mouseX && (double)this.suggestor.startY < mouseY && (double)(this.suggestor.startY + this.suggestor.height) > mouseY) {
            this.suggestor.mouseClicked();
            return false;
        }
        if (this.suggestor.textField.method_25370() && !this.suggestor.textField.method_49606()) {
            this.suggestor.textField.method_25365(false);
            this.suggestor.render = false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.suggestor.render && (double)this.suggestor.startX < mouseX && (double)(this.suggestor.startX + this.suggestor.width) > mouseX && (double)this.suggestor.startY < mouseY && (double)(this.suggestor.startY + this.suggestor.height) > mouseY) {
            this.suggestor.mouseScrolled((verticalAmount = class_3532.method_15350((double)verticalAmount, (double)-1.0, (double)1.0)) < 0.0, mouseX, mouseY);
            return false;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    static {
        activeTab = Tab.COORD;
    }

    public static enum Tab {
        COORD,
        MAP,
        BANNER;

    }
}

