/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.ui.pages;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.api.factory.MoveLearnerFactoryUI;
import com.vecoo.movelearner.config.GuiConfig;
import com.vecoo.movelearner.config.ServerConfig;
import com.vecoo.movelearner.ui.Buttons;
import com.vecoo.movelearner.ui.pages.AcceptPage;
import com.vecoo.movelearner.ui.pages.SelectPokemonPage;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import com.vecoo.movelearner.util.Utils;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectMovePage
extends SimpleGui {
    private final ServerConfig CONFIG = MoveLearner.getInstance().getConfig();
    private final GuiConfig GUI_CONFIG = MoveLearner.getInstance().getGuiConfig();
    private final Pokemon pokemon;
    private final MoveFilter filter;
    private final String search;
    private final List<MoveTemplate> moves;
    private final int page;
    private final int totalPages;

    public SelectMovePage(@NotNull class_3222 player, @NotNull Pokemon pokemon, @NotNull MoveFilter filter, @NotNull String search, int page) {
        super(class_3917.field_17327, player, false);
        this.pokemon = pokemon;
        this.filter = filter;
        this.search = search;
        this.page = Math.max(1, page);
        this.moves = this.getFilteredAndSearchMoves();
        this.totalPages = Math.max(1, (this.moves.size() + 44) / 45);
        this.setTitle(UtilChat.formatMessage((String)this.GUI_CONFIG.getSelectMoveTitle()));
        this.setLockPlayerInventory(true);
        int start = (page - 1) * 45;
        int end = Math.min(start + 45, this.moves.size());
        this.fillMoveSlots(this.moves.subList(start, end));
        this.fillAllSlotsWithFiller();
        this.addPreviousPageButton();
        this.addFilterButton();
        this.addBackButton();
        this.addNextPageButton();
    }

    @Nullable
    public Pokemon getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public MoveFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public String getSearch() {
        return this.search;
    }

    @NotNull
    public List<MoveTemplate> getMoves() {
        return this.moves;
    }

    public int getPage() {
        return this.page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    private void openPage() {
        MoveLearnerFactoryUI.openPage(this.player, this.pokemon, new SelectMovePage(this.player, this.pokemon, this.filter, this.search, this.page));
    }

    private void openPage(int newPage) {
        MoveLearnerFactoryUI.openPage(this.player, this.pokemon, new SelectMovePage(this.player, this.pokemon, this.filter, this.search, newPage));
    }

    private void openPage(@NotNull MoveFilter filter) {
        MoveLearnerFactoryUI.openPage(this.player, this.pokemon, new SelectMovePage(this.player, this.pokemon, filter, "", 1));
    }

    private void openPage(@NotNull String search) {
        MoveLearnerFactoryUI.openPage(this.player, this.pokemon, new SelectMovePage(this.player, this.pokemon, MoveFilter.ALL, search, 1));
    }

    @NotNull
    private List<MoveTemplate> getFilteredAndSearchMoves() {
        return this.getFilteredMoves(this.pokemon.getForm().getMoves()).stream().filter(move -> this.search.isEmpty() || move.getName().toLowerCase().startsWith(this.search.toLowerCase())).collect(Collectors.toList());
    }

    private void fillAllSlotsWithFiller() {
        if (this.GUI_CONFIG.isFillerChoiceMovesUI()) {
            IntStream.rangeClosed(45, 53).forEach(i -> this.setSlot(i, (GuiElementBuilderInterface)Buttons.getFillerButton()));
        }
    }

    private void fillMoveSlots(@NotNull List<MoveTemplate> moves) {
        int slot = 0;
        for (MoveTemplate move : moves) {
            this.setSlot(slot++, Buttons.getMoveButton(this.pokemon, move).setCallback(() -> MoveLearnerFactoryUI.openPage(this.player, this.pokemon, new AcceptPage(this.player, move, this))));
        }
    }

    private void addPreviousPageButton() {
        if (this.page > 1) {
            this.setSlot(45, Buttons.getPreviousPageButton().setCallback(() -> this.openPage(this.page - 1)));
        }
    }

    private void addNextPageButton() {
        if (this.page < this.totalPages) {
            this.setSlot(53, Buttons.getNextPageButton().setCallback(() -> this.openPage(this.page + 1)));
        }
    }

    private void addFilterButton() {
        this.setSlot(46, Buttons.getFilterButton(this.filter).setCallback(clickType -> {
            if (clickType.isRight) {
                this.changeFilterUp(this.filter);
            } else if (clickType.isLeft) {
                this.changeFilterDown(this.filter);
            }
        }));
    }

    private void addBackButton() {
        this.setSlot(49, Buttons.getBackButton().setCallback(() -> new SelectPokemonPage(this.player).openForce()));
    }

    private void changeFilterDown(@NotNull MoveFilter filter) {
        List<MoveFilter> order = this.getFilterOrder();
        this.openPage(order.get((order.indexOf((Object)filter) + 1) % order.size()));
    }

    private void changeFilterUp(@NotNull MoveFilter filter) {
        List<MoveFilter> order = this.getFilterOrder();
        this.openPage(order.get((order.indexOf((Object)filter) - 1 + order.size()) % order.size()));
    }

    @NotNull
    private List<MoveFilter> getFilterOrder() {
        ArrayList<MoveFilter> order = new ArrayList<MoveFilter>();
        order.add(MoveFilter.ALL);
        order.add(MoveFilter.LEVEL);
        order.add(MoveFilter.TM);
        if (this.CONFIG.isLegacyMove()) {
            order.add(MoveFilter.LEGACY);
        }
        order.add(MoveFilter.TUTOR);
        if (this.CONFIG.isSpecialMove()) {
            order.add(MoveFilter.SPECIAL);
        }
        if (this.CONFIG.isEggMove()) {
            order.add(MoveFilter.EGG);
        }
        return order;
    }

    @NotNull
    private Set<MoveTemplate> getFilteredMoves(@NotNull Learnset moves) {
        return switch (this.filter) {
            default -> throw new MatchException(null, null);
            case MoveFilter.ALL -> Utils.getAllMoves(moves).stream().filter(move -> this.CONFIG.isEggMove() || !moves.getEggMoves().contains(move)).filter(move -> this.CONFIG.isLegacyMove() || !moves.getLegacyMoves().contains(move)).filter(move -> this.CONFIG.isSpecialMove() || !moves.getSpecialMoves().contains(move)).filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.LEVEL -> moves.getAllLegalMoves().stream().filter(move -> moves.getLevelUpMoves().values().stream().anyMatch(list -> list.contains(move))).filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.TM -> moves.getTmMoves().stream().filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.LEGACY -> moves.getLegacyMoves().stream().filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.TUTOR -> moves.getTutorMoves().stream().filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.SPECIAL -> moves.getSpecialMoves().stream().filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
            case MoveFilter.EGG -> moves.getEggMoves().stream().filter(move -> !this.CONFIG.isHideAlreadyMove() || !Utils.isLearnedMove(this.pokemon, move)).collect(Collectors.toSet());
        };
    }
}

