/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.ui.pages;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.api.factory.MoveLearnerFactoryUI;
import com.vecoo.movelearner.config.GuiConfig;
import com.vecoo.movelearner.ui.Buttons;
import com.vecoo.movelearner.ui.pages.SelectMovePage;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.stream.IntStream;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectPokemonPage
extends SimpleGui {
    private final GuiConfig GUI_CONFIG = MoveLearner.getInstance().getGuiConfig();

    public SelectPokemonPage(@NotNull class_3222 player) {
        super(class_3917.field_17326, player, false);
        this.setTitle(UtilChat.formatMessage((String)this.GUI_CONFIG.getSelectPokemonTitle()));
        this.setLockPlayerInventory(true);
        this.fillAllSlotsWithFiller();
        this.fillPokemonSlots();
        this.addInformationButton();
    }

    private void fillPokemonSlots() {
        int startSlot = 10;
        for (int i = 0; i < 6; ++i) {
            if (startSlot == 13) {
                // empty if block
            }
            int n = ++startSlot;
            ++startSlot;
            this.setSlot(n, (GuiElementBuilderInterface)this.getPokemonSlotButton(Cobblemon.INSTANCE.getStorage().getParty(this.player).get(i)));
        }
    }

    private void fillAllSlotsWithFiller() {
        if (this.GUI_CONFIG.isFillerChoicePokemonUI()) {
            IntStream.rangeClosed(0, 26).forEach(i -> this.setSlot(i, (GuiElementBuilderInterface)Buttons.getFillerButton()));
        }
    }

    private void addInformationButton() {
        if (this.GUI_CONFIG.isInformationUI()) {
            this.setSlot(13, (GuiElementBuilderInterface)Buttons.getInformationButton());
        }
    }

    @NotNull
    private GuiElementBuilder getPokemonSlotButton(@Nullable Pokemon pokemon) {
        if (pokemon == null) {
            return Buttons.getEmptyPokemonButton();
        }
        return (GuiElementBuilder)Buttons.getPokemonButton(pokemon).setCallback(() -> MoveLearnerFactoryUI.openPage(this.player, pokemon, new SelectMovePage(this.player, pokemon, MoveFilter.ALL, "", 1)));
    }
}

