/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.api.factory;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.item.UtilItem;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.config.LocaleConfig;
import com.vecoo.movelearner.ui.pages.AcceptPage;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import com.vecoo.movelearner.util.Utils;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveLearnerFactoryUI {
    public static void openPage(@NotNull class_3222 player, @Nullable Pokemon pokemon, @NotNull SimpleGui page) {
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (pokemon == null || partyStore.get(pokemon.getUuid()) == null) {
            player.method_43496(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getNotPokemon()));
            GuiHelpers.close((class_3222)player);
            return;
        }
        page.openForce();
    }

    public static void learnMoveItem(@NotNull class_3222 player, @NotNull AcceptPage page) {
        LocaleConfig localeConfig = MoveLearner.getInstance().getLocale();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon pokemon = page.getPreviousPage().getPokemon();
        if (pokemon == null || partyStore.get(pokemon.getUuid()) == null) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getNotPokemon()));
            GuiHelpers.close((class_3222)player);
            return;
        }
        MoveSet moveset = pokemon.getMoveSet();
        if (Utils.isLearnedMove(pokemon, page.getMove())) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getAlreadyMove().replace("%pokemon%", pokemon.getDisplayName(false).getString()).replace("%move%", page.getMove().getDisplayName().getString())));
            page.getPreviousPage().openForce();
            return;
        }
        class_1799 itemStack = UtilItem.parseItemCustomModel((String)MoveLearner.getInstance().getConfig().getItemPriceMove());
        if (itemStack.method_7960()) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getNotValidItem()));
            GuiHelpers.close((class_3222)player);
            return;
        }
        int price = Utils.getMovePrice(pokemon, page.getMove());
        if (!MoveLearnerFactoryUI.buyItem(player, pokemon, page.getMove(), itemStack, price)) {
            return;
        }
        if (!moveset.hasSpace()) {
            pokemon.getBenchedMoves().add(new BenchedMove(page.getMove(), 0));
        } else {
            moveset.add(page.getMove().create());
        }
        page.getPreviousPage().openForce();
        if (price > 0) {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getBuyMoveItem().replace("%move%", page.getMove().getDisplayName().getString()).replace("%pokemon%", pokemon.getDisplayName(false).getString()).replace("%amount%", String.valueOf(price))));
        } else {
            player.method_43496(UtilChat.formatMessage((String)localeConfig.getBuyMoveFree().replace("%move%", page.getMove().getDisplayName().getString()).replace("%pokemon%", pokemon.getDisplayName(false).getString())));
        }
    }

    public static void learnMoveItem(@NotNull class_3222 player, @NotNull MoveTemplate move, @NotNull Pokemon pokemon, @NotNull MoveFilter filter, @NotNull String search, int price) {
        MoveLearnerFactoryUI.learnMoveItem(player, new AcceptPage(player, move, pokemon, filter, search, price));
    }

    private static boolean buyItem(@NotNull class_3222 player, @NotNull Pokemon pokemon, @NotNull MoveTemplate move, @NotNull class_1799 itemStack, int amount) {
        if (MoveLearner.getInstance().getConfig().isItemStrongTags()) {
            if (UtilPlayer.countItemStack((class_3222)player, (class_1799)itemStack) < amount) {
                MoveLearnerFactoryUI.sendNotItemsMessage(player, amount);
                return false;
            }
            UtilPlayer.removeItemStack((class_3222)player, (class_1799)itemStack, (int)amount);
        } else {
            if (UtilPlayer.countItemStackTag((class_3222)player, (class_1799)itemStack, (class_9331)class_9334.field_49637) < amount) {
                MoveLearnerFactoryUI.sendNotItemsMessage(player, amount);
                return false;
            }
            UtilPlayer.removeItemStackTag((class_3222)player, (class_1799)itemStack, (class_9331)class_9334.field_49637, (int)amount);
        }
        return true;
    }

    private static void sendNotItemsMessage(@NotNull class_3222 player, int amount) {
        player.method_43496(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getNotItems().replace("%amount%", String.valueOf(amount))));
        GuiHelpers.close((class_3222)player);
    }
}

