/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.ui;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.config.GuiConfig;
import com.vecoo.movelearner.config.ServerConfig;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import com.vecoo.movelearner.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ButtonLore {
    @NotNull
    public static List<class_2561> getPokemonMovesLore(@NotNull Pokemon pokemon) {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(UtilChat.formatMessage((String)guiConfig.getMovesLore()));
        for (Move move : pokemon.getMoveSet().getMoves()) {
            class_5250 moveLore = UtilChat.formatMessage((String)guiConfig.getMoveSymbol()).method_27661().method_10852((class_2561)move.getDisplayName());
            lore.add((class_2561)moveLore);
        }
        return lore;
    }

    @NotNull
    public static List<class_2561> getMoveLore(@NotNull Pokemon pokemon, @NotNull MoveTemplate move) {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        class_5250 type = move.getElementalType().getDisplayName().method_27661().method_54663(move.getElementalType().getHue());
        class_5250 typeLine = UtilChat.formatMessage((String)guiConfig.getTypeLore()).method_27661().method_10852((class_2561)type).method_27693(ButtonLore.getCategoryIcon(move));
        lore.add((class_2561)typeLine);
        lore.add(UtilChat.formatMessage((String)guiConfig.getPowerLore().replace("%amount%", Utils.getStatMoveFormat(move.getPower()))));
        lore.add(UtilChat.formatMessage((String)guiConfig.getAccuracyLore().replace("%amount%", Utils.getStatMoveFormat(move.getAccuracy()))));
        lore.add(UtilChat.formatMessage((String)guiConfig.getPpLore().replace("%amount%", String.valueOf(move.getPp())).replace("%maxAmount%", String.valueOf(move.getMaxPp()))));
        int price = Utils.getMovePrice(pokemon, move);
        if (price > 0) {
            lore.add(UtilChat.formatMessage((String)guiConfig.getPriceItemLore().replace("%amount%", String.valueOf(price))));
        } else {
            lore.add(UtilChat.formatMessage((String)guiConfig.getPriceFreeLore()));
        }
        return lore;
    }

    @NotNull
    public static List<class_2561> getFilterLore(@NotNull MoveFilter filter) {
        ServerConfig config = MoveLearner.getInstance().getConfig();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(ButtonLore.createFilterLine("All", filter == MoveFilter.ALL));
        lore.add(ButtonLore.createFilterLine("Level", filter == MoveFilter.LEVEL));
        lore.add(ButtonLore.createFilterLine("TM", filter == MoveFilter.TM));
        if (config.isLegacyMove()) {
            lore.add(ButtonLore.createFilterLine("Legacy", filter == MoveFilter.LEGACY));
        }
        lore.add(ButtonLore.createFilterLine("Tutor", filter == MoveFilter.TUTOR));
        if (config.isSpecialMove()) {
            lore.add(ButtonLore.createFilterLine("Special", filter == MoveFilter.SPECIAL));
        }
        if (config.isEggMove()) {
            lore.add(ButtonLore.createFilterLine("Egg", filter == MoveFilter.EGG));
        }
        return lore;
    }

    @NotNull
    private static String getCategoryIcon(@NotNull MoveTemplate Move2) {
        return switch (Move2.getDamageCategory().getName()) {
            case "PHYSICAL" -> " \u2694";
            case "SPECIAL" -> " \u26a1";
            default -> " \ud83e\uddea";
        };
    }

    @NotNull
    private static class_2561 createFilterLine(@NotNull String text, boolean isActive) {
        return UtilChat.formatMessage((String)(MoveLearner.getInstance().getGuiConfig().getFilterSymbol() + (isActive ? "&f" : "&7") + text));
    }
}

