/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.ui;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.common.collect.Lists;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.item.UtilItem;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.config.GuiConfig;
import com.vecoo.movelearner.ui.ButtonLore;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import com.vecoo.movelearner.util.Utils;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class Buttons {
    @NotNull
    public static GuiElementBuilder getFillerButton() {
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)MoveLearner.getInstance().getGuiConfig().getFillerItem())).setName((class_2561)class_2561.method_43473());
    }

    @NotNull
    public static GuiElementBuilder getInformationButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getInformationItem())).setName(UtilChat.formatMessage((String)guiConfig.getInformationName())).setLore((List)Lists.newArrayList((Object[])new class_2561[]{UtilChat.formatMessage((String)guiConfig.getInformationLore())}));
    }

    @NotNull
    public static GuiElementBuilder getPokemonButton(@NotNull Pokemon pokemon) {
        return new GuiElementBuilder(PokemonItem.from((Pokemon)pokemon)).setName((class_2561)pokemon.getDisplayName(false)).setLore(ButtonLore.getPokemonMovesLore(pokemon));
    }

    @NotNull
    public static GuiElementBuilder getEmptyPokemonButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getEmptyPokemonItem())).setName(UtilChat.formatMessage((String)guiConfig.getEmptyPokemonName()));
    }

    @NotNull
    public static GuiElementBuilder getMoveButton(@NotNull Pokemon pokemon, @NotNull MoveTemplate move) {
        return new GuiElementBuilder(Utils.getItemTM(move)).setName((class_2561)move.getDisplayName()).setLore(ButtonLore.getMoveLore(pokemon, move));
    }

    @NotNull
    public static GuiElementBuilder getPreviousPageButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getPreviousPageItem())).setName(UtilChat.formatMessage((String)guiConfig.getPreviousPageName()));
    }

    @NotNull
    public static GuiElementBuilder getNextPageButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getNextPageItem())).setName(UtilChat.formatMessage((String)guiConfig.getNextPageName()));
    }

    @NotNull
    public static GuiElementBuilder getFilterButton(@NotNull MoveFilter filter) {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getFilterItem())).setName(UtilChat.formatMessage((String)guiConfig.getFilterName())).setLore(ButtonLore.getFilterLore(filter));
    }

    @NotNull
    public static GuiElementBuilder getBackButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getBackItem())).setName(UtilChat.formatMessage((String)guiConfig.getBackName()));
    }

    @NotNull
    public static GuiElementBuilder getCancelButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getCancelItem())).setName(UtilChat.formatMessage((String)guiConfig.getCancelName()));
    }

    @NotNull
    public static GuiElementBuilder getComingButton() {
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)MoveLearner.getInstance().getGuiConfig().getComingItem())).setName((class_2561)class_2561.method_43473());
    }

    @NotNull
    public static GuiElementBuilder getAcceptButton() {
        GuiConfig guiConfig = MoveLearner.getInstance().getGuiConfig();
        return new GuiElementBuilder(UtilItem.parseItemCustomModel((String)guiConfig.getAcceptItem())).setName(UtilChat.formatMessage((String)guiConfig.getAcceptName()));
    }
}

