/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.api.factory;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.item.UtilItem;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.api.events.LearnEvent;
import com.vecoo.movelearner.config.LocaleConfig;
import com.vecoo.movelearner.ui.pages.AcceptPage;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import com.vecoo.movelearner.util.Utils;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveLearnerFactoryUI {
    public static void openPage(@NotNull ServerPlayer player, @Nullable Pokemon pokemon, @NotNull SimpleGui page) {
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (pokemon == null || partyStore.get(pokemon.getUuid()) == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getNotPokemon()));
            GuiHelpers.close((ServerPlayer)player);
            return;
        }
        page.openForce();
    }

    public static void learnMoveItem(@NotNull ServerPlayer player, @NotNull AcceptPage page) {
        LocaleConfig localeConfig = MoveLearner.getInstance().getLocale();
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        Pokemon pokemon = page.getPreviousPage().getPokemon();
        if (pokemon == null || partyStore.get(pokemon.getUuid()) == null) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotPokemon()));
            GuiHelpers.close((ServerPlayer)player);
            return;
        }
        MoveSet moveset = pokemon.getMoveSet();
        if (Utils.isLearnedMove(pokemon, page.getMove())) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getAlreadyMove().replace("%pokemon%", pokemon.getDisplayName(false).getString()).replace("%move%", page.getMove().getDisplayName().getString())));
            page.getPreviousPage().openForce();
            return;
        }
        ItemStack itemStack = UtilItem.parseItemCustomModel((String)MoveLearner.getInstance().getConfig().getItemPriceMove());
        if (itemStack.isEmpty()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotValidItem()));
            GuiHelpers.close((ServerPlayer)player);
            return;
        }
        int price = Utils.getMovePrice(pokemon, page.getMove());
        if (!MoveLearnerFactoryUI.buyItem(player, pokemon, page.getMove(), itemStack, price)) {
            return;
        }
        if (!moveset.hasSpace()) {
            pokemon.getBenchedMoves().add(new BenchedMove(page.getMove(), 0));
        } else {
            moveset.add(page.getMove().create());
        }
        page.getPreviousPage().openForce();
        if (price > 0) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getBuyMoveItem().replace("%move%", page.getMove().getDisplayName().getString()).replace("%pokemon%", pokemon.getDisplayName(false).getString()).replace("%amount%", String.valueOf(price))));
        } else {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getBuyMoveFree().replace("%move%", page.getMove().getDisplayName().getString()).replace("%pokemon%", pokemon.getDisplayName(false).getString())));
        }
    }

    public static void learnMoveItem(@NotNull ServerPlayer player, @NotNull MoveTemplate move, @NotNull Pokemon pokemon, @NotNull MoveFilter filter, @NotNull String search, int price) {
        MoveLearnerFactoryUI.learnMoveItem(player, new AcceptPage(player, move, pokemon, filter, search, price));
    }

    private static boolean buyItem(@NotNull ServerPlayer player, @NotNull Pokemon pokemon, @NotNull MoveTemplate move, @NotNull ItemStack itemStack, int amount) {
        if (MoveLearner.getInstance().getConfig().isItemStrongTags()) {
            if (UtilPlayer.countItemStack((ServerPlayer)player, (ItemStack)itemStack) < amount) {
                MoveLearnerFactoryUI.sendNotItemsMessage(player, amount);
                return false;
            }
            if (((LearnEvent.BuyItem)NeoForge.EVENT_BUS.post((Event)new LearnEvent.BuyItem(player, pokemon, move.create(), itemStack, amount))).isCanceled()) {
                return false;
            }
            UtilPlayer.removeItemStack((ServerPlayer)player, (ItemStack)itemStack, (int)amount);
        } else {
            if (UtilPlayer.countItemStackTag((ServerPlayer)player, (ItemStack)itemStack, (DataComponentType)DataComponents.CUSTOM_MODEL_DATA) < amount) {
                MoveLearnerFactoryUI.sendNotItemsMessage(player, amount);
                return false;
            }
            if (((LearnEvent.BuyItem)NeoForge.EVENT_BUS.post((Event)new LearnEvent.BuyItem(player, pokemon, move.create(), itemStack, amount))).isCanceled()) {
                return false;
            }
            UtilPlayer.removeItemStackTag((ServerPlayer)player, (ItemStack)itemStack, (DataComponentType)DataComponents.CUSTOM_MODEL_DATA, (int)amount);
        }
        return true;
    }

    private static void sendNotItemsMessage(@NotNull ServerPlayer player, int amount) {
        player.sendSystemMessage(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getNotItems().replace("%amount%", String.valueOf(amount))));
        GuiHelpers.close((ServerPlayer)player);
    }
}

