/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.ui.pages.SelectPokemonPage;
import com.vecoo.movelearner.util.PermissionNodes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class LearnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"learn").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEARN_COMMAND))).executes(e -> LearnCommand.executeLearn(((CommandSourceStack)e.getSource()).getPlayerOrException()))).then(((LiteralArgumentBuilder)Commands.literal((String)"open").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEARN_OPEN_COMMAND))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(e -> LearnCommand.executeLearnPlayer((CommandSourceStack)e.getSource(), EntityArgument.getPlayer((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEARN_RELOAD_COMMAND))).executes(e -> LearnCommand.executeReload((CommandSourceStack)e.getSource()))));
    }

    private static int executeLearn(@NotNull ServerPlayer player) {
        new SelectPokemonPage(player).reOpen();
        return 1;
    }

    private static int executeLearnPlayer(@NotNull CommandSourceStack source, @NotNull ServerPlayer player) {
        new SelectPokemonPage(player).reOpen();
        source.sendSystemMessage(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getOpenLearn().replace("%player%", player.getName().getString())));
        return 1;
    }

    private static int executeReload(@NotNull CommandSourceStack source) {
        MoveLearner.getInstance().loadConfig();
        source.sendSystemMessage(UtilChat.formatMessage((String)MoveLearner.getInstance().getLocale().getReload()));
        return 1;
    }
}

