/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.ui.pages;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.movelearner.MoveLearner;
import com.vecoo.movelearner.api.factory.MoveLearnerFactoryUI;
import com.vecoo.movelearner.config.GuiConfig;
import com.vecoo.movelearner.ui.Buttons;
import com.vecoo.movelearner.ui.pages.SelectMovePage;
import com.vecoo.movelearner.ui.settings.MoveFilter;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class AcceptPage
extends SimpleGui {
    private final GuiConfig GUI_CONFIG = MoveLearner.getInstance().getGuiConfig();
    private final MoveTemplate move;
    private final SelectMovePage previousPage;

    public AcceptPage(@NotNull ServerPlayer player, @NotNull MoveTemplate move, @NotNull SelectMovePage previousPage) {
        super(MenuType.GENERIC_9x3, player, false);
        this.move = move;
        this.previousPage = previousPage;
        this.setTitle(UtilChat.formatMessage((String)this.GUI_CONFIG.getAcceptTitle()));
        this.setLockPlayerInventory(true);
        this.fillAllSlotsWithFiller();
        this.addCancelButton();
        this.addMoveButton();
        this.addComingButton();
        this.addPokemonButton();
        this.addAcceptButton();
    }

    public AcceptPage(@NotNull ServerPlayer player, @NotNull MoveTemplate move, @NotNull Pokemon pokemon, @NotNull MoveFilter filter, @NotNull String search, int page) {
        this(player, move, new SelectMovePage(player, pokemon, filter, search, page));
    }

    @NotNull
    public MoveTemplate getMove() {
        return this.move;
    }

    @NotNull
    public SelectMovePage getPreviousPage() {
        return this.previousPage;
    }

    private void fillAllSlotsWithFiller() {
        if (this.GUI_CONFIG.isFillerSureUI()) {
            IntStream.rangeClosed(0, 26).forEach(i -> this.setSlot(i, (GuiElementBuilderInterface)Buttons.getFillerButton()));
        }
    }

    private void addCancelButton() {
        this.setSlot(10, Buttons.getCancelButton().setCallback(() -> MoveLearnerFactoryUI.openPage(this.player, this.previousPage.getPokemon(), this.previousPage)));
    }

    private void addMoveButton() {
        this.setSlot(12, (GuiElementBuilderInterface)Buttons.getMoveButton(Objects.requireNonNull(this.previousPage.getPokemon()), this.move));
    }

    private void addComingButton() {
        this.setSlot(13, (GuiElementBuilderInterface)Buttons.getComingButton());
    }

    private void addPokemonButton() {
        this.setSlot(14, (GuiElementBuilderInterface)Buttons.getPokemonButton(Objects.requireNonNull(this.previousPage.getPokemon())));
    }

    private void addAcceptButton() {
        this.setSlot(16, Buttons.getAcceptButton().setCallback(() -> MoveLearnerFactoryUI.learnMoveItem(this.player, this)));
    }
}

