/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.movelearner.util;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.vecoo.movelearner.MoveLearner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static ItemStack getItemTM(@NotNull MoveTemplate move) {
        ItemStack itemStack = CobblemonItems.NORMAL_GEM.getDefaultInstance();
        switch (move.getElementalType().getName()) {
            case "Bug": {
                itemStack = CobblemonItems.BUG_GEM.getDefaultInstance();
                break;
            }
            case "Dark": {
                itemStack = CobblemonItems.DARK_GEM.getDefaultInstance();
                break;
            }
            case "Dragon": {
                itemStack = CobblemonItems.DRAGON_GEM.getDefaultInstance();
                break;
            }
            case "Electric": {
                itemStack = CobblemonItems.ELECTRIC_GEM.getDefaultInstance();
                break;
            }
            case "Fairy": {
                itemStack = CobblemonItems.FAIRY_GEM.getDefaultInstance();
                break;
            }
            case "Ice": {
                itemStack = CobblemonItems.ICE_GEM.getDefaultInstance();
                break;
            }
            case "Ghost": {
                itemStack = CobblemonItems.GHOST_GEM.getDefaultInstance();
                break;
            }
            case "Flying": {
                itemStack = CobblemonItems.FLYING_GEM.getDefaultInstance();
                break;
            }
            case "Fighting": {
                itemStack = CobblemonItems.FIGHTING_GEM.getDefaultInstance();
                break;
            }
            case "Ground": {
                itemStack = CobblemonItems.GROUND_GEM.getDefaultInstance();
                break;
            }
            case "Normal": {
                itemStack = CobblemonItems.NORMAL_GEM.getDefaultInstance();
                break;
            }
            case "Psychic": {
                itemStack = CobblemonItems.PSYCHIC_GEM.getDefaultInstance();
                break;
            }
            case "Rock": {
                itemStack = CobblemonItems.ROCK_GEM.getDefaultInstance();
                break;
            }
            case "Fire": {
                itemStack = CobblemonItems.FIRE_GEM.getDefaultInstance();
                break;
            }
            case "Poison": {
                itemStack = CobblemonItems.POISON_GEM.getDefaultInstance();
                break;
            }
            case "Steel": {
                itemStack = CobblemonItems.STEEL_GEM.getDefaultInstance();
                break;
            }
            case "Grass": {
                itemStack = CobblemonItems.GRASS_GEM.getDefaultInstance();
                break;
            }
            case "Water": {
                itemStack = CobblemonItems.WATER_GEM.getDefaultInstance();
            }
        }
        return itemStack;
    }

    public static int getMovePrice(@NotNull Pokemon pokemon, @NotNull MoveTemplate move) {
        Learnset moves = pokemon.getForm().getMoves();
        if (moves.getLevelUpMoves().values().stream().anyMatch(list -> list.contains(move))) {
            return MoveLearner.getInstance().getConfig().getLevelMovePrice();
        }
        if (moves.getTmMoves().contains(move)) {
            return MoveLearner.getInstance().getConfig().getTmMovePrice();
        }
        if (moves.getLegacyMoves().contains(move)) {
            return MoveLearner.getInstance().getConfig().getLegacyMovePrice();
        }
        if (moves.getTutorMoves().contains(move)) {
            return MoveLearner.getInstance().getConfig().getTutorMovePrice();
        }
        if (moves.getSpecialMoves().contains(move)) {
            return MoveLearner.getInstance().getConfig().getSpecialMovePrice();
        }
        if (moves.getEggMoves().contains(move)) {
            return MoveLearner.getInstance().getConfig().getEggMovePrice();
        }
        return 0;
    }

    @NotNull
    public static List<MoveTemplate> getAllMoves(@NotNull Learnset moves) {
        ArrayList<MoveTemplate> allMoveList = new ArrayList<MoveTemplate>();
        allMoveList.addAll(moves.getAllLegalMoves());
        allMoveList.addAll(moves.getLegacyMoves());
        allMoveList.addAll(moves.getSpecialMoves());
        return allMoveList;
    }

    public static boolean isLearnedMove(@NotNull Pokemon pokemon, @NotNull MoveTemplate move) {
        HashSet<MoveTemplate> moves = new HashSet<MoveTemplate>(pokemon.getAllAccessibleMoves());
        for (Move learnedMove : pokemon.getMoveSet().getMoves()) {
            moves.add(learnedMove.getTemplate());
        }
        return moves.contains(move);
    }

    @NotNull
    public static String getStatMoveFormat(double stat) {
        if (stat <= 0.0) {
            return "-";
        }
        return String.valueOf(stat);
    }
}

