/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib;

import dev.xylonity.knightlib.platform.KnightLibNetwork;
import dev.xylonity.knightlib.platform.KnightLibPlatform;
import dev.xylonity.knightlib.platform.KnightLibRegistrar;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightlib.registry.KnightLibEntities;
import dev.xylonity.knightlib.registry.KnightLibItems;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.EnumSet;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnightLib {
    public static final String MOD_ID = "knightlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"KnightLib");
    public static final KnightLibPlatform PLATFORM = ServiceLoader.load(KnightLibPlatform.class).findFirst().orElseThrow();
    public static final KnightLibRegistrar REGISTRAR = ServiceLoader.load(KnightLibRegistrar.class).findFirst().orElseThrow();
    public static final KnightLibNetwork NETWORK = ServiceLoader.load(KnightLibNetwork.class).findFirst().orElseThrow();
    private static volatile EnumSet<Usage> ENABLED = EnumSet.noneOf(Usage.class);

    protected static void init() {
        KnightLibEntities.ENTITIES.init();
        KnightLibBlocks.BLOCKS.init();
        KnightLibItems.ITEMS.init();
        KnightLibParticles.PARTICLES.init();
        KnightLibBlockEntities.BLOCK_ENTITIES.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Usage ... usages) {
        if (usages == null || usages.length == 0) {
            return;
        }
        Class<KnightLib> clazz = KnightLib.class;
        synchronized (KnightLib.class) {
            EnumSet<Usage> next = ENABLED.isEmpty() ? EnumSet.noneOf(Usage.class) : EnumSet.copyOf(ENABLED);
            boolean changed = false;
            for (Usage usage : usages) {
                if (next.contains((Object)usage)) continue;
                next.add(usage);
                changed = true;
                LOGGER.info("The following content usage has been enabled: {}", (Object)usage);
            }
            if (changed) {
                ENABLED = next;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void initialize() {
        KnightLib.initialize(Usage.ALL);
    }

    public static boolean isEnabled(Usage usage) {
        EnumSet<Usage> should = ENABLED;
        return should.contains((Object)Usage.ALL) || should.contains((Object)usage);
    }

    public static enum Usage {
        ALL,
        GREEN_ESSENCES,
        GREAT_CHALICE,
        COPPER_GRAILS,
        HOMUNCULUS;

    }
}

