/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.platform;

import dev.xylonity.knightlib.KnightLib;
import dev.xylonity.knightlib.network.ClientboundPacketType;
import dev.xylonity.knightlib.network.PacketType;
import dev.xylonity.knightlib.network.ServerboundPacketType;
import dev.xylonity.knightlib.platform.KnightLibNetwork;
import io.netty.buffer.Unpooled;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class KnightLibNetworkFabric
implements KnightLibNetwork {
    private static final Map<Class<?>, PacketType<?>> CLASS_TO_TYPE = new ConcurrentHashMap();

    @Override
    public <T> void registerClientbound(PacketType<T> type, Consumer<T> clientHandler) {
        KnightLibNetworkFabric.memoize(type);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientOnly.registerClientbound(type, clientHandler);
        }
    }

    @Override
    public <T> void registerServerbound(PacketType<T> type, BiConsumer<T, class_3222> serverHandler) {
        KnightLibNetworkFabric.memoize(type);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)type.id(), (server, player, handler, buf, sender) -> {
            Object message = type.codec().decode(buf);
            server.execute(() -> serverHandler.accept(message, player));
        });
    }

    @Override
    public <T> void register(ClientboundPacketType<T> type) {
        this.registerClientbound(type.base(), type.handler());
    }

    @Override
    public <T> void register(ServerboundPacketType<T> type) {
        this.registerServerbound(type.base(), type.handler());
    }

    @Override
    public <T> void sendToServer(T message) {
        PacketType<?> type = CLASS_TO_TYPE.get(message.getClass());
        if (type == null) {
            throw new IllegalStateException("[KnightLib] No packet registered for message: " + message.getClass().getName());
        }
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            KnightLib.LOGGER.warn("sendToServer called on server for {}", (Object)type.id());
            return;
        }
        ClientOnly.sendToServer(type, message);
    }

    @Override
    public <T> void sendTo(class_3222 player, PacketType<T> type, T message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        type.codec().encode(message, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)type.id(), (class_2540)buf);
    }

    @Override
    public <T> void sendToAll(MinecraftServer server, PacketType<T> type, T message) {
        class_2540 outBuf = new class_2540(Unpooled.buffer());
        type.codec().encode(message, outBuf);
        for (class_3222 player : server.method_3760().method_14571()) {
            class_2540 buf = new class_2540(outBuf.copy());
            ServerPlayNetworking.send((class_3222)player, (class_2960)type.id(), (class_2540)buf);
        }
        outBuf.release();
    }

    @Override
    public <T> void sendToPlayers(class_1937 level, PacketType<T> type, T message) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        class_2540 outBuf = new class_2540(Unpooled.buffer());
        type.codec().encode(message, outBuf);
        for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
            class_2540 buf = new class_2540(outBuf.copy());
            ServerPlayNetworking.send((class_3222)player, (class_2960)type.id(), (class_2540)buf);
        }
        outBuf.release();
    }

    @Override
    public <T> void sendToTracking(class_1937 level, class_2338 pos, PacketType<T> type, T message) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        class_2540 outBuf = new class_2540(Unpooled.buffer());
        type.codec().encode(message, outBuf);
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverLevel, (class_2338)pos)) {
            class_2540 buf = new class_2540(outBuf.copy());
            ServerPlayNetworking.send((class_3222)player, (class_2960)type.id(), (class_2540)buf);
        }
        outBuf.release();
    }

    @Override
    public <T> void sendToTracking(class_1297 entity, PacketType<T> type, T message) {
        if (!(entity.method_37908() instanceof class_3218)) {
            return;
        }
        class_2540 outBuf = new class_2540(Unpooled.buffer());
        type.codec().encode(message, outBuf);
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            class_2540 buf = new class_2540(outBuf.copy());
            ServerPlayNetworking.send((class_3222)player, (class_2960)type.id(), (class_2540)buf);
        }
        outBuf.release();
    }

    private static <T> void memoize(PacketType<T> type) {
        CLASS_TO_TYPE.put(type.clazz(), type);
    }

    private static final class ClientOnly {
        private static final Map<class_2960, Boolean> CLIENT_HANDLERS = new IdentityHashMap<class_2960, Boolean>();

        private ClientOnly() {
        }

        private static <T> void registerClientbound(PacketType<T> type, Consumer<T> clientHandler) {
            if (CLIENT_HANDLERS.putIfAbsent(type.id(), Boolean.TRUE) != null) {
                return;
            }
            ClientPlayNetworking.registerGlobalReceiver((class_2960)type.id(), (client, handler, buf, sender) -> {
                Object msg = type.codec().decode(buf);
                client.execute(() -> clientHandler.accept(msg));
            });
        }

        private static <T> void sendToServer(PacketType<T> type, T message) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            type.codec().encode(message, buf);
            ClientPlayNetworking.send((class_2960)type.id(), (class_2540)buf);
        }
    }
}

