/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.block;

import dev.xylonity.knightlib.api.interop.IGreatChaliceInteractable;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GreatChaliceBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.m_49796_((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public GreatChaliceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return KnightLibBlockEntities.GREAT_CHALICE.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == KnightLibBlockEntities.GREAT_CHALICE.get() ? GreatChaliceBlockEntity::tick : null;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof GreatChaliceBlockEntity)) {
            return InteractionResult.PASS;
        }
        GreatChaliceBlockEntity chalice = (GreatChaliceBlockEntity)blockEntity;
        ItemStack stack = pPlayer.m_21120_(pHand);
        Item item = stack.m_41720_();
        if (item instanceof IGreatChaliceInteractable) {
            IGreatChaliceInteractable actor = (IGreatChaliceInteractable)item;
            if (!actor.canInteract(chalice, pLevel, pPlayer)) {
                return InteractionResult.PASS;
            }
            actor.onPreInteraction(chalice, pPlayer, pLevel, pHit);
            int total = chalice.getCharges() + actor.getChargesToApply();
            if (total < 0 || total > 12) {
                return InteractionResult.PASS;
            }
            chalice.setCharges(total);
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41774_(actor.shrinkItemAmount());
            }
            if (!actor.getRewards().isEmpty()) {
                for (ItemStack e : actor.getRewards()) {
                    ItemEntity entity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + (double)pPlayer.m_20206_() * 0.5, (double)pPos.m_123343_(), e);
                    pLevel.m_7967_((Entity)entity);
                }
            }
            if (!actor.getInteractionSounds().isEmpty()) {
                for (SoundEvent sound : actor.getInteractionSounds()) {
                    pLevel.m_5594_(null, pPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (chalice.getCharges() == 12) {
                pLevel.m_5594_(null, pPos, actor.getFullChargeSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            actor.onPostInteraction(chalice, pPlayer, pLevel, pHit);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }
}

