/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.event;

import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="knightlib")
public class KnightLibCommonEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        TickScheduler.clean();
        for (ServerLevel level : event.getServer().m_129785_()) {
            TickScheduler.incrementTick((Level)level);
            TickScheduler.processServerTasks((Level)level);
            TickScheduler.processCommonTasks((Level)level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            TickScheduler.markForClean(level);
        }
    }
}

