/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.idb;

import co.aikar.idb.Database;
import co.aikar.idb.DatabaseOptions;
import co.aikar.idb.DatabaseTiming;
import co.aikar.idb.TimingsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class BaseDatabase
implements Database {
    private TimingsProvider timingsProvider;
    private DatabaseTiming sqlTiming;
    private Logger logger;
    private DatabaseOptions options;
    private ExecutorService threadPool;
    DataSource dataSource;

    public BaseDatabase(DatabaseOptions options) {
        this.options = options;
        if (options.driverClassName != null && !options.favorDataSourceOverDriver) {
            options.dataSourceClassName = null;
        }
        if (options.driverClassName == null && options.dataSourceClassName == null) {
            throw new NullPointerException("Both driverClassName and dataSourceClassName can not be null. Please load an appropriate DataSource or Driver.");
        }
        this.timingsProvider = options.timingsProvider;
        this.threadPool = options.executor;
        if (this.threadPool == null) {
            this.threadPool = new ThreadPoolExecutor(options.minAsyncThreads, options.maxAsyncThreads, options.asyncThreadTimeout, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            ((ThreadPoolExecutor)this.threadPool).allowCoreThreadTimeOut(true);
        }
        this.sqlTiming = this.timingsProvider.of("Database");
        this.logger = options.logger;
        if (this.logger == null) {
            this.logger = Logger.getLogger(options.poolName);
        }
        this.logger.info("Connecting to Database: " + options.dsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long timeout, TimeUnit unit) {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            this.logException(e);
        }
        if (this.dataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)this.dataSource)).close();
            }
            catch (IOException e) {
                this.logException(e);
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    @Override
    public synchronized <T> CompletableFuture<T> dispatchAsync(Callable<T> task) {
        CompletableFuture future = new CompletableFuture();
        Runnable run = () -> {
            try {
                future.complete(task.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        if (this.threadPool == null) {
            run.run();
        } else {
            this.threadPool.submit(run);
        }
        return future;
    }

    @Override
    public DatabaseTiming timings(String name) {
        return this.timingsProvider.of(this.options.poolName + " - " + name, this.sqlTiming);
    }

    @Override
    public DatabaseOptions getOptions() {
        return this.options;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource != null ? this.dataSource.getConnection() : null;
    }
}

